/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.http;

import com.streamscape.lib.http.AuthorizationInfo;
import com.streamscape.lib.http.AuthorizationPrompter;
import com.streamscape.lib.http.NVPair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class SimpleAuthPrompt
implements AuthorizationPrompter {
    SimpleAuthPrompt() {
    }

    @Override
    public NVPair getUsernamePassword(AuthorizationInfo challenge, boolean forProxy) {
        String pass;
        String user;
        if (challenge.getScheme().equalsIgnoreCase("SOCKS5")) {
            System.out.println("Enter username and password for SOCKS server on host " + challenge.getHost());
            System.out.println("Authentication Method: username/password");
        } else {
            System.out.println("Enter username and password for realm `" + challenge.getRealm() + "' on host " + challenge.getHost() + ":" + challenge.getPort());
            System.out.println("Authentication Scheme: " + challenge.getScheme());
        }
        BufferedReader inp = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Username: ");
        System.out.flush();
        try {
            user = inp.readLine();
        }
        catch (IOException ioe) {
            return null;
        }
        if (user == null || user.length() == 0) {
            return null;
        }
        SimpleAuthPrompt.echo(false);
        System.out.print("Password: ");
        System.out.flush();
        try {
            pass = inp.readLine();
        }
        catch (IOException ioe) {
            return null;
        }
        System.out.println();
        SimpleAuthPrompt.echo(true);
        if (pass == null) {
            return null;
        }
        return new NVPair(user, pass);
    }

    private static void echo(boolean on) {
        String os = System.getProperty("os.name");
        String[] cmd = null;
        if (os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("Windows NT")) {
            cmd = new String[]{"echo", on ? "on" : "off"};
        } else if (!(os.equalsIgnoreCase("Windows") || os.equalsIgnoreCase("16-bit Windows") || os.equalsIgnoreCase("OS/2") || os.equalsIgnoreCase("Mac OS") || os.equalsIgnoreCase("MacOS"))) {
            cmd = os.equalsIgnoreCase("OpenVMS") || os.equalsIgnoreCase("VMS") ? new String[]{"SET TERMINAL " + (on ? "/ECHO" : "/NOECHO")} : new String[]{"/bin/sh", "-c", "stty " + (on ? "echo" : "-echo") + " < /dev/tty"};
        }
        if (cmd != null) {
            try {
                Runtime.getRuntime().exec(cmd).waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean canUseCLPrompt() {
        String os = System.getProperty("os.name");
        return os.indexOf("Linux") >= 0 || os.indexOf("SunOS") >= 0 || os.indexOf("Solaris") >= 0 || os.indexOf("BSD") >= 0 || os.indexOf("AIX") >= 0 || os.indexOf("HP-UX") >= 0 || os.indexOf("IRIX") >= 0 || os.indexOf("OSF") >= 0 || os.indexOf("A/UX") >= 0 || os.indexOf("VMS") >= 0;
    }
}

