/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.http;

import com.streamscape.Trace;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLContextFactory {
    public static final String CERTIFICATE_FACTORY_DEFAULT = "X.509";
    public static final String KEYSTORE_TYPE_DEFAULT = "JKS";
    public static final String KEYMANAGER_ALGORITHM_DEFAULT = "SunX509";
    public static final String TRUSTMANAGER_ALGORITHM_DEFAULT = "PKIX";
    protected String protocol = "TLS";
    protected KeyManager[] keymanagers = null;
    protected SecureRandom random = new SecureRandom();
    protected X509TrustManagersChain x509TrustManagersChain = null;

    public SSLContext createSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustManagerArray;
        SSLContext sslcontext = SSLContext.getInstance(this.protocol);
        if (this.x509TrustManagersChain != null) {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = this.x509TrustManagersChain;
        } else {
            trustManagerArray = null;
        }
        sslcontext.init(this.keymanagers, trustManagerArray, this.random);
        return sslcontext;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setRandom(SecureRandom random) {
        this.random = random;
    }

    public void setKeyStore(String keyStoreFile, String password) throws Exception {
        this.keymanagers = SSLContextFactory.createKeyManagers(SSLContextFactory.readKeyStore(keyStoreFile, password), password);
    }

    public void setKeyStore(RandomAccessFile keyStoreFile, String password) throws Exception {
        this.keymanagers = SSLContextFactory.createKeyManagers(SSLContextFactory.readKeyStore(keyStoreFile, password), password);
    }

    public void setKeyStore(byte[] keyStoreFileData, String password) throws Exception {
        this.keymanagers = SSLContextFactory.createKeyManagers(SSLContextFactory.readKeyStore(keyStoreFileData, password), password);
    }

    public void addTrustStore(String trustStoreFile, String password) throws Exception {
        TrustManager[] managers = SSLContextFactory.createTrustManagers(SSLContextFactory.readKeyStore(trustStoreFile, password));
        this.addTrustManagers(managers);
    }

    public void addTrustStore(RandomAccessFile trustStoreFile, String password) throws Exception {
        TrustManager[] managers = SSLContextFactory.createTrustManagers(SSLContextFactory.readKeyStore(trustStoreFile, password));
        this.addTrustManagers(managers);
    }

    public void addTrustStore(byte[] trustStoreFileData, String password) throws Exception {
        TrustManager[] managers = SSLContextFactory.createTrustManagers(SSLContextFactory.readKeyStore(trustStoreFileData, password));
        this.addTrustManagers(managers);
    }

    public void addDefaultTrustStore() throws NoSuchAlgorithmException, KeyStoreException {
        this.addTrustManagers(SSLContextFactory.getDefaultTrustManagers());
    }

    public void addTrustCertificate(String alias, String certificateFile) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        Certificate certificate = SSLContextFactory.readCertificate(certificateFile);
        KeyStore trustStore = KeyStore.getInstance(KEYSTORE_TYPE_DEFAULT);
        trustStore.load(null, null);
        trustStore.setCertificateEntry(alias, certificate);
        TrustManager[] trustmanagers = SSLContextFactory.createTrustManagers(trustStore);
        this.addTrustManagers(trustmanagers);
    }

    public void trustAllCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCertsManagers = new TrustManager[]{new X509TrustManager(this){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        this.addTrustManagers(trustAllCertsManagers);
    }

    public void addTrustManagers(TrustManager[] trustmanagers) {
        if (trustmanagers == null) {
            return;
        }
        for (TrustManager trustmanager : trustmanagers) {
            if (trustmanager instanceof X509TrustManager) {
                if (this.x509TrustManagersChain == null) {
                    this.x509TrustManagersChain = new X509TrustManagersChain();
                }
                this.x509TrustManagersChain.addTrustManager((X509TrustManager)trustmanager);
                continue;
            }
            Trace.logError(SSLContextFactory.class, "Unsupported TrustManager: " + trustmanager.toString());
        }
    }

    private static KeyManager[] createKeyManagers(KeyStore keyStore, String password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KEYMANAGER_ALGORITHM_DEFAULT);
        kmfactory.init(keyStore, password != null ? password.toCharArray() : null);
        return kmfactory.getKeyManagers();
    }

    private static TrustManager[] createTrustManagers(KeyStore trustStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TRUSTMANAGER_ALGORITHM_DEFAULT);
        tmfactory.init(trustStore);
        return tmfactory.getTrustManagers();
    }

    private static TrustManager[] getDefaultTrustManagers() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TRUSTMANAGER_ALGORITHM_DEFAULT);
        tmfactory.init((KeyStore)null);
        return tmfactory.getTrustManagers();
    }

    private static void mergeKeyStores(KeyStore toKeyStore, KeyStore fromKeyStore) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        Enumeration<String> e = fromKeyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (toKeyStore.containsAlias(alias)) {
                Trace.logDebug(SSLContextFactory.class, "KeyStore already contains alias: " + alias + " will be replaced.");
            }
            KeyStore.Entry entry = fromKeyStore.getEntry(alias, null);
            toKeyStore.setEntry(alias, entry, null);
        }
    }

    private static KeyStore readKeyStore(RandomAccessFile keyStoreFile, String keystorePassword) throws Exception {
        byte[] bytes = new byte[(int)keyStoreFile.length()];
        keyStoreFile.readFully(bytes);
        return SSLContextFactory.readKeyStore(new ByteArrayInputStream(bytes), keystorePassword);
    }

    private static KeyStore readKeyStore(String keyStoreFile, String keystorePassword) throws Exception {
        return SSLContextFactory.readKeyStore(new FileInputStream(new File(keyStoreFile)), keystorePassword);
    }

    private static KeyStore readKeyStore(byte[] keyStoreFileData, String keystorePassword) throws Exception {
        return SSLContextFactory.readKeyStore(new ByteArrayInputStream(keyStoreFileData), keystorePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore readKeyStore(InputStream keyStoreStream, String keystorePassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE_DEFAULT);
        try {
            keyStore.load(keyStoreStream, keystorePassword != null ? keystorePassword.toCharArray() : null);
        }
        finally {
            try {
                keyStoreStream.close();
            }
            catch (Exception exception) {}
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Certificate readCertificate(String certificateFile) throws FileNotFoundException, CertificateException {
        Certificate certificate = null;
        FileInputStream instream = new FileInputStream(new File(certificateFile));
        try {
            CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_FACTORY_DEFAULT);
            certificate = cf.generateCertificate(instream);
        }
        finally {
            try {
                instream.close();
            }
            catch (Exception exception) {}
        }
        return certificate;
    }

    private static <T> T[] mergeArrays(T[] first, T[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    static class X509TrustManagersChain
    implements X509TrustManager {
        protected X509TrustManager[] trustmanagers = null;

        X509TrustManagersChain() {
        }

        public void addTrustManagers(X509TrustManager[] trustmanagers) {
            this.trustmanagers = SSLContextFactory.mergeArrays(this.trustmanagers, trustmanagers);
        }

        public void addTrustManager(X509TrustManager trustmanager) {
            this.trustmanagers = SSLContextFactory.mergeArrays(this.trustmanagers, new X509TrustManager[]{trustmanager});
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (int i = 0; i < this.trustmanagers.length; ++i) {
                try {
                    this.trustmanagers[i].checkClientTrusted(chain, authType);
                    continue;
                }
                catch (CertificateException e) {
                    if (i != this.trustmanagers.length - 1) continue;
                    throw e;
                }
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (int i = 0; i < this.trustmanagers.length; ++i) {
                try {
                    this.trustmanagers[i].checkServerTrusted(chain, authType);
                    continue;
                }
                catch (CertificateException e) {
                    if (i != this.trustmanagers.length - 1) continue;
                    throw e;
                }
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] ret = null;
            for (X509TrustManager trustmanager : this.trustmanagers) {
                ret = SSLContextFactory.mergeArrays(ret, trustmanager.getAcceptedIssuers());
            }
            return ret;
        }
    }
}

