/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.http;

import com.streamscape.lib.http.HTTPClient;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.NVPair;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.http.HTTPResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;

public class HTTPRequestExecutor {
    private HTTPClient httpClient;

    public HTTPRequestExecutor(HTTPClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponse execute(HTTPRequest request) throws IOException, ModuleException, ClientException {
        long oldTimeout = this.httpClient.getTimeout();
        if (request.getTimeout() > 0) {
            this.httpClient.setTimeout(request.getTimeout() * 1000);
        }
        try {
            HTTPResponse hTTPResponse = this.executeInternal(request);
            return hTTPResponse;
        }
        finally {
            this.httpClient.setTimeout(oldTimeout);
        }
    }

    private HTTPResponse executeInternal(HTTPRequest request) throws IOException, ModuleException, ClientException {
        HTTPClientResponse httpResponse;
        NVPair[] queryParams = this.mapToNVPair(request.getQueryParameters());
        NVPair[] formParams = this.mapToNVPair(request.getFormParameters());
        NVPair[] nvheaders = this.mapToNVPair(request.getHeaders());
        NVPair[] cookies = this.mapToNVPair(request.getCookies());
        if (request.getMethod().equalsIgnoreCase("get")) {
            httpResponse = this.httpClient.Get(request.getUri(), queryParams, nvheaders);
        } else if (request.getMethod().equalsIgnoreCase("post")) {
            if (request.getData() != null && request.getDataBytes().length > 0 && formParams != null) {
                throw new ClientException(1026, "Body data and form parameters cannot be specified together.");
            }
            httpResponse = formParams != null ? this.httpClient.Post(request.getUri(), queryParams, formParams, nvheaders) : this.httpClient.Post(request.getUri(), queryParams, request.getDataBytes(), nvheaders);
        } else if (request.getMethod().equalsIgnoreCase("options")) {
            httpResponse = this.httpClient.Options(request.getUri(), nvheaders, request.getDataBytes());
        } else if (request.getMethod().equalsIgnoreCase("put")) {
            httpResponse = this.httpClient.Put(request.getUri(), request.getDataBytes(), nvheaders);
        } else if (request.getMethod().equalsIgnoreCase("patch")) {
            httpResponse = this.httpClient.Patch(request.getUri(), request.getDataBytes(), nvheaders);
        } else if (request.getMethod().equalsIgnoreCase("delete")) {
            httpResponse = this.httpClient.Delete(request.getUri(), nvheaders);
        } else if (request.getMethod().equalsIgnoreCase("trace")) {
            httpResponse = this.httpClient.Trace(request.getUri(), nvheaders);
        } else if (request.getMethod().equalsIgnoreCase("head")) {
            httpResponse = this.httpClient.Head(request.getUri(), queryParams, nvheaders);
        } else {
            throw new ClientException(1026, "Unknown HTTP method in request: " + request.getMethod());
        }
        HTTPResponse response = new HTTPResponse(request);
        response.setStatusCode(httpResponse.getStatusCode());
        response.setReasonLine(httpResponse.getReasonLine());
        response.setVersion(httpResponse.getVersion());
        response.setEffectiveUri(httpResponse.getEffectiveURI().toExternalForm());
        response.setOriginalUri(httpResponse.getOriginalURI().toExternalForm());
        response.setData(httpResponse.getData());
        Enumeration headersList = httpResponse.listHeaders();
        while (headersList.hasMoreElements()) {
            String header = (String)headersList.nextElement();
            response.addHeader(header, httpResponse.getHeader(header));
        }
        Enumeration trailersList = httpResponse.listTrailers();
        while (trailersList.hasMoreElements()) {
            String trailer = (String)trailersList.nextElement();
            response.addTrailer(trailer, httpResponse.getTrailer(trailer));
        }
        return response;
    }

    private NVPair[] mapToNVPair(Map<String, String> map) {
        NVPair[] result = null;
        if (map != null && map.size() > 0) {
            result = new NVPair[map.size()];
            int count = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                result[count++] = new NVPair(entry.getKey(), entry.getValue());
            }
            result = Arrays.copyOf(result, count);
        }
        if (result != null && result.length == 0) {
            result = null;
        }
        return result;
    }
}

