/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.http;

import com.streamscape.Trace;
import com.streamscape.lib.http.CIHashtable;
import com.streamscape.lib.http.HTTPClientModule;
import com.streamscape.lib.http.HTTPClientModuleConstants;
import com.streamscape.lib.http.HttpOutputStream;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.ParseException;
import com.streamscape.lib.http.Request;
import com.streamscape.lib.http.Response;
import com.streamscape.lib.http.RetryException;
import com.streamscape.lib.http.URI;
import com.streamscape.lib.http.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;

public class HTTPClientResponse
implements HTTPClientModuleConstants {
    private HTTPClientModule[] modules;
    private int timeout;
    private Request request = null;
    Response response = null;
    private HttpOutputStream out_stream = null;
    private InputStream inp_stream;
    private int StatusCode;
    private String ReasonLine;
    private String Version;
    private URI OriginalURI = null;
    private URI EffectiveURI = null;
    private CIHashtable Headers = null;
    private CIHashtable Trailers = null;
    private int ContentLength = -1;
    private byte[] Data = null;
    private boolean initialized = false;
    private boolean got_trailers = false;
    private boolean aborted = false;
    private boolean retry = false;
    private String method = null;
    private boolean handle_trailers = false;
    private boolean trailers_handled = false;

    HTTPClientResponse(HTTPClientModule[] modules, int timeout, Request orig) {
        this.modules = modules;
        this.timeout = timeout;
        try {
            int qp = orig.getRequestURI().indexOf(63);
            this.OriginalURI = new URI(orig.getConnection().getProtocol(), null, orig.getConnection().getHost(), orig.getConnection().getPort(), qp < 0 ? orig.getRequestURI() : orig.getRequestURI().substring(0, qp), qp < 0 ? null : orig.getRequestURI().substring(qp + 1), null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.method = orig.getMethod();
    }

    void set(Request req, Response resp) {
        this.request = req;
        this.response = resp;
        resp.http_resp = this;
        resp.timeout = this.timeout;
        this.aborted = resp.final_resp;
    }

    void set(Request req, HttpOutputStream out_stream) {
        this.request = req;
        this.out_stream = out_stream;
    }

    public final int getStatusCode() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.StatusCode;
    }

    public final String getReasonLine() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.ReasonLine;
    }

    public final String getVersion() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.Version;
    }

    public final String getServer() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.getHeader("Server");
    }

    public final URI getOriginalURI() {
        return this.OriginalURI;
    }

    public final URL getEffectiveURL() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.EffectiveURI != null) {
            return this.EffectiveURI.toURL();
        }
        return null;
    }

    public final URI getEffectiveURI() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.EffectiveURI != null) {
            return this.EffectiveURI;
        }
        return this.OriginalURI;
    }

    public String getHeader(String hdr) throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return (String)this.Headers.get(hdr.trim());
    }

    public int getHeaderAsInt(String hdr) throws IOException, ModuleException, NumberFormatException {
        String val = this.getHeader(hdr);
        if (val == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(val);
    }

    public Date getHeaderAsDate(String hdr) throws IOException, IllegalArgumentException, ModuleException {
        Date date;
        Object raw_date = this.getHeader(hdr);
        if (raw_date == null) {
            return null;
        }
        if (((String)raw_date).toUpperCase().indexOf("GMT") == -1 && ((String)raw_date).indexOf(32) > 0) {
            raw_date = (String)raw_date + " GMT";
        }
        try {
            date = Util.parseHttpDate((String)raw_date);
        }
        catch (IllegalArgumentException iae) {
            long time;
            try {
                time = Long.parseLong((String)raw_date);
            }
            catch (NumberFormatException nfe) {
                throw iae;
            }
            if (time < 0L) {
                time = 0L;
            }
            date = new Date(time * 1000L);
        }
        return date;
    }

    public Enumeration listHeaders() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.Headers.keys();
    }

    public String getTrailer(String trailer) throws IOException, ModuleException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return (String)this.Trailers.get(trailer.trim());
    }

    public int getTrailerAsInt(String trailer) throws IOException, ModuleException, NumberFormatException {
        String val = this.getTrailer(trailer);
        if (val == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(val);
    }

    public Date getTrailerAsDate(String trailer) throws IOException, IllegalArgumentException, ModuleException {
        Date date;
        Object raw_date = this.getTrailer(trailer);
        if (raw_date == null) {
            return null;
        }
        if (((String)raw_date).toUpperCase().indexOf("GMT") == -1 && ((String)raw_date).indexOf(32) > 0) {
            raw_date = (String)raw_date + " GMT";
        }
        try {
            date = Util.parseHttpDate((String)raw_date);
        }
        catch (IllegalArgumentException iae) {
            long time;
            try {
                time = Long.parseLong((String)raw_date);
            }
            catch (NumberFormatException nfe) {
                throw iae;
            }
            if (time < 0L) {
                time = 0L;
            }
            date = new Date(time * 1000L);
        }
        return date;
    }

    public Enumeration listTrailers() throws IOException, ModuleException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return this.Trailers.keys();
    }

    public synchronized byte[] getData() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.Data == null) {
            try {
                this.readResponseData(this.inp_stream);
            }
            catch (InterruptedIOException ie) {
                throw ie;
            }
            catch (IOException ioe) {
                Trace.logDebug(this, "(\"" + this.method + " " + this.OriginalURI.getPathAndQuery() + "\")");
                Trace.logException(this, ioe, true);
                try {
                    this.inp_stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ioe;
            }
            this.inp_stream.close();
        }
        return this.Data;
    }

    public synchronized String getText() throws IOException, ModuleException, ParseException {
        String ct = this.getHeader("Content-Type");
        if (ct == null || !ct.toLowerCase().startsWith("text/")) {
            throw new IOException("Content-Type `" + ct + "' is not a text type");
        }
        String charset = Util.getParameter("charset", ct);
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        return new String(this.getData(), charset);
    }

    public synchronized InputStream getInputStream() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.Data == null) {
            return this.inp_stream;
        }
        this.getData();
        return new ByteArrayInputStream(this.Data);
    }

    public boolean retryRequest() throws IOException, ModuleException {
        if (!this.initialized) {
            try {
                this.handleResponse();
            }
            catch (RetryException re) {
                this.retry = this.response.retry;
            }
        }
        return this.retry;
    }

    public String toString() {
        if (!this.initialized) {
            try {
                this.handleResponse();
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedIOException)) {
                    Trace.logDebug(this, "(\"" + this.method + " " + this.OriginalURI.getPathAndQuery() + "\")");
                    Trace.logException(this, e, true);
                }
                return "Failed to read headers: " + String.valueOf(e);
            }
        }
        String nl = System.getProperty("line.separator", "\n");
        StringBuffer str = new StringBuffer(this.Version);
        str.append(' ');
        str.append(this.StatusCode);
        str.append(' ');
        str.append(this.ReasonLine);
        str.append(nl);
        if (this.EffectiveURI != null) {
            str.append("Effective-URI: ");
            str.append(this.EffectiveURI);
            str.append(nl);
        }
        Enumeration hdr_list = this.Headers.keys();
        while (hdr_list.hasMoreElements()) {
            String hdr = (String)hdr_list.nextElement();
            str.append(hdr);
            str.append(": ");
            str.append(this.Headers.get(hdr));
            str.append(nl);
        }
        return str.toString();
    }

    HTTPClientModule[] getModules() {
        return this.modules;
    }

    /*
     * Unable to fully structure code
     */
    synchronized boolean handleResponse() throws IOException, ModuleException {
        block22: {
            if (this.initialized) {
                return false;
            }
            if (this.out_stream != null) {
                this.response = this.out_stream.getResponse();
                this.response.http_resp = this;
                this.out_stream = null;
            }
            while (true) lbl-1000:
            // 6 sources

            {
                for (idx = 0; idx < this.modules.length && !this.aborted; ++idx) {
                    try {
                        this.modules[idx].responsePhase1Handler(this.response, this.request);
                        continue;
                    }
                    catch (RetryException re) {
                        if (re.restart) continue;
                        throw re;
                    }
                }
                block11: for (idx = 0; idx < this.modules.length && !this.aborted; ++idx) {
                    sts = this.modules[idx].responsePhase2Handler(this.response, this.request);
                    switch (sts) {
                        case 10: {
                            continue block11;
                        }
                        case 11: {
                            idx = -1;
                            ** continue;
                        }
                        case 12: {
                            break block22;
                        }
                        case 13: 
                        case 15: {
                            this.response.getInputStream().close();
                            if (this.handle_trailers) {
                                this.invokeTrailerHandlers(true);
                            }
                            if (this.request.internal_subrequest) {
                                return true;
                            }
                            this.request.getConnection().handleRequest(this.request, this, this.response, true);
                            if (!this.initialized) {
                                idx = -1;
                                ** continue;
                            }
                            break block22;
                        }
                        case 14: 
                        case 16: {
                            this.response.getInputStream().close();
                            if (this.handle_trailers) {
                                this.invokeTrailerHandlers(true);
                            }
                            if (this.request.internal_subrequest) {
                                return true;
                            }
                            this.request.getConnection().handleRequest(this.request, this, this.response, false);
                            idx = -1;
                            ** continue;
                        }
                        default: {
                            throw new Error("HTTPClient Internal Error: invalid status " + sts + " returned by module " + this.modules[idx].getClass().getName());
                        }
                    }
                }
                break;
            }
            for (idx = 0; idx < this.modules.length && !this.aborted; ++idx) {
                this.modules[idx].responsePhase3Handler(this.response, this.request);
            }
        }
        this.response.getStatusCode();
        if (!this.request.internal_subrequest) {
            this.init(this.response);
        }
        if (this.handle_trailers) {
            this.invokeTrailerHandlers(false);
        }
        return false;
    }

    void init(Response resp) {
        if (this.initialized) {
            return;
        }
        this.StatusCode = resp.StatusCode;
        this.ReasonLine = resp.ReasonLine;
        this.Version = resp.Version;
        this.EffectiveURI = resp.EffectiveURI;
        this.ContentLength = resp.ContentLength;
        this.Headers = resp.Headers;
        this.inp_stream = resp.inp_stream;
        this.Data = resp.Data;
        this.retry = resp.retry;
        this.initialized = true;
    }

    void invokeTrailerHandlers(boolean force) throws IOException, ModuleException {
        if (this.trailers_handled) {
            return;
        }
        if (!force && !this.initialized) {
            this.handle_trailers = true;
            return;
        }
        for (int idx = 0; idx < this.modules.length && !this.aborted; ++idx) {
            this.modules[idx].trailerHandler(this.response, this.request);
        }
        this.trailers_handled = true;
    }

    void markAborted() {
        this.aborted = true;
    }

    private synchronized void getTrailers() throws IOException, ModuleException {
        if (this.got_trailers) {
            return;
        }
        if (!this.initialized) {
            this.handleResponse();
        }
        this.response.getTrailer("Any");
        this.Trailers = this.response.Trailers;
        this.got_trailers = true;
        this.invokeTrailerHandlers(false);
    }

    private void readResponseData(InputStream inp) throws IOException, ModuleException {
        block16: {
            if (this.ContentLength == 0) {
                return;
            }
            if (this.Data == null) {
                this.Data = new byte[0];
            }
            int off = this.Data.length;
            try {
                if (this.getHeader("Content-Length") != null) {
                    Trace.logDebug(this, "Content-Length: " + this.ContentLength);
                    int rcvd = 0;
                    this.Data = new byte[this.ContentLength];
                    while ((rcvd = inp.read(this.Data, off += rcvd, this.ContentLength - off)) != -1) {
                        if (off + rcvd < this.ContentLength) continue;
                        break block16;
                    }
                    break block16;
                }
                if (this.Data.length == 0) {
                    this.Data = new byte[4096];
                }
                int recvBytes = 0;
                while ((recvBytes = inp.read(this.Data, off, this.Data.length - off)) > 0) {
                    if ((off += recvBytes) < this.Data.length) continue;
                    this.Data = Arrays.copyOf(this.Data, this.Data.length * 2);
                }
                if (off < this.Data.length) {
                    this.Data = Arrays.copyOf(this.Data, off);
                }
            }
            catch (IOException ioe) {
                this.Data = Util.resizeArray(this.Data, off);
                throw ioe;
            }
            finally {
                try {
                    inp.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    int getTimeout() {
        return this.timeout;
    }
}

