/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.http;

import com.streamscape.Trace;
import com.streamscape.lib.http.HTTPClientModule;
import com.streamscape.lib.http.MD5InputStream;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.ParseException;
import com.streamscape.lib.http.Request;
import com.streamscape.lib.http.Response;
import com.streamscape.lib.http.RoRequest;
import com.streamscape.lib.http.Util;
import com.streamscape.lib.http.VerifyMD5;
import java.io.IOException;

class ContentMD5Module
implements HTTPClientModule {
    ContentMD5Module() {
    }

    @Override
    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    @Override
    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    @Override
    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    @Override
    public void responsePhase3Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        if (req.getMethod().equals("HEAD")) {
            return;
        }
        String md5_digest = resp.getHeader("Content-MD5");
        String trailer = resp.getHeader("Trailer");
        boolean md5_tok = false;
        try {
            if (trailer != null) {
                md5_tok = Util.hasToken(trailer, "Content-MD5");
            }
        }
        catch (ParseException pe) {
            throw new ModuleException(pe.toString());
        }
        if (md5_digest == null && !md5_tok || resp.getHeader("Transfer-Encoding") != null) {
            return;
        }
        if (md5_digest != null) {
            Trace.logDebug(this, "Received digest: " + md5_digest + " - pushing md5-check-stream");
        } else {
            Trace.logDebug(this, "Expecting digest in trailer  - pushing md5-check-stream");
        }
        resp.inp_stream = new MD5InputStream(resp.inp_stream, new VerifyMD5(resp));
    }

    @Override
    public void trailerHandler(Response resp, RoRequest req) {
    }
}

