/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.http;

import com.streamscape.Trace;
import com.streamscape.lib.http.HTTPClientModule;
import com.streamscape.lib.http.HttpHeaderElement;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.NVPair;
import com.streamscape.lib.http.ParseException;
import com.streamscape.lib.http.Request;
import com.streamscape.lib.http.Response;
import com.streamscape.lib.http.RoRequest;
import com.streamscape.lib.http.UncompressInputStream;
import com.streamscape.lib.http.Util;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

class ContentEncodingModule
implements HTTPClientModule {
    ContentEncodingModule() {
    }

    @Override
    public int requestHandler(Request req, Response[] resp) throws ModuleException {
        Vector<HttpHeaderElement> pae;
        int idx;
        NVPair[] hdrs = req.getHeaders();
        for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("Accept-Encoding"); ++idx) {
        }
        if (idx == hdrs.length) {
            hdrs = Util.resizeArray(hdrs, idx + 1);
            req.setHeaders(hdrs);
            pae = new Vector<HttpHeaderElement>();
        } else {
            try {
                pae = Util.parseHeader(hdrs[idx].getValue());
            }
            catch (ParseException pe) {
                throw new ModuleException(pe.toString());
            }
        }
        HttpHeaderElement all = Util.getElement(pae, "*");
        if (all != null) {
            NVPair[] params = all.getParams();
            for (idx = 0; idx < params.length && !params[idx].getName().equalsIgnoreCase("q"); ++idx) {
            }
            if (idx == params.length) {
                return 0;
            }
            if (params[idx].getValue() == null || params[idx].getValue().length() == 0) {
                throw new ModuleException("Invalid q value for \"*\" in Accept-Encoding header: ");
            }
            try {
                if ((double)Float.valueOf(params[idx].getValue()).floatValue() > 0.0) {
                    return 0;
                }
            }
            catch (NumberFormatException nfe) {
                throw new ModuleException("Invalid q value for \"*\" in Accept-Encoding header: " + nfe.getMessage());
            }
        }
        if (!pae.contains(new HttpHeaderElement("deflate"))) {
            pae.addElement(new HttpHeaderElement("deflate"));
        }
        if (!pae.contains(new HttpHeaderElement("gzip"))) {
            pae.addElement(new HttpHeaderElement("gzip"));
        }
        if (!pae.contains(new HttpHeaderElement("x-gzip"))) {
            pae.addElement(new HttpHeaderElement("x-gzip"));
        }
        if (!pae.contains(new HttpHeaderElement("compress"))) {
            pae.addElement(new HttpHeaderElement("compress"));
        }
        if (!pae.contains(new HttpHeaderElement("x-compress"))) {
            pae.addElement(new HttpHeaderElement("x-compress"));
        }
        hdrs[idx] = new NVPair("Accept-Encoding", Util.assembleHeader(pae));
        return 0;
    }

    @Override
    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    @Override
    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    @Override
    public void responsePhase3Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        Vector pce;
        String ce = resp.getHeader("Content-Encoding");
        if (ce == null || req.getMethod().equals("HEAD") || resp.getStatusCode() == 206) {
            return;
        }
        try {
            pce = Util.parseHeader(ce);
        }
        catch (ParseException pe) {
            throw new ModuleException(pe.toString());
        }
        if (pce.size() == 0) {
            return;
        }
        String encoding = ((HttpHeaderElement)pce.firstElement()).getName();
        if (encoding.equalsIgnoreCase("gzip") || encoding.equalsIgnoreCase("x-gzip")) {
            Trace.logDebug(this, "Pushing gzip-input-stream");
            resp.inp_stream = new GZIPInputStream(resp.inp_stream);
            pce.removeElementAt(pce.size() - 1);
            resp.deleteHeader("Content-length");
        } else if (encoding.equalsIgnoreCase("deflate")) {
            Trace.logDebug(this, "Pushing inflater-input-stream");
            resp.inp_stream = new InflaterInputStream(resp.inp_stream);
            pce.removeElementAt(pce.size() - 1);
            resp.deleteHeader("Content-length");
        } else if (encoding.equalsIgnoreCase("compress") || encoding.equalsIgnoreCase("x-compress")) {
            Trace.logDebug(this, "Pushing uncompress-input-stream");
            resp.inp_stream = new UncompressInputStream(resp.inp_stream);
            pce.removeElementAt(pce.size() - 1);
            resp.deleteHeader("Content-length");
        } else if (encoding.equalsIgnoreCase("identity")) {
            Trace.logDebug(this, "Ignoring 'identity' token");
            pce.removeElementAt(pce.size() - 1);
        } else {
            Trace.logDebug(this, "Unknown content encoding '" + encoding + "'");
        }
        if (pce.size() > 0) {
            resp.setHeader("Content-Encoding", Util.assembleHeader(pce));
        } else {
            resp.deleteHeader("Content-Encoding");
        }
    }

    @Override
    public void trailerHandler(Response resp, RoRequest req) {
    }
}

