/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.fs.client.repository;

import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.lib.fs.client.AbstractFileSystem;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.repository.filesystem.FSFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RepositoryAccessorFileSystem
extends AbstractFileSystem {
    private RepositoryAccessor accessor;

    public RepositoryAccessorFileSystem(RepositoryAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public URI getPathURI(String path) throws IOException {
        path = this.normalize(path);
        return URI.create("tfcache://artifacts/" + path);
    }

    @Override
    public FileInfo getInfo(String path) throws IOException {
        path = this.normalize(path);
        this.checkExists(path);
        FSFile details = null;
        try {
            details = this.accessor.getDetails(path);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
        if (details == null) {
            throw new IOException("Path '" + path + "' doesn't exist.");
        }
        return this.convert(details);
    }

    @Override
    public List<FileInfo> list(String path, boolean recursive) throws IOException {
        return this.list(path, recursive, new ArrayList<FileInfo>());
    }

    private List<FileInfo> list(String path, boolean recursive, List<FileInfo> infos) throws IOException {
        path = this.normalize(path);
        this.checkDirectoryExists(path);
        List<FSFile> details = null;
        try {
            details = this.accessor.getAllArtifactsDetails(path);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
        for (FSFile detail : details) {
            FileInfo info = this.convert(detail);
            infos.add(info);
            if (!recursive || !info.isDirectory()) continue;
            this.list(new File(path, info.getName()).getAbsolutePath(), recursive, infos);
        }
        return infos;
    }

    private FileInfo convert(FSFile detail) {
        String path = detail.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        FileInfo info = new FileInfo(detail.getName(), path);
        info.setSize(detail.getSize());
        info.setModificationTime(detail.getLastModified());
        info.setDirectory(detail.isDirectory());
        info.setPermissions(FilePermissions.getDefault());
        info.setAbsolutePath("tfcache:/artifacts/" + path + "/" + detail.getName());
        info.setCreationTime(detail.getCreationTimestamp());
        info.setOwner(detail.getOwnerId());
        return info;
    }

    @Override
    public void mkdir(String path, FilePermissions permissions) throws IOException {
        try {
            path = this.normalize(path);
            this.accessor.createDirectory(path);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String createTempFile(String dir, String prefix, String suffix) throws IOException {
        throw new IOException("createTempFile is not supported for repository file system");
    }

    @Override
    public void createNewFile(String path, FilePermissions permissions) throws IOException {
        try {
            path = this.normalize(path);
            this.accessor.createFile(path, new byte[0], -1L);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize) throws IOException {
        path = this.normalize(path);
        this.createNewFile(path, permissions);
        return new BufferedOutputStream(new AccessorOutputStream(path), bufferSize);
    }

    @Override
    public OutputStream append(String path, int bufferSize) throws IOException {
        path = this.normalize(path);
        this.checkFileExists(path);
        return new BufferedOutputStream(new AccessorOutputStream(path), bufferSize);
    }

    @Override
    public boolean delete(String path, boolean recursive) throws IOException {
        path = this.normalize(path);
        try {
            if (!this.accessor.existsFile(path)) {
                return true;
            }
            if (this.accessor.isFile(path)) {
                this.accessor.deleteFile(path);
            } else {
                this.accessor.deleteDirectory(path, recursive);
            }
            return !this.accessor.existsFile(path);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean exists(String path) throws IOException {
        path = this.normalize(path);
        try {
            return this.accessor.existsFile(path);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isFile(String path) throws IOException {
        path = this.normalize(path);
        try {
            return this.accessor.existsFile(path) && this.accessor.isFile(path);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        path = this.normalize(path);
        try {
            return this.accessor.existsFile(path) && this.accessor.isDirectory(path);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public InputStream open(String path, int bufferSize) throws IOException {
        path = this.normalize(path);
        try {
            return new ByteArrayInputStream(this.accessor.getFileContentBytes(path));
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path, int bufferSize) throws IOException {
        return null;
    }

    @Override
    public OutputStream openForWrite(String path, int bufferSize) throws IOException {
        if (!this.exists(path = this.normalize(path))) {
            this.createNewFile(path);
        }
        return new BufferedOutputStream(new AccessorOutputStream(path), bufferSize);
    }

    @Override
    public void copy(String src, String dst) throws IOException {
        src = this.normalize(src);
        dst = this.normalize(dst);
        this.checkFileExists(src);
        this.checkNotExists(dst);
        try {
            this.accessor.createFile(dst, this.accessor.getFileContentBytes(src), -1L);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void rename(String src, String dst) throws IOException {
        src = this.normalize(src);
        dst = this.normalize(dst);
        this.checkFileExists(src);
        this.checkNotExists(dst);
        try {
            this.accessor.renameArtifact(src, dst);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void move(String src, String dst) throws IOException {
        src = this.normalize(src);
        dst = this.normalize(dst);
        this.checkFileExists(src);
        this.checkNotExists(dst);
        try {
            this.accessor.renameArtifact(src, dst);
        }
        catch (RepositoryException | RepositoryAccessorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setOwner(String path, String username, String groupname) throws IOException {
    }

    @Override
    public void setPermissions(String path, FilePermissions permissions) throws IOException {
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public long truncate(String path, long size) throws IOException {
        throw new IOException("truncate is not supported for repository file system");
    }

    protected void checkExists(String path) throws IOException {
        try {
            if (!this.accessor.existsFile(path)) {
                throw new IOException("File or directory '" + path + "' doesn't exist.");
            }
        }
        catch (RepositoryException | RepositoryAccessorException exception) {
            throw new IOException(exception);
        }
    }

    private String normalize(String path) throws IOException {
        if (path == null) {
            return null;
        }
        if (path.startsWith("tfcache:/")) {
            path = path.substring("tfcache:/".length());
        }
        return Paths.get(path, new String[0]).normalize().toString();
    }

    protected void checkFileExists(String path) throws IOException {
        try {
            if (!this.accessor.existsFile(path)) {
                throw new IOException("File '" + path + "' doesn't exist.");
            }
            if (!this.accessor.isFile(path)) {
                throw new IOException("Path '" + path + "' is not file.");
            }
        }
        catch (RepositoryException | RepositoryAccessorException exception) {
            throw new IOException(exception);
        }
    }

    protected void checkNotExists(String path) throws IOException {
        try {
            if (this.accessor.existsFile(path)) {
                throw new IOException((this.accessor.isFile(path) ? "File" : "Directory") + " '" + path + "' already exists.");
            }
        }
        catch (RepositoryException | RepositoryAccessorException exception) {
            throw new IOException(exception);
        }
    }

    protected void checkDirectoryExists(String path) throws IOException {
        try {
            if (!this.accessor.existsFile(path)) {
                throw new IOException("Directory '" + path + "' doesn't exist.");
            }
            if (this.accessor.isFile(path)) {
                throw new IOException("Path '" + path + "' is not a directory.");
            }
        }
        catch (RepositoryException | RepositoryAccessorException exception) {
            throw new IOException(exception);
        }
    }

    class AccessorOutputStream
    extends OutputStream {
        private String path;

        AccessorOutputStream(String path) {
            this.path = path;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                RepositoryAccessorFileSystem.this.accessor.appendFile(this.path, new byte[]{(byte)b});
            }
            catch (RepositoryException | RepositoryAccessorException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                RepositoryAccessorFileSystem.this.accessor.appendFile(this.path, Arrays.copyOfRange(b, off, off + len));
            }
            catch (RepositoryException | RepositoryAccessorException e) {
                throw new IOException(e);
            }
        }
    }
}

