/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.fs.client.local;

import com.streamscape.lib.utils.Pair;
import java.util.regex.Pattern;

public class Wildcard {
    private final Pattern pattern;
    private String wildcard;

    public Wildcard(String wildcard) {
        this.wildcard = wildcard;
        String regexp = wildcard;
        regexp = regexp.replace(".", "\\.");
        regexp = regexp.replace("*", ".*");
        this.pattern = Pattern.compile(regexp);
    }

    public boolean accept(String name) {
        return this.pattern.matcher(name).matches();
    }

    public String format(String path) {
        if (path.endsWith("/") || path.endsWith("\\")) {
            return path + this.wildcard;
        }
        return path + "/" + this.wildcard;
    }

    private static Pair<String, String> splitPath(String path) {
        int pos = Math.max((path = path.trim()).lastIndexOf("/"), path.lastIndexOf("\\"));
        String firstPart = pos >= 0 ? path.substring(0, pos + 1) : ".";
        String lastPart = pos >= 0 ? path.substring(pos + 1) : path;
        return new Pair<String, String>(firstPart, lastPart);
    }

    public static boolean isWildcard(String path) {
        return ((String)Wildcard.splitPath((String)path).second).contains("*");
    }

    public static Wildcard extractWildcard(String path) {
        if (Wildcard.isWildcard(path)) {
            return new Wildcard((String)Wildcard.splitPath((String)path).second);
        }
        return null;
    }

    public static String extractWildcardPath(String path) {
        if (Wildcard.isWildcard(path)) {
            return (String)Wildcard.splitPath((String)path).first;
        }
        return path;
    }

    public String toString() {
        return "Wildcard{, wildcard='" + this.wildcard + "'}";
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public static void main(String[] args) {
        String path = ".";
        System.out.println();
        System.out.println(path);
        System.out.println(Wildcard.isWildcard(path));
        path = "*";
        System.out.println();
        System.out.println(path);
        System.out.println(Wildcard.isWildcard(path));
        System.out.println(Wildcard.extractWildcard(path));
        System.out.println(Wildcard.extractWildcardPath(path));
        System.out.println(Wildcard.extractWildcard(path).accept("qwer"));
        path = "*.xml";
        System.out.println();
        System.out.println(path);
        System.out.println(Wildcard.isWildcard(path));
        System.out.println(Wildcard.extractWildcard(path));
        System.out.println(Wildcard.extractWildcardPath(path));
        System.out.println(Wildcard.extractWildcard(path).accept("qwer"));
        System.out.println(Wildcard.extractWildcard(path).accept("qwer.xml"));
        path = "f/g/*.xml";
        System.out.println();
        System.out.println(path);
        System.out.println(Wildcard.isWildcard(path));
        System.out.println(Wildcard.extractWildcard(path));
        System.out.println(Wildcard.extractWildcardPath(path));
        System.out.println(Wildcard.extractWildcard(path).accept("qwer"));
        System.out.println(Wildcard.extractWildcard(path).accept("qwer.xml"));
        path = "/*.xml";
        System.out.println();
        System.out.println(path);
        System.out.println(Wildcard.isWildcard(path));
        System.out.println(Wildcard.extractWildcard(path));
        System.out.println(Wildcard.extractWildcardPath(path));
        System.out.println(Wildcard.extractWildcard(path).accept("qwer"));
        System.out.println(Wildcard.extractWildcard(path).accept("qwer.xml"));
    }
}

