/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.fs.client.local;

import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.lib.file.SimpleRandomAccessFile;
import com.streamscape.lib.fs.client.AbstractFileSystem;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.lib.fs.client.local.Wildcard;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class LocalFileSystem
extends AbstractFileSystem {
    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public URI getPathURI(String path) throws IOException {
        return new File(path).getCanonicalFile().toURI();
    }

    @Override
    public FileInfo getInfo(String path) throws IOException {
        path = this.normalize(path);
        this.checkExists(path);
        File file = new File(path);
        FileInfo info = new FileInfo(file.getName(), file.getPath());
        info.setSize(file.length());
        info.setModificationTime(file.lastModified());
        info.setDirectory(file.isDirectory());
        info.setPermissions(LocalFileSystem.getPermissions(file));
        info.setAbsolutePath(file.getAbsolutePath());
        try {
            info.setOwner(Files.getOwner(file.toPath(), new LinkOption[0]).getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            BasicFileAttributes view = Files.getFileAttributeView(file.toPath(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
            info.setCreationTime(view.creationTime().toMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    public static FileInfo getInfo(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File or directory '" + file.getPath() + "' doesn't exist.");
        }
        FileInfo info = new FileInfo(file.getName(), file.getPath());
        info.setSize(file.length());
        info.setModificationTime(file.lastModified());
        info.setDirectory(file.isDirectory());
        info.setPermissions(LocalFileSystem.getPermissions(file));
        info.setAbsolutePath(file.getAbsolutePath());
        try {
            info.setOwner(Files.getOwner(file.toPath(), new LinkOption[0]).getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            BasicFileAttributes view = Files.getFileAttributeView(file.toPath(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
            info.setCreationTime(view.creationTime().toMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    @Override
    public List<FileInfo> list(String path, boolean recursive) throws IOException {
        return this.list(path, recursive, new ArrayList<FileInfo>());
    }

    private List<FileInfo> list(String path, boolean recursive, List<FileInfo> infos) throws IOException {
        Wildcard wildcard = null;
        if (Wildcard.isWildcard(path)) {
            wildcard = Wildcard.extractWildcard(path);
            path = Wildcard.extractWildcardPath(path);
        }
        path = this.normalize(path);
        this.checkDirectoryExists(path);
        File file = new File(path);
        String[] names = null;
        try {
            names = file.list();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        if (names == null) {
            throw new IOException("Errors occurred.");
        }
        for (String name : names) {
            FileInfo info = this.getInfo(path + File.separatorChar + name);
            if (wildcard != null && !wildcard.accept(name)) {
                if (!info.isDirectory()) {
                    continue;
                }
            } else {
                infos.add(this.getInfo(path + File.separatorChar + name));
            }
            if (!recursive || !info.isDirectory()) continue;
            String nextPath = new File(path, info.getName()).getAbsolutePath();
            this.list(wildcard != null ? wildcard.format(nextPath) : nextPath, recursive, infos);
        }
        return infos;
    }

    @Override
    public void mkdir(String path, FilePermissions permissions) throws IOException {
        path = this.normalize(path);
        this.checkNotExists(path);
        File file = new File(path);
        if (!file.mkdirs()) {
            throw new IOException("Directory creation failed.");
        }
        this.setPermissions(file, permissions != null ? permissions : FilePermissions.getDirDefault());
    }

    @Override
    public String createTempFile(String dir, String prefix, String suffix) throws IOException {
        return Files.createTempFile(Paths.get(dir, new String[0]), prefix, suffix, new FileAttribute[0]).toString();
    }

    @Override
    public void createNewFile(String path, FilePermissions permissions) throws IOException {
        path = this.normalize(path);
        this.checkNotExists(path);
        File file = new File(path);
        if (!file.createNewFile()) {
            throw new IOException("File creation failed.");
        }
        this.setPermissions(file, permissions != null ? permissions : FilePermissions.getFileDefault());
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize) throws IOException {
        path = this.normalize(path);
        File file = new File(path);
        if (overwrite) {
            if (file.exists() && file.isFile()) {
                this.delete(path, false);
            }
            if (file.exists()) {
                throw new IOException("Failed to overwrite existing file.");
            }
        }
        this.checkNotExists(path);
        if (!file.createNewFile()) {
            throw new IOException("File creation failed.");
        }
        this.setPermissions(file, permissions != null ? permissions : FilePermissions.getFileDefault());
        return new FileOutputStream(file);
    }

    @Override
    public OutputStream append(String path, int bufferSize) throws IOException {
        path = this.normalize(path);
        this.checkFileExists(path);
        return new FileOutputStream(path, true);
    }

    @Override
    public boolean delete(String path, boolean recursive) throws IOException {
        Wildcard wildcard = null;
        if (Wildcard.isWildcard(path)) {
            wildcard = Wildcard.extractWildcard(path);
            path = Wildcard.extractWildcardPath(path);
        }
        path = this.normalize(path);
        if (wildcard != null) {
            Wildcard finalWildcard = wildcard;
            if (recursive) {
                FileIOUtils.deleteFileDir(new File(path), null, true, name -> finalWildcard.accept((String)name));
            } else {
                File filePath = new File(path);
                if (filePath.isDirectory()) {
                    for (File file : filePath.listFiles()) {
                        if (!wildcard.accept(file.getName())) continue;
                        file.delete();
                    }
                }
            }
            return true;
        }
        if (recursive) {
            FileIOUtils.deleteFileDir(new File(path));
        } else {
            FileIOUtils.deleteFile(path);
        }
        return !new File(path).exists();
    }

    @Override
    public boolean exists(String path) throws IOException {
        path = this.normalize(path);
        return new File(path).exists();
    }

    @Override
    public boolean isFile(String path) throws IOException {
        path = this.normalize(path);
        this.checkExists(path);
        return new File(path).isFile();
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        return new File(path = this.normalize(path)).exists() && new File(path).isDirectory();
    }

    @Override
    public InputStream open(String path, int bufferSize) throws IOException {
        path = this.normalize(path);
        this.checkFileExists(path);
        return new FileInputStream(path);
    }

    @Override
    public OutputStream openForWrite(String path, int bufferSize) throws IOException {
        path = this.normalize(path);
        return new FileOutputStream(path);
    }

    @Override
    public void writeFileFromInputStream(String path, InputStream inputStream, int bufferSize) throws IOException {
        path = this.normalize(path);
        try (FileOutputStream outputStream = new FileOutputStream(path);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
            FileIOUtils.copyLarge(inputStream, (OutputStream)bufferedOutputStream);
        }
        catch (UtilitiesException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void copy(String src, String dst) throws IOException {
        src = this.normalize(src);
        dst = this.normalize(dst);
        this.checkFileExists(src);
        try {
            FileIOUtils.copy(new File(src), new File(dst));
        }
        catch (UtilitiesException exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public void rename(String src, String dst) throws IOException {
        src = this.normalize(src);
        dst = this.normalize(dst);
        this.checkFileExists(src);
        if (!FileIOUtils.renameFile(src, dst)) {
            throw new IOException("Rename failed.");
        }
    }

    @Override
    public void move(String src, String dst) throws IOException {
        src = this.normalize(src);
        dst = this.normalize(dst);
        this.checkFileExists(src);
        try {
            FileIOUtils.move(new File(src), new File(dst));
        }
        catch (UtilitiesException exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public void setOwner(String path, String username, String groupname) throws IOException {
    }

    @Override
    public void setPermissions(String path, FilePermissions permissions) throws IOException {
        path = this.normalize(path);
        this.checkExists(path);
        if (permissions == null) {
            throw new IOException("Permissions is null.");
        }
        this.setPermissions(new File(path), permissions);
    }

    protected void checkExists(String path) throws IOException {
        if (!new File(path).exists()) {
            throw new IOException("File or directory '" + path + "' doesn't exist.");
        }
    }

    private String normalize(String path) throws IOException {
        if (path == null) {
            return null;
        }
        if (path.startsWith("file:/")) {
            path = path.substring("file:/".length());
        }
        if ((path = Paths.get(path, new String[0]).normalize().toString()).length() == 0) {
            path = "./";
        }
        return path;
    }

    protected void checkFileExists(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("File '" + path + "' doesn't exist.");
        }
        if (!file.isFile()) {
            throw new IOException("Path '" + path + "' is not file.");
        }
    }

    protected void checkNotExists(String path) throws IOException {
        File file = new File(path);
        if (new File(path).exists()) {
            throw new IOException((file.isFile() ? "File '" : "Directory ") + path + "' already exists.");
        }
    }

    protected void checkDirectoryExists(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("Directory '" + path + "' doesn't exist.");
        }
        if (!file.isDirectory()) {
            throw new IOException("Directory '" + path + "' doesn't exist.");
        }
    }

    private static FilePermissions getPermissions(File file) throws IOException {
        try {
            return FilePermissions.fromPosixFilePermissions(Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]));
        }
        catch (UnsupportedOperationException exception) {
            return new FilePermissions(FilePermissions.Permission.create(file.canRead(), file.canWrite(), file.canExecute()), FilePermissions.Permission.NONE, FilePermissions.Permission.NONE);
        }
    }

    private void setPermissions(File file, FilePermissions permissions) throws IOException {
        try {
            Files.setPosixFilePermissions(file.toPath(), permissions.toPosixFilePermissions());
        }
        catch (UnsupportedOperationException exception) {
            file.setReadable(permissions.getUserPermission().canRead());
            file.setWritable(permissions.getUserPermission().canWrite());
            file.setExecutable(permissions.getUserPermission().canExecute());
        }
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path, int bufferSize) throws IOException {
        return new RandomAccessInputStream(new SimpleRandomAccessFile(path, true));
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public long truncate(String path, long size) throws IOException {
        try (FileChannel outChannel = new FileOutputStream(new File(path), true).getChannel();){
            long l = outChannel.truncate(size).size();
            return l;
        }
    }
}

