/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.fs.client;

import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.lib.fs.client.FileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;

public class FileSystemWrapper
implements FileSystem {
    private FileSystem fileSystem;

    public FileSystemWrapper(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public void open() throws IOException {
        this.fileSystem.open();
    }

    @Override
    public void close() throws IOException {
        this.fileSystem.close();
    }

    @Override
    public URI getPathURI(String path) throws IOException {
        return this.fileSystem.getPathURI(path);
    }

    @Override
    public FileInfo getInfo(String path) throws IOException {
        return this.fileSystem.getInfo(path);
    }

    @Override
    public List<FileInfo> list(String path, boolean recursive) throws IOException {
        return this.fileSystem.list(path, recursive);
    }

    @Override
    public void mkdir(String path) throws IOException {
        this.fileSystem.mkdir(path);
    }

    @Override
    public void mkdir(String path, FilePermissions permissions) throws IOException {
        this.fileSystem.mkdir(path, permissions);
    }

    @Override
    public String createTempFile(String dir, String prefix, String suffix) throws IOException {
        return this.fileSystem.createTempFile(dir, prefix, suffix);
    }

    @Override
    public void createNewFile(String path) throws IOException {
        this.fileSystem.createNewFile(path);
    }

    @Override
    public void createNewFile(String path, FilePermissions permissions) throws IOException {
        this.fileSystem.createNewFile(path, permissions);
    }

    @Override
    public OutputStream create(String path) throws IOException {
        return this.fileSystem.create(path);
    }

    @Override
    public OutputStream create(String path, boolean overwrite) throws IOException {
        return this.fileSystem.create(path, overwrite);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions) throws IOException {
        return this.fileSystem.create(path, overwrite, permissions);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize) throws IOException {
        return this.fileSystem.create(path, overwrite, permissions, bufferSize);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize, int replication, long blockSize) throws IOException {
        return this.fileSystem.create(path, overwrite, permissions, bufferSize, replication, blockSize);
    }

    @Override
    public OutputStream append(String path) throws IOException {
        return this.fileSystem.append(path);
    }

    @Override
    public OutputStream append(String path, int bufferSize) throws IOException {
        return this.fileSystem.append(path, bufferSize);
    }

    @Override
    public boolean delete(String path, boolean recursive) throws IOException {
        return this.fileSystem.delete(path, recursive);
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.fileSystem.exists(path);
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return this.fileSystem.isFile(path);
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        return this.fileSystem.isDirectory(path);
    }

    @Override
    public InputStream open(String path) throws IOException {
        return this.fileSystem.open(path);
    }

    @Override
    public InputStream open(String path, int bufferSize) throws IOException {
        return this.fileSystem.open(path, bufferSize);
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path) throws IOException {
        return this.fileSystem.openForRandomRead(path);
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path, int bufferSize) throws IOException {
        return this.fileSystem.openForRandomRead(path, bufferSize);
    }

    @Override
    public OutputStream openForWrite(String path) throws IOException {
        return this.fileSystem.openForWrite(path);
    }

    @Override
    public OutputStream openForWrite(String path, int bufferSize) throws IOException {
        return this.fileSystem.openForWrite(path, bufferSize);
    }

    @Override
    public void writeFileFromInputStream(String path, InputStream inputStream, int bufferSize) throws IOException {
        this.fileSystem.writeFileFromInputStream(path, inputStream, bufferSize);
    }

    @Override
    public void copy(String src, String dst) throws IOException {
        this.fileSystem.copy(src, dst);
    }

    @Override
    public void rename(String src, String dst) throws IOException {
        this.fileSystem.rename(src, dst);
    }

    @Override
    public void move(String src, String dst) throws IOException {
        this.fileSystem.move(src, dst);
    }

    @Override
    public void setOwner(String path, String username, String groupname) throws IOException {
        this.fileSystem.setOwner(path, username, groupname);
    }

    @Override
    public void setPermissions(String path, FilePermissions permissions) throws IOException {
        this.fileSystem.setPermissions(path, permissions);
    }

    @Override
    public int getDefaultReplication(String path) throws IOException {
        return this.fileSystem.getDefaultReplication(path);
    }

    @Override
    public long getDefaultBlockSize(String path) throws IOException {
        return this.fileSystem.getDefaultBlockSize(path);
    }

    @Override
    public String separator() throws IOException {
        return this.fileSystem.separator();
    }

    @Override
    public long getSize(String fileName) throws IOException {
        return this.fileSystem.getSize(fileName);
    }

    @Override
    public boolean isLocal() {
        return this.fileSystem.isLocal();
    }

    @Override
    public long truncate(String path, long size) throws IOException {
        return this.fileSystem.truncate(path, size);
    }
}

