/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.fs.client;

import com.streamscape.ds.session.Session;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.local.LocalFileSystem;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileSystemFactory;

public class FileSystemProvider {
    private RuntimeContext context;

    public FileSystemProvider(RuntimeContext context) {
        this.context = context;
    }

    public FileSystem createFileSystem(MFSession session, String path) {
        if (session == null) {
            return new LocalFileSystem();
        }
        if (DropBoxUtils.isDropBoxURL(path)) {
            return DropBoxUtils.createFileSystem(this.context, session.getOwnerName(), path);
        }
        return (FileSystem)new SLFileSystemFactory().create(session, path);
    }

    public FileSystem createFileSystem(Session session, String path) {
        if (session == null) {
            return new LocalFileSystem();
        }
        if (DropBoxUtils.isDropBoxURL(path)) {
            return DropBoxUtils.createFileSystem(this.context, session.getUsername(), path);
        }
        return (FileSystem)new SLFileSystemFactory().create(session, path);
    }
}

