/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.fs.client;

import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;

public interface FileSystem
extends AutoCloseable {
    public void open() throws IOException;

    @Override
    public void close() throws IOException;

    public URI getPathURI(String var1) throws IOException;

    public FileInfo getInfo(String var1) throws IOException;

    default public List<FileInfo> list(String path) throws IOException {
        return this.list(path, false);
    }

    public List<FileInfo> list(String var1, boolean var2) throws IOException;

    public void mkdir(String var1) throws IOException;

    public void mkdir(String var1, FilePermissions var2) throws IOException;

    public String createTempFile(String var1, String var2, String var3) throws IOException;

    public void createNewFile(String var1) throws IOException;

    public void createNewFile(String var1, FilePermissions var2) throws IOException;

    public OutputStream create(String var1) throws IOException;

    public OutputStream create(String var1, boolean var2) throws IOException;

    public OutputStream create(String var1, boolean var2, FilePermissions var3) throws IOException;

    public OutputStream create(String var1, boolean var2, FilePermissions var3, int var4) throws IOException;

    public OutputStream create(String var1, boolean var2, FilePermissions var3, int var4, int var5, long var6) throws IOException;

    public OutputStream append(String var1) throws IOException;

    public OutputStream append(String var1, int var2) throws IOException;

    public boolean delete(String var1, boolean var2) throws IOException;

    public boolean exists(String var1) throws IOException;

    public boolean isFile(String var1) throws IOException;

    public boolean isDirectory(String var1) throws IOException;

    public InputStream open(String var1) throws IOException;

    public InputStream open(String var1, int var2) throws IOException;

    public RandomAccessInputStream openForRandomRead(String var1) throws IOException;

    public RandomAccessInputStream openForRandomRead(String var1, int var2) throws IOException;

    public OutputStream openForWrite(String var1) throws IOException;

    public OutputStream openForWrite(String var1, int var2) throws IOException;

    default public void writeFileFromInputStream(String path, InputStream inputStream, int bufferSize) throws IOException {
        throw new IOException("writeFileFromInputStream is not implemented");
    }

    public void copy(String var1, String var2) throws IOException;

    public void rename(String var1, String var2) throws IOException;

    public void move(String var1, String var2) throws IOException;

    public void setOwner(String var1, String var2, String var3) throws IOException;

    public void setPermissions(String var1, FilePermissions var2) throws IOException;

    public int getDefaultReplication(String var1) throws IOException;

    public long getDefaultBlockSize(String var1) throws IOException;

    public String separator() throws IOException;

    default public long getSize(String fileName) throws IOException {
        FileInfo info = this.getInfo(fileName);
        if (info == null) {
            return -1L;
        }
        return info.getSize();
    }

    public boolean isLocal();

    public long truncate(String var1, long var2) throws IOException;
}

