/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.fs.client;

import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;

public class FilePermissions {
    private Permission userPermission;
    private Permission groupPermission;
    private Permission otherPermission;
    private boolean stickyBit;

    public FilePermissions(Permission u, Permission g, Permission o) {
        this.set(u, g, o, false);
    }

    public FilePermissions(short mode) {
        this.fromShort(mode);
    }

    private void fromShort(short n) {
        Permission[] v = Permission.values();
        this.set(v[n >>> 6 & 7], v[n >>> 3 & 7], v[n & 7], (n >>> 9 & 1) == 1);
    }

    private void set(Permission u, Permission g, Permission o, boolean stickyBit) {
        this.userPermission = u;
        this.groupPermission = g;
        this.otherPermission = o;
        this.stickyBit = stickyBit;
    }

    public static FilePermissions getDefault() {
        return new FilePermissions(511);
    }

    public static FilePermissions getDirDefault() {
        return new FilePermissions(511);
    }

    public static FilePermissions getFileDefault() {
        return new FilePermissions(438);
    }

    public static FilePermissions parse(String permissions) {
        if (permissions == null || permissions.length() != 9 && permissions.length() != 10) {
            throw new IllegalArgumentException("Invalid persmissions, should in format -rwxrwxrwx.");
        }
        if (permissions.length() == 10) {
            permissions = permissions.substring(1);
        }
        try {
            return new FilePermissions(Permission.create(permissions.substring(0, 3)), Permission.create(permissions.substring(3, 6)), Permission.create(permissions.substring(6, 9)));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid permissions, should be in format -rwxrwxrwx.");
        }
    }

    public static FilePermissions fromPosixFilePermissions(Set<PosixFilePermission> permissions) {
        return new FilePermissions(Permission.create(permissions.contains((Object)PosixFilePermission.OWNER_READ), permissions.contains((Object)PosixFilePermission.OWNER_WRITE), permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)), Permission.create(permissions.contains((Object)PosixFilePermission.GROUP_READ), permissions.contains((Object)PosixFilePermission.GROUP_WRITE), permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)), Permission.create(permissions.contains((Object)PosixFilePermission.OTHERS_READ), permissions.contains((Object)PosixFilePermission.OTHERS_WRITE), permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)));
    }

    public Permission getUserPermission() {
        return this.userPermission;
    }

    public void setUserPermission(Permission userPermission) {
        this.userPermission = userPermission;
    }

    public Permission getGroupPermission() {
        return this.groupPermission;
    }

    public void setGroupPermission(Permission groupPermission) {
        this.groupPermission = groupPermission;
    }

    public Permission getOtherPermission() {
        return this.otherPermission;
    }

    public void setOtherPermission(Permission otherPermission) {
        this.otherPermission = otherPermission;
    }

    public boolean isStickyBit() {
        return this.stickyBit;
    }

    public void setStickyBit(boolean stickyBit) {
        this.stickyBit = stickyBit;
    }

    public String toString() {
        return this.userPermission.getName() + this.groupPermission.getName() + this.otherPermission.getName();
    }

    public short toShort() {
        int s = (this.stickyBit ? 512 : 0) | this.userPermission.ordinal() << 6 | this.groupPermission.ordinal() << 3 | this.otherPermission.ordinal();
        return (short)s;
    }

    public Set<PosixFilePermission> toPosixFilePermissions() {
        HashSet<PosixFilePermission> result = new HashSet<PosixFilePermission>();
        if (this.getUserPermission().canRead()) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        if (this.getUserPermission().canWrite()) {
            result.add(PosixFilePermission.OWNER_WRITE);
        }
        if (this.getUserPermission().canExecute()) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (this.getGroupPermission().canRead()) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if (this.getGroupPermission().canWrite()) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if (this.getGroupPermission().canExecute()) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (this.getOtherPermission().canRead()) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if (this.getOtherPermission().canWrite()) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (this.getOtherPermission().canExecute()) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(Permission.create(false, false, false).getName());
        System.out.println(Permission.create(true, false, false).getName());
        System.out.println(Permission.create(false, true, false).getName());
        System.out.println(Permission.create(false, false, true).getName());
        System.out.println(Permission.create(true, true, true).getName());
    }

    public static enum Permission {
        NONE("---"),
        EXECUTE("--x"),
        WRITE("-w-"),
        WRITE_EXECUTE("-wx"),
        READ("r--"),
        READ_EXECUTE("r-x"),
        READ_WRITE("rw-"),
        ALL("rwx");

        private final String name;

        private Permission(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean canExecute() {
            return (this.ordinal() & 1) == 1;
        }

        public boolean canWrite() {
            return (this.ordinal() & 2) == 2;
        }

        public boolean canRead() {
            return (this.ordinal() & 4) == 4;
        }

        public static Permission create(boolean read, boolean write, boolean execute) {
            byte mode = 0;
            if (execute) {
                mode = (byte)(mode | 1);
            }
            if (write) {
                mode = (byte)(mode | 2);
            }
            if (read) {
                mode = (byte)(mode | 4);
            }
            return Permission.values()[mode];
        }

        public static Permission create(byte mode) {
            if (mode < 0 || mode > 7) {
                throw new RuntimeException("mode should be in range [0,7].");
            }
            return Permission.values()[mode];
        }

        public static Permission create(String permission) {
            for (Permission p : Permission.values()) {
                if (!p.getName().equals(permission)) continue;
                return p;
            }
            throw new IllegalArgumentException("Invalid persmission " + permission + ".");
        }
    }
}

