/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.fs.client;

import com.streamscape.lib.fs.client.FilePermissions;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;

public class FileInfo {
    private String name;
    private String path;
    private long size;
    private boolean isDirectory;
    private long creationTime;
    private long modificationTime;
    private long accessTime;
    private FilePermissions permissions;
    private String owner;
    private String group;
    private String symLink;
    private long blockSize;
    private short replication;
    private String absolutePath;

    public FileInfo(String name, String path) {
        this(name, path, 0L, false, 0L, 0L, 0L, null, null, null, null, 0L, 0);
    }

    public FileInfo(FileInfo fileInfo) {
        this(fileInfo.name, fileInfo.path, fileInfo.size, fileInfo.isDirectory, fileInfo.creationTime, fileInfo.modificationTime, fileInfo.accessTime, fileInfo.permissions, fileInfo.owner, fileInfo.group, fileInfo.symLink, fileInfo.blockSize, fileInfo.replication);
    }

    public FileInfo(String name, String path, long size, boolean isDirectory, long creationTime, long modificationTime, long accessTime, FilePermissions permissions, String owner, String group, String symLink, long blockSize, short replication) {
        this.name = name;
        this.path = path;
        this.size = size;
        this.isDirectory = isDirectory;
        this.setCreationTime(creationTime);
        this.modificationTime = modificationTime;
        this.accessTime = accessTime;
        this.permissions = permissions != null ? permissions : (this.isDirectory() ? FilePermissions.getDirDefault() : (symLink != null ? FilePermissions.getDefault() : FilePermissions.getFileDefault()));
        this.owner = owner != null ? owner : "";
        this.group = group != null ? group : "";
        this.symLink = symLink;
        this.blockSize = blockSize;
        this.replication = replication;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    public FilePermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(FilePermissions permissions) {
        this.permissions = permissions;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getSymLink() {
        return this.symLink;
    }

    public void setSymLink(String symLink) {
        this.symLink = symLink;
    }

    public boolean isSymLink() {
        return this.symLink != null;
    }

    public boolean isFile() {
        return !this.isDirectory() && !this.isSymLink();
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public short getReplication() {
        return this.replication;
    }

    public void setReplication(short replication) {
        this.replication = replication;
    }

    public String getExtension() {
        return FilenameUtils.getExtension(this.name);
    }

    public String getBaseName() {
        return FilenameUtils.getBaseName(this.name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("path = '" + this.path + "' ");
        builder.append("name = '" + this.name + "' ");
        builder.append("size = '" + this.size + "' ");
        builder.append("permissions = '" + (this.isDirectory() ? "d" : "-") + this.permissions.toString() + "' ");
        builder.append("owner = '" + this.owner + "' ");
        builder.append("group = '" + this.group + "' ");
        builder.append("modificationTime = '" + new Date(this.modificationTime).toString() + "' ");
        builder.append("creationTime = '" + new Date(this.creationTime).toString() + "' ");
        builder.append("accessTime = '" + new Date(this.accessTime).toString() + "' ");
        builder.append("absolutePath = '" + this.absolutePath + "' ");
        return builder.toString();
    }
}

