/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.fs.client;

import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.lib.fs.client.FileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;

public abstract class AbstractFileSystem
implements FileSystem {
    public static int DEFAULT_BUFFER_SIZE = 0x400000;

    public int getDefaultBufferSize() {
        return DEFAULT_BUFFER_SIZE;
    }

    @Override
    public void mkdir(String path) throws IOException {
        this.mkdir(path, FilePermissions.getDirDefault());
    }

    @Override
    public void createNewFile(String path) throws IOException {
        this.createNewFile(path, FilePermissions.getFileDefault());
    }

    @Override
    public OutputStream create(String path) throws IOException {
        return this.create(path, false);
    }

    @Override
    public OutputStream create(String path, boolean overwrite) throws IOException {
        return this.create(path, overwrite, FilePermissions.getFileDefault());
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions) throws IOException {
        return this.create(path, overwrite, permissions, this.getDefaultBufferSize());
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize, int replication, long blockSize) throws IOException {
        return this.create(path, overwrite, permissions, bufferSize);
    }

    @Override
    public InputStream open(String path) throws IOException {
        return this.open(path, this.getDefaultBufferSize());
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path) throws IOException {
        return this.openForRandomRead(path, this.getDefaultBufferSize());
    }

    @Override
    public OutputStream append(String path) throws IOException {
        return this.append(path, this.getDefaultBufferSize());
    }

    @Override
    public OutputStream openForWrite(String path) throws IOException {
        return this.openForWrite(path, this.getDefaultBufferSize());
    }

    @Override
    public int getDefaultReplication(String path) throws IOException {
        return 1;
    }

    @Override
    public long getDefaultBlockSize(String path) throws IOException {
        return 0L;
    }

    @Override
    public String separator() {
        return FileSystems.getDefault().getSeparator();
    }
}

