/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WildcardMap<TValue> {
    private final char wildcard;
    private Map<Character, Map<String, TValue>> values = null;

    public WildcardMap(char wildcard) {
        this.wildcard = wildcard;
        this.values = new HashMap<Character, Map<String, TValue>>();
    }

    public WildcardMap(WildcardMap<TValue> other) {
        this.wildcard = other.wildcard;
        this.values = new HashMap<Character, Map<String, TValue>>(other.values);
    }

    public char getWildcard() {
        return this.wildcard;
    }

    public List<TValue> get(String pattern) {
        ArrayList<TValue> result = new ArrayList<TValue>();
        Map<String, TValue> valuesGroup = this.values.get(Character.valueOf(pattern.charAt(0)));
        if (valuesGroup != null) {
            for (Map.Entry<String, TValue> entry : valuesGroup.entrySet()) {
                if (!this.equals(pattern, entry.getKey())) continue;
                result.add(entry.getValue());
            }
        }
        return result.isEmpty() ? null : result;
    }

    public TValue getByKey(String key) {
        Map<String, TValue> valuesGroup = this.values.get(Character.valueOf(key.charAt(0)));
        return valuesGroup != null ? (TValue)valuesGroup.get(key) : null;
    }

    public void put(String key, TValue value) {
        char valuesGroupKey = key.charAt(0);
        Map<String, TValue> valuesGroup = this.values.get(Character.valueOf(valuesGroupKey));
        if (valuesGroup == null) {
            valuesGroup = new HashMap<String, TValue>();
            this.values.put(Character.valueOf(valuesGroupKey), valuesGroup);
        }
        valuesGroup.put(key, value);
    }

    public void remove(String pattern) {
        Map<String, TValue> valuesGroup = this.values.get(Character.valueOf(pattern.charAt(0)));
        if (valuesGroup != null) {
            ArrayList<String> removedKeys = new ArrayList<String>();
            for (Map.Entry<String, TValue> entry : valuesGroup.entrySet()) {
                if (!this.equals(pattern, entry.getKey())) continue;
                removedKeys.add(entry.getKey());
            }
            for (String key : removedKeys) {
                valuesGroup.remove(key);
            }
        }
    }

    public void removeByKey(String key) {
        char valuesGroupKey = key.charAt(0);
        Map<String, TValue> valuesGroup = this.values.get(Character.valueOf(valuesGroupKey));
        if (valuesGroup != null) {
            valuesGroup.remove(key);
            if (valuesGroup.isEmpty()) {
                this.values.remove(Character.valueOf(valuesGroupKey));
            }
        }
    }

    public List<TValue> getNegated(String pattern) {
        char valuesGroupKey = pattern.charAt(0);
        ArrayList<TValue> result = new ArrayList<TValue>();
        for (Map.Entry<Character, Map<String, TValue>> groupEntry : this.values.entrySet()) {
            if (groupEntry.getKey().charValue() != valuesGroupKey) {
                result.addAll(groupEntry.getValue().values());
                continue;
            }
            Map<String, TValue> valuesGroup = groupEntry.getValue();
            for (Map.Entry<String, TValue> entry : valuesGroup.entrySet()) {
                if (this.equals(pattern, entry.getKey())) continue;
                result.add(entry.getValue());
            }
        }
        return result.isEmpty() ? null : result;
    }

    public boolean containsKey(String key) {
        Map<String, TValue> valuesGroup = this.values.get(Character.valueOf(key.charAt(0)));
        return valuesGroup != null && valuesGroup.containsKey(key);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    private boolean equals(String pattern, String key) {
        return key.length() < pattern.length() && pattern.startsWith(key);
    }
}

