/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.filter;

import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.filter.FilterToken;
import com.streamscape.lib.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class FilterUtils {
    public static boolean matches(String pattern, String filter) throws FilterFormatException {
        return FilterUtils.matches(pattern, new CompositeFilter(filter));
    }

    public static boolean matches(String pattern, Filter filter) {
        return !filter.hasMetacharacters ? pattern.equals(filter.stringForm) : FilterUtils.matchesComplex(pattern, filter.tokens);
    }

    public static boolean matches(String pattern, CompositeFilter compositeFilter) {
        return compositeFilter.filters.stream().anyMatch(filter -> FilterUtils.matches(pattern, filter));
    }

    public static boolean isGenericFilter(String filter) {
        try {
            return new CompositeFilter(filter).hasMetacharacters();
        }
        catch (FilterFormatException ignored) {
            return false;
        }
    }

    static List<String> splitIntoSubfilters(String compositeFilter) throws FilterFormatException {
        ArrayList<String> result = new ArrayList<String>();
        FilterUtils.splitIntoSubfilters(compositeFilter, result);
        return result;
    }

    static void splitIntoSubfilters(String compositeFilter, List<String> result) throws FilterFormatException {
        StringUtils.splitWithTrim(compositeFilter, '&', result);
        FilterUtils.checkFormat(!result.isEmpty() && !result.contains(""), compositeFilter);
    }

    static boolean splitIntoTokens(String filter, List<FilterToken> result) throws FilterFormatException {
        try {
            List<String> tokens = StringUtils.split(filter, '.');
            FilterUtils.checkFormat(!tokens.isEmpty());
            boolean hasMetacharacters = false;
            for (int i = 0; i < tokens.size(); ++i) {
                FilterToken token = new FilterToken(tokens.get(i));
                hasMetacharacters |= FilterUtils.checkFilterToken(token, i == tokens.size() - 1);
                result.add(token);
            }
            return hasMetacharacters;
        }
        catch (FilterFormatException exception) {
            FilterUtils.throwFilterFormatException(filter);
            return false;
        }
    }

    static List<Filter> splitIntoFilters(String compositeFilter) throws FilterFormatException {
        ArrayList<Filter> result = new ArrayList<Filter>();
        FilterUtils.splitIntoFilters(compositeFilter, result);
        return result;
    }

    static void splitIntoFilters(String compositeFilter, List<Filter> result) throws FilterFormatException {
        for (String subfilter : FilterUtils.splitIntoSubfilters(compositeFilter)) {
            result.add(new Filter(subfilter));
        }
    }

    static boolean matchesComplex(String pattern, List<FilterToken> filterTokens) {
        if (filterTokens.get((int)0).isSharp) {
            return true;
        }
        List<String> patternTokens = StringUtils.split(pattern, '.');
        for (int i = 0; i < patternTokens.size(); ++i) {
            if (i >= filterTokens.size()) {
                return false;
            }
            FilterToken filterToken = filterTokens.get(i);
            String patternToken = patternTokens.get(i);
            if (filterToken.isSharp) {
                return true;
            }
            if (filterToken.isWildcard) continue;
            if (filterToken.isNegated) {
                if (filterToken.hasSharp) {
                    return !FilterUtils.matchesWithSharp(patternToken, filterToken.name, i == patternTokens.size() - 1);
                }
                if (!(filterToken.hasWildcard ? FilterUtils.matchesWithWildcard(patternToken, filterToken.name) : patternToken.equals(filterToken.name))) continue;
                return false;
            }
            if (filterToken.hasSharp) {
                return FilterUtils.matchesWithSharp(patternToken, filterToken.name, i == patternTokens.size() - 1);
            }
            if (!(filterToken.hasWildcard ? !FilterUtils.matchesWithWildcard(patternToken, filterToken.name) : !patternToken.equals(filterToken.name))) continue;
            return false;
        }
        return patternTokens.size() == filterTokens.size();
    }

    static boolean matchesWithSharp(String patternToken, String filterToken, boolean isLastPatternToken) {
        return patternToken.startsWith(filterToken) && (patternToken.length() > filterToken.length() || !isLastPatternToken);
    }

    static boolean matchesWithWildcard(String patternToken, String filterToken) {
        return patternToken.startsWith(filterToken) && patternToken.length() > filterToken.length();
    }

    static boolean checkFilterToken(FilterToken token, boolean isLastToken) throws FilterFormatException {
        FilterUtils.checkFormat(token.name.length() != 0);
        boolean hasMetacharacters = false;
        for (int i = 0; i < token.name.length(); ++i) {
            char c = token.name.charAt(i);
            if (c == '#') {
                FilterUtils.checkFormat(i == token.name.length() - 1 && isLastToken);
                if (i == 0) {
                    token.isSharp = true;
                } else {
                    token.hasSharp = true;
                    token.name = token.name.substring(0, i);
                }
                return true;
            }
            if (c == '*') {
                FilterUtils.checkFormat(i == token.name.length() - 1);
                if (i == 0) {
                    token.isWildcard = true;
                } else {
                    token.hasWildcard = true;
                    token.name = token.name.substring(0, i);
                }
                return true;
            }
            if (c == '!') {
                FilterUtils.checkFormat(i == 0 && token.name.length() > 1);
                char nextChar = token.name.charAt(1);
                FilterUtils.checkFormat(nextChar != '*' && nextChar != '#');
                token.name = token.name.substring(1);
                token.isNegated = true;
                hasMetacharacters = true;
                continue;
            }
            FilterUtils.checkFormat(Character.isJavaIdentifierPart(c) || c == '[' || c == ']' || c == '-');
        }
        return hasMetacharacters;
    }

    static void checkFormat(boolean condition) throws FilterFormatException {
        if (!condition) {
            throw new FilterFormatException();
        }
    }

    static void checkFormat(boolean condition, String filter) throws FilterFormatException {
        if (!condition) {
            FilterUtils.throwFilterFormatException(filter);
        }
    }

    static void throwFilterFormatException(String filter) throws FilterFormatException {
        throw new FilterFormatException("Filter '" + filter + "' has invalid format.");
    }
}

