/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.filter;

import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.filter.FilterToken;
import com.streamscape.lib.filter.WildcardMap;
import com.streamscape.lib.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FilterSingleMap<T> {
    private Map<String, T> simpleFilters = new HashMap<String, T>();
    private FilterItem<T> complexFiltersRoot = null;

    public List<T> get(String pattern) {
        List<T> result = null;
        T simpleResult = this.simpleFilters.get(pattern);
        if (simpleResult != null) {
            result = new ArrayList<T>();
            result.add(simpleResult);
        }
        if (this.complexFiltersRoot != null) {
            ArrayList<FilterItem<T>> currentItems = new ArrayList<FilterItem<T>>();
            currentItems.add(this.complexFiltersRoot);
            result = this.getComplex(pattern, currentItems, result);
        }
        return result;
    }

    public T getByFilter(String filter) throws FilterFormatException {
        return this.getByFilter(new Filter(filter));
    }

    public T getByFilter(Filter filter) {
        if (!filter.hasMetacharacters) {
            return this.simpleFilters.get(filter.stringForm);
        }
        if (this.complexFiltersRoot != null) {
            return this.getByFilterComplex(filter.tokens);
        }
        return null;
    }

    public void put(String filter, T object) throws FilterFormatException {
        this.put(new Filter(filter), object);
    }

    public void put(Filter filter, T object) {
        if (!filter.hasMetacharacters) {
            this.putSimple(filter.stringForm, object);
        } else {
            this.putComplex(filter.tokens, object);
        }
    }

    public void remove(String filter) throws FilterFormatException {
        this.remove(new Filter(filter));
    }

    public void remove(Filter filter) {
        if (!filter.hasMetacharacters) {
            this.removeSimple(filter.stringForm);
        } else if (this.complexFiltersRoot != null && this.removeComplex(filter.tokens, this.complexFiltersRoot, 0)) {
            this.complexFiltersRoot = null;
        }
    }

    public boolean contains(String pattern) {
        boolean result = this.simpleFilters.containsKey(pattern);
        if (!result && this.complexFiltersRoot != null) {
            LinkedList<FilterItem<T>> currentItems = new LinkedList<FilterItem<T>>();
            currentItems.add(this.complexFiltersRoot);
            return this.containsComplex(StringUtils.split(pattern, '.'), currentItems, 0);
        }
        return result;
    }

    public boolean containsFilter(String filter) throws FilterFormatException {
        return this.containsFilter(new Filter(filter));
    }

    public boolean containsFilter(Filter filter) {
        return !filter.hasMetacharacters ? this.simpleFilters.containsKey(filter.stringForm) : this.complexFiltersRoot != null && this.containsFilterComplex(filter.tokens);
    }

    public boolean isEmpty() {
        return this.simpleFilters.isEmpty() && this.complexFiltersRoot == null;
    }

    public void clear() {
        this.simpleFilters.clear();
        this.complexFiltersRoot = null;
    }

    private void putSimple(String filter, T object) {
        this.simpleFilters.put(filter, object);
    }

    private void putComplex(List<FilterToken> tokens, T object) {
        if (this.complexFiltersRoot == null) {
            this.complexFiltersRoot = new FilterItem();
        }
        FilterItem<T> currentItem = this.complexFiltersRoot;
        for (FilterToken token : tokens) {
            if (token.isSharp) {
                if (currentItem.sharpChild == null) {
                    currentItem.sharpChild = new FilterItem();
                }
                currentItem = currentItem.sharpChild;
                continue;
            }
            if (token.isWildcard) {
                if (currentItem.wildcardChild == null) {
                    currentItem.wildcardChild = new FilterItem();
                }
                currentItem = currentItem.wildcardChild;
                continue;
            }
            if (token.isNegated) {
                if (token.hasSharp) {
                    if (currentItem.negatedSharpedChilds == null) {
                        currentItem.negatedSharpedChilds = new WildcardMap('#');
                    }
                    if (!currentItem.negatedSharpedChilds.containsKey(token.name)) {
                        currentItem.negatedSharpedChilds.put(token.name, new FilterItem());
                    }
                    currentItem = currentItem.negatedSharpedChilds.getByKey(token.name);
                    continue;
                }
                if (token.hasWildcard) {
                    if (currentItem.negatedWildcardedChilds == null) {
                        currentItem.negatedWildcardedChilds = new WildcardMap('*');
                    }
                    if (!currentItem.negatedWildcardedChilds.containsKey(token.name)) {
                        currentItem.negatedWildcardedChilds.put(token.name, new FilterItem());
                    }
                    currentItem = currentItem.negatedWildcardedChilds.getByKey(token.name);
                    continue;
                }
                if (currentItem.negatedSimpleChilds == null) {
                    currentItem.negatedSimpleChilds = new HashMap();
                }
                if (!currentItem.negatedSimpleChilds.containsKey(token.name)) {
                    currentItem.negatedSimpleChilds.put(token.name, new FilterItem());
                }
                currentItem = currentItem.negatedSimpleChilds.get(token.name);
                continue;
            }
            if (token.hasSharp) {
                if (currentItem.sharpedChilds == null) {
                    currentItem.sharpedChilds = new WildcardMap('#');
                }
                if (!currentItem.sharpedChilds.containsKey(token.name)) {
                    currentItem.sharpedChilds.put(token.name, new FilterItem());
                }
                currentItem = currentItem.sharpedChilds.getByKey(token.name);
                continue;
            }
            if (token.hasWildcard) {
                if (currentItem.wildcardedChilds == null) {
                    currentItem.wildcardedChilds = new WildcardMap('*');
                }
                if (!currentItem.wildcardedChilds.containsKey(token.name)) {
                    currentItem.wildcardedChilds.put(token.name, new FilterItem());
                }
                currentItem = currentItem.wildcardedChilds.getByKey(token.name);
                continue;
            }
            if (currentItem.simpleChilds == null) {
                currentItem.simpleChilds = new HashMap();
            }
            if (!currentItem.simpleChilds.containsKey(token.name)) {
                currentItem.simpleChilds.put(token.name, new FilterItem());
            }
            currentItem = currentItem.simpleChilds.get(token.name);
        }
        currentItem.object = object;
    }

    private void removeSimple(String filter) {
        this.simpleFilters.remove(filter);
    }

    private boolean removeComplex(List<FilterToken> tokens, FilterItem<T> currentItem, int tokenIndex) {
        if (tokenIndex < tokens.size()) {
            FilterItem childItem;
            FilterToken token = tokens.get(tokenIndex++);
            if (token.isSharp) {
                if (currentItem.sharpChild != null && this.removeComplex(tokens, currentItem.sharpChild, tokenIndex)) {
                    currentItem.sharpChild = null;
                    if (currentItem.isEmpty()) {
                        return true;
                    }
                }
            } else if (token.isWildcard) {
                if (currentItem.wildcardChild != null && this.removeComplex(tokens, currentItem.wildcardChild, tokenIndex)) {
                    currentItem.wildcardChild = null;
                    if (currentItem.isEmpty()) {
                        return true;
                    }
                }
            } else if (token.isNegated) {
                FilterItem childItem2;
                if (token.hasSharp) {
                    FilterItem childItem3;
                    if (currentItem.negatedSharpedChilds != null && (childItem3 = currentItem.negatedSharpedChilds.getByKey(token.name)) != null && this.removeComplex(tokens, childItem3, tokenIndex)) {
                        currentItem.negatedSharpedChilds.removeByKey(token.name);
                        if (currentItem.negatedSharpedChilds.isEmpty()) {
                            currentItem.negatedSharpedChilds = null;
                        }
                        if (currentItem.isEmpty()) {
                            return true;
                        }
                    }
                } else if (token.hasWildcard) {
                    FilterItem childItem4;
                    if (currentItem.negatedWildcardedChilds != null && (childItem4 = currentItem.negatedWildcardedChilds.getByKey(token.name)) != null && this.removeComplex(tokens, childItem4, tokenIndex)) {
                        currentItem.negatedWildcardedChilds.removeByKey(token.name);
                        if (currentItem.negatedWildcardedChilds.isEmpty()) {
                            currentItem.negatedWildcardedChilds = null;
                        }
                        if (currentItem.isEmpty()) {
                            return true;
                        }
                    }
                } else if (currentItem.negatedSimpleChilds != null && (childItem2 = currentItem.negatedSimpleChilds.get(token.name)) != null && this.removeComplex(tokens, childItem2, tokenIndex)) {
                    currentItem.negatedSimpleChilds.remove(token.name);
                    if (currentItem.negatedSimpleChilds.isEmpty()) {
                        currentItem.negatedSimpleChilds = null;
                    }
                    if (currentItem.isEmpty()) {
                        return true;
                    }
                }
            } else if (token.hasSharp) {
                FilterItem childItem5;
                if (currentItem.sharpedChilds != null && (childItem5 = currentItem.sharpedChilds.getByKey(token.name)) != null && this.removeComplex(tokens, childItem5, tokenIndex)) {
                    currentItem.sharpedChilds.removeByKey(token.name);
                    if (currentItem.sharpedChilds.isEmpty()) {
                        currentItem.sharpedChilds = null;
                    }
                    if (currentItem.isEmpty()) {
                        return true;
                    }
                }
            } else if (token.hasWildcard) {
                FilterItem childItem6;
                if (currentItem.wildcardedChilds != null && (childItem6 = currentItem.wildcardedChilds.getByKey(token.name)) != null && this.removeComplex(tokens, childItem6, tokenIndex)) {
                    currentItem.wildcardedChilds.removeByKey(token.name);
                    if (currentItem.wildcardedChilds.isEmpty()) {
                        currentItem.wildcardedChilds = null;
                    }
                    if (currentItem.isEmpty()) {
                        return true;
                    }
                }
            } else if (currentItem.simpleChilds != null && (childItem = currentItem.simpleChilds.get(token.name)) != null && this.removeComplex(tokens, childItem, tokenIndex)) {
                currentItem.simpleChilds.remove(token.name);
                if (currentItem.simpleChilds.isEmpty()) {
                    currentItem.simpleChilds = null;
                }
                if (currentItem.isEmpty()) {
                    return true;
                }
            }
            return false;
        }
        if (currentItem.object != null) {
            currentItem.object = null;
            if (!currentItem.hasChildItems()) {
                return true;
            }
        }
        return false;
    }

    private List<T> getComplex(String pattern, List<FilterItem<T>> currentItems, List<T> result) {
        int iTokenBegin = 0;
        int iTokenEnd = 0;
        while (iTokenEnd <= pattern.length()) {
            iTokenEnd = pattern.indexOf(46, iTokenBegin);
            if (iTokenEnd < 0) {
                iTokenEnd = pattern.length();
            }
            ArrayList<FilterItem<T>> matchedItems = new ArrayList<FilterItem<T>>();
            result = this.processToken(pattern.substring(iTokenBegin, iTokenEnd), currentItems, matchedItems, result);
            if (matchedItems.isEmpty()) {
                return result;
            }
            iTokenBegin = ++iTokenEnd;
            currentItems = matchedItems;
        }
        for (FilterItem<T> item : currentItems) {
            if (item.object == null) continue;
            result = this.add(item.object, result);
        }
        return result;
    }

    private List<T> processToken(String token, List<FilterItem<T>> currentItems, List<FilterItem<T>> matchedItems, List<T> result) {
        for (FilterItem<T> item : currentItems) {
            FilterItem childItem;
            List wildcardedChildItems;
            List sharpedChildItems;
            HashMap addedChilds;
            if (item.sharpChild != null) {
                result = this.add(item.sharpChild.object, result);
            }
            if (item.wildcardChild != null) {
                matchedItems.add(item.wildcardChild);
            }
            if (item.negatedSharpedChilds != null && (addedChilds = item.negatedSharpedChilds.getNegated(token)) != null) {
                Iterator iterator = addedChilds.iterator();
                while (iterator.hasNext()) {
                    FilterItem addedChild = iterator.next();
                    result = this.add(addedChild.object, result);
                }
            }
            if (item.negatedWildcardedChilds != null && (addedChilds = item.negatedWildcardedChilds.getNegated(token)) != null) {
                matchedItems.addAll((Collection<FilterItem<T>>)((Object)addedChilds));
            }
            if (item.negatedSimpleChilds != null) {
                addedChilds = item.negatedSimpleChilds;
                if (item.negatedSimpleChilds.containsKey(token)) {
                    addedChilds = new HashMap(item.negatedSimpleChilds);
                    addedChilds.remove(token);
                }
                matchedItems.addAll(addedChilds.values());
            }
            if (item.sharpedChilds != null && (sharpedChildItems = item.sharpedChilds.get(token)) != null) {
                for (FilterItem sharpedChild : sharpedChildItems) {
                    result = this.add(sharpedChild.object, result);
                }
            }
            if (item.wildcardedChilds != null && (wildcardedChildItems = item.wildcardedChilds.get(token)) != null) {
                matchedItems.addAll(wildcardedChildItems);
            }
            if (item.simpleChilds == null || (childItem = item.simpleChilds.get(token)) == null) continue;
            matchedItems.add(childItem);
        }
        return result;
    }

    private List<T> add(T object, List<T> result) {
        if (result == null) {
            result = new ArrayList<T>();
        }
        result.add(object);
        return result;
    }

    private T getByFilterComplex(List<FilterToken> tokens) {
        FilterItem<T> currentItem = this.complexFiltersRoot;
        for (FilterToken token : tokens) {
            if (token.isSharp) {
                if (currentItem.sharpChild == null) continue;
                currentItem = currentItem.sharpChild;
                continue;
            }
            if (token.isWildcard) {
                if (currentItem.wildcardChild == null) continue;
                currentItem = currentItem.wildcardChild;
                continue;
            }
            if (token.isNegated) {
                if (token.hasSharp) {
                    if (currentItem.negatedSharpedChilds == null || !currentItem.negatedSharpedChilds.containsKey(token.name)) continue;
                    currentItem = currentItem.negatedSharpedChilds.getByKey(token.name);
                    continue;
                }
                if (token.hasWildcard) {
                    if (currentItem.negatedWildcardedChilds == null || !currentItem.negatedWildcardedChilds.containsKey(token.name)) continue;
                    currentItem = currentItem.negatedWildcardedChilds.getByKey(token.name);
                    continue;
                }
                if (currentItem.negatedSimpleChilds == null || !currentItem.negatedSimpleChilds.containsKey(token.name)) continue;
                currentItem = currentItem.negatedSimpleChilds.get(token.name);
                continue;
            }
            if (token.hasSharp) {
                if (currentItem.sharpedChilds == null || !currentItem.sharpedChilds.containsKey(token.name)) continue;
                currentItem = currentItem.sharpedChilds.getByKey(token.name);
                continue;
            }
            if (token.hasWildcard) {
                if (currentItem.wildcardedChilds == null || !currentItem.wildcardedChilds.containsKey(token.name)) continue;
                currentItem = currentItem.wildcardedChilds.getByKey(token.name);
                continue;
            }
            if (currentItem.simpleChilds == null || !currentItem.simpleChilds.containsKey(token.name)) continue;
            currentItem = currentItem.simpleChilds.get(token.name);
        }
        return currentItem.object;
    }

    private boolean containsComplex(List<String> tokens, List<FilterItem<T>> currentItems, int tokenIndex) {
        boolean status = true;
        if (tokenIndex < tokens.size()) {
            LinkedList<FilterItem<T>> matchedItems = new LinkedList<FilterItem<T>>();
            String token = tokens.get(tokenIndex++);
            for (FilterItem<T> item : currentItems) {
                FilterItem childItem;
                List wildcardedChildItems;
                List sharpedChildItems;
                HashMap addedChilds;
                if (item.sharpChild != null) {
                    return true;
                }
                if (item.wildcardChild != null) {
                    matchedItems.add(item.wildcardChild);
                }
                if (item.negatedSharpedChilds != null && (addedChilds = item.negatedSharpedChilds.getNegated(token)) != null) {
                    return true;
                }
                if (item.negatedWildcardedChilds != null && (addedChilds = item.negatedWildcardedChilds.getNegated(token)) != null) {
                    matchedItems.addAll((Collection<FilterItem<T>>)((Object)addedChilds));
                }
                if (item.negatedSimpleChilds != null) {
                    addedChilds = item.negatedSimpleChilds;
                    if (item.negatedSimpleChilds.containsKey(token)) {
                        addedChilds = new HashMap(item.negatedSimpleChilds);
                        addedChilds.remove(token);
                    }
                    matchedItems.addAll(addedChilds.values());
                }
                if (item.sharpedChilds != null && (sharpedChildItems = item.sharpedChilds.get(token)) != null) {
                    return true;
                }
                if (item.wildcardedChilds != null && (wildcardedChildItems = item.wildcardedChilds.get(token)) != null) {
                    matchedItems.addAll(wildcardedChildItems);
                }
                if (item.simpleChilds == null || (childItem = item.simpleChilds.get(token)) == null) continue;
                matchedItems.add(childItem);
            }
            if (matchedItems.isEmpty()) {
                return false;
            }
            status = this.containsComplex(tokens, matchedItems, tokenIndex);
        }
        if (status) {
            for (FilterItem<T> item : currentItems) {
                if (item.object == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsFilterComplex(List<FilterToken> tokens) {
        FilterItem<T> currentItem = this.complexFiltersRoot;
        for (FilterToken token : tokens) {
            if (token.isSharp) {
                if (currentItem.sharpChild != null) {
                    return true;
                }
            } else if (token.isWildcard) {
                if (currentItem.wildcardChild != null) {
                    currentItem = currentItem.wildcardChild;
                    continue;
                }
            } else if (token.isNegated) {
                if (token.hasSharp) {
                    if (currentItem.negatedSharpedChilds != null && currentItem.negatedSharpedChilds.containsKey(token.name)) {
                        currentItem = currentItem.negatedSharpedChilds.getByKey(token.name);
                        continue;
                    }
                } else if (token.hasWildcard) {
                    if (currentItem.negatedWildcardedChilds != null && currentItem.negatedWildcardedChilds.containsKey(token.name)) {
                        currentItem = currentItem.negatedWildcardedChilds.getByKey(token.name);
                        continue;
                    }
                } else if (currentItem.negatedSimpleChilds != null && currentItem.negatedSimpleChilds.containsKey(token.name)) {
                    currentItem = currentItem.negatedSimpleChilds.get(token.name);
                    continue;
                }
            } else if (token.hasSharp) {
                if (currentItem.sharpedChilds == null) {
                    currentItem = currentItem.sharpedChilds.getByKey(token.name);
                    continue;
                }
            } else if (token.hasWildcard) {
                if (currentItem.wildcardedChilds != null && currentItem.wildcardedChilds.containsKey(token.name)) {
                    currentItem = currentItem.wildcardedChilds.getByKey(token.name);
                    continue;
                }
            } else if (currentItem.simpleChilds != null && currentItem.simpleChilds.containsKey(token.name)) {
                currentItem = currentItem.simpleChilds.get(token.name);
                continue;
            }
            return false;
        }
        return currentItem.object != null;
    }

    private static class FilterItem<T> {
        FilterItem<T> sharpChild = null;
        FilterItem<T> wildcardChild = null;
        WildcardMap<FilterItem<T>> negatedSharpedChilds = null;
        WildcardMap<FilterItem<T>> negatedWildcardedChilds = null;
        Map<String, FilterItem<T>> negatedSimpleChilds = null;
        WildcardMap<FilterItem<T>> sharpedChilds = null;
        WildcardMap<FilterItem<T>> wildcardedChilds = null;
        Map<String, FilterItem<T>> simpleChilds = null;
        T object = null;

        private FilterItem() {
        }

        boolean hasChildItems() {
            return this.sharpChild != null || this.wildcardChild != null || this.negatedSharpedChilds != null || this.negatedWildcardedChilds != null || this.negatedSimpleChilds != null || this.sharpedChilds != null || this.wildcardedChilds != null || this.simpleChilds != null;
        }

        boolean isEmpty() {
            return this.object == null && !this.hasChildItems();
        }
    }
}

