/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.filter;

import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.filter.FilterToken;
import com.streamscape.lib.filter.FilterUtils;
import com.streamscape.lib.filter.WildcardMap;
import com.streamscape.lib.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FilterMap<T> {
    private Map<String, List<T>> simpleFilters = new HashMap<String, List<T>>();
    private FilterItem<T> complexFiltersRoot = null;

    public List<T> get(String pattern) {
        List<T> simpleResult = this.simpleFilters.get(pattern);
        List<T> result = null;
        if (this.complexFiltersRoot != null) {
            ArrayList<FilterItem<T>> currentItems = new ArrayList<FilterItem<T>>();
            currentItems.add(this.complexFiltersRoot);
            List<T> complexResult = this.getComplex(pattern, currentItems);
            if (complexResult != null) {
                if (simpleResult != null) {
                    complexResult.addAll(simpleResult);
                }
                result = complexResult;
            } else if (simpleResult != null) {
                result = new ArrayList<T>(simpleResult);
            }
        } else if (simpleResult != null) {
            result = new ArrayList<T>(simpleResult);
        }
        return result;
    }

    public void put(String filter, T object) throws FilterFormatException {
        FilterMap.checkNull(filter);
        this.put(new CompositeFilter(filter, false), object);
    }

    public void put(CompositeFilter compositeFilter, T object) {
        for (Filter filter : compositeFilter.filters) {
            if (!filter.hasMetacharacters) {
                this.putSimple(filter.stringForm, object);
                continue;
            }
            this.putComplex(filter.tokens, object);
        }
    }

    public void remove(String filter, T object) throws FilterFormatException {
        FilterMap.checkNull(filter);
        this.remove(new CompositeFilter(filter, false), object);
    }

    public void remove(CompositeFilter compositeFilter, T object) {
        for (Filter filter : compositeFilter.filters) {
            if (!filter.hasMetacharacters) {
                this.removeSimple(filter.stringForm, object);
                continue;
            }
            if (this.complexFiltersRoot == null || !this.removeComplex(filter.tokens, object, this.complexFiltersRoot, 0)) continue;
            this.complexFiltersRoot = null;
        }
    }

    public boolean contains(String pattern) {
        boolean result = this.simpleFilters.containsKey(pattern);
        if (!result && this.complexFiltersRoot != null) {
            ArrayList<FilterItem<T>> currentItems = new ArrayList<FilterItem<T>>();
            currentItems.add(this.complexFiltersRoot);
            return this.containsComplex(StringUtils.split(pattern, '.'), currentItems, 0);
        }
        return result;
    }

    public boolean containsFilter(String filter) throws FilterFormatException {
        FilterMap.checkNull(filter);
        return this.containsFilter(new CompositeFilter(filter, false));
    }

    public boolean containsFilter(CompositeFilter compositeFilter) {
        for (Filter filter : compositeFilter.filters) {
            if (!(!filter.hasMetacharacters ? this.simpleFilters.containsKey(filter.stringForm) : this.complexFiltersRoot != null && this.containsFilterComplex(filter.tokens))) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.simpleFilters.isEmpty() && this.complexFiltersRoot == null;
    }

    public void clear() {
        this.simpleFilters.clear();
        this.complexFiltersRoot = null;
    }

    protected void putSimple(String filter, T object) {
        List<T> objects = this.simpleFilters.get(filter);
        if (objects != null) {
            objects.remove(object);
            objects.add(object);
        } else {
            objects = new ArrayList<T>();
            objects.add(object);
            this.simpleFilters.put(filter, objects);
        }
    }

    protected void putComplex(List<FilterToken> tokens, T object) {
        if (this.complexFiltersRoot == null) {
            this.complexFiltersRoot = new FilterItem();
        }
        FilterItem<T> currentItem = this.complexFiltersRoot;
        for (FilterToken token : tokens) {
            if (token.isSharp) {
                if (currentItem.sharpChild == null) {
                    currentItem.sharpChild = new FilterItem();
                }
                currentItem = currentItem.sharpChild;
                continue;
            }
            if (token.isWildcard) {
                if (currentItem.wildcardChild == null) {
                    currentItem.wildcardChild = new FilterItem();
                }
                currentItem = currentItem.wildcardChild;
                continue;
            }
            if (token.isNegated) {
                if (token.hasSharp) {
                    if (currentItem.negatedSharpedChilds == null) {
                        currentItem.negatedSharpedChilds = new WildcardMap('#');
                    }
                    if (!currentItem.negatedSharpedChilds.containsKey(token.name)) {
                        currentItem.negatedSharpedChilds.put(token.name, new FilterItem());
                    }
                    currentItem = currentItem.negatedSharpedChilds.getByKey(token.name);
                    continue;
                }
                if (token.hasWildcard) {
                    if (currentItem.negatedWildcardedChilds == null) {
                        currentItem.negatedWildcardedChilds = new WildcardMap('*');
                    }
                    if (!currentItem.negatedWildcardedChilds.containsKey(token.name)) {
                        currentItem.negatedWildcardedChilds.put(token.name, new FilterItem());
                    }
                    currentItem = currentItem.negatedWildcardedChilds.getByKey(token.name);
                    continue;
                }
                if (currentItem.negatedSimpleChilds == null) {
                    currentItem.negatedSimpleChilds = new HashMap();
                }
                if (!currentItem.negatedSimpleChilds.containsKey(token.name)) {
                    currentItem.negatedSimpleChilds.put(token.name, new FilterItem());
                }
                currentItem = currentItem.negatedSimpleChilds.get(token.name);
                continue;
            }
            if (token.hasSharp) {
                if (currentItem.sharpedChilds == null) {
                    currentItem.sharpedChilds = new WildcardMap('#');
                }
                if (!currentItem.sharpedChilds.containsKey(token.name)) {
                    currentItem.sharpedChilds.put(token.name, new FilterItem());
                }
                currentItem = currentItem.sharpedChilds.getByKey(token.name);
                continue;
            }
            if (token.hasWildcard) {
                if (currentItem.wildcardedChilds == null) {
                    currentItem.wildcardedChilds = new WildcardMap('*');
                }
                if (!currentItem.wildcardedChilds.containsKey(token.name)) {
                    currentItem.wildcardedChilds.put(token.name, new FilterItem());
                }
                currentItem = currentItem.wildcardedChilds.getByKey(token.name);
                continue;
            }
            if (currentItem.simpleChilds == null) {
                currentItem.simpleChilds = new HashMap();
            }
            if (!currentItem.simpleChilds.containsKey(token.name)) {
                currentItem.simpleChilds.put(token.name, new FilterItem());
            }
            currentItem = currentItem.simpleChilds.get(token.name);
        }
        if (currentItem.objects == null) {
            currentItem.objects = new ArrayList();
        } else {
            currentItem.objects.remove(object);
        }
        currentItem.objects.add(object);
    }

    protected void removeSimple(String filter, T object) {
        Collection objects = this.simpleFilters.get(filter);
        if (objects != null) {
            objects.remove(object);
            if (objects.isEmpty()) {
                this.simpleFilters.remove(filter);
            }
        }
    }

    protected boolean removeComplex(List<FilterToken> tokens, T object, FilterItem<T> currentItem, int tokenIndex) {
        if (tokenIndex < tokens.size()) {
            FilterItem childItem;
            FilterToken token = tokens.get(tokenIndex++);
            if (token.isSharp) {
                if (currentItem.sharpChild != null && this.removeComplex(tokens, object, currentItem.sharpChild, tokenIndex)) {
                    currentItem.sharpChild = null;
                    if (currentItem.isEmpty()) {
                        return true;
                    }
                }
            } else if (token.isWildcard) {
                if (currentItem.wildcardChild != null && this.removeComplex(tokens, object, currentItem.wildcardChild, tokenIndex)) {
                    currentItem.wildcardChild = null;
                    if (currentItem.isEmpty()) {
                        return true;
                    }
                }
            } else if (token.isNegated) {
                FilterItem childItem2;
                if (token.hasSharp) {
                    FilterItem childItem3;
                    if (currentItem.negatedSharpedChilds != null && (childItem3 = currentItem.negatedSharpedChilds.getByKey(token.name)) != null && this.removeComplex(tokens, object, childItem3, tokenIndex)) {
                        currentItem.negatedSharpedChilds.removeByKey(token.name);
                        if (currentItem.negatedSharpedChilds.isEmpty()) {
                            currentItem.negatedSharpedChilds = null;
                        }
                        if (currentItem.isEmpty()) {
                            return true;
                        }
                    }
                } else if (token.hasWildcard) {
                    FilterItem childItem4;
                    if (currentItem.negatedWildcardedChilds != null && (childItem4 = currentItem.negatedWildcardedChilds.getByKey(token.name)) != null && this.removeComplex(tokens, object, childItem4, tokenIndex)) {
                        currentItem.negatedWildcardedChilds.removeByKey(token.name);
                        if (currentItem.negatedWildcardedChilds.isEmpty()) {
                            currentItem.negatedWildcardedChilds = null;
                        }
                        if (currentItem.isEmpty()) {
                            return true;
                        }
                    }
                } else if (currentItem.negatedSimpleChilds != null && (childItem2 = currentItem.negatedSimpleChilds.get(token.name)) != null && this.removeComplex(tokens, object, childItem2, tokenIndex)) {
                    currentItem.negatedSimpleChilds.remove(token.name);
                    if (currentItem.negatedSimpleChilds.isEmpty()) {
                        currentItem.negatedSimpleChilds = null;
                    }
                    if (currentItem.isEmpty()) {
                        return true;
                    }
                }
            } else if (token.hasSharp) {
                FilterItem childItem5;
                if (currentItem.sharpedChilds != null && (childItem5 = currentItem.sharpedChilds.getByKey(token.name)) != null && this.removeComplex(tokens, object, childItem5, tokenIndex)) {
                    currentItem.sharpedChilds.removeByKey(token.name);
                    if (currentItem.sharpedChilds.isEmpty()) {
                        currentItem.sharpedChilds = null;
                    }
                    if (currentItem.isEmpty()) {
                        return true;
                    }
                }
            } else if (token.hasWildcard) {
                FilterItem childItem6;
                if (currentItem.wildcardedChilds != null && (childItem6 = currentItem.wildcardedChilds.getByKey(token.name)) != null && this.removeComplex(tokens, object, childItem6, tokenIndex)) {
                    currentItem.wildcardedChilds.removeByKey(token.name);
                    if (currentItem.wildcardedChilds.isEmpty()) {
                        currentItem.wildcardedChilds = null;
                    }
                    if (currentItem.isEmpty()) {
                        return true;
                    }
                }
            } else if (currentItem.simpleChilds != null && (childItem = currentItem.simpleChilds.get(token.name)) != null && this.removeComplex(tokens, object, childItem, tokenIndex)) {
                currentItem.simpleChilds.remove(token.name);
                if (currentItem.simpleChilds.isEmpty()) {
                    currentItem.simpleChilds = null;
                }
                if (currentItem.isEmpty()) {
                    return true;
                }
            }
            return false;
        }
        if (currentItem.objects != null) {
            currentItem.objects.remove(object);
            if (currentItem.objects.isEmpty()) {
                currentItem.objects = null;
                if (!currentItem.hasChildItems()) {
                    return true;
                }
            }
        }
        return false;
    }

    protected Collection<T> getSimple(String pattern) {
        return this.simpleFilters.get(pattern);
    }

    protected List<T> getComplex(String pattern, List<FilterItem<T>> currentItems) {
        List result = null;
        int iTokenBegin = 0;
        int iTokenEnd = 0;
        while (iTokenEnd <= pattern.length()) {
            iTokenEnd = pattern.indexOf(46, iTokenBegin);
            if (iTokenEnd < 0) {
                iTokenEnd = pattern.length();
            }
            ArrayList<FilterItem<T>> matchedItems = new ArrayList<FilterItem<T>>();
            result = this.processToken(pattern.substring(iTokenBegin, iTokenEnd), currentItems, matchedItems, result);
            if (matchedItems.isEmpty()) {
                return result;
            }
            iTokenBegin = ++iTokenEnd;
            currentItems = matchedItems;
        }
        for (FilterItem<T> item : currentItems) {
            if (item.objects == null) continue;
            result = this.add(item.objects, result);
        }
        return result;
    }

    protected List<T> processToken(String token, List<FilterItem<T>> currentItems, List<FilterItem<T>> matchedItems, List<T> result) {
        for (FilterItem<T> item : currentItems) {
            FilterItem childItem;
            List wildcardedChildItems;
            List sharpedChildItems;
            HashMap addedChilds;
            if (item.sharpChild != null) {
                result = this.add(item.sharpChild.objects, result);
            }
            if (item.wildcardChild != null) {
                matchedItems.add(item.wildcardChild);
            }
            if (item.negatedSharpedChilds != null && (addedChilds = item.negatedSharpedChilds.getNegated(token)) != null) {
                Iterator iterator = addedChilds.iterator();
                while (iterator.hasNext()) {
                    FilterItem addedChild = iterator.next();
                    result = this.add(addedChild.objects, result);
                }
            }
            if (item.negatedWildcardedChilds != null && (addedChilds = item.negatedWildcardedChilds.getNegated(token)) != null) {
                matchedItems.addAll((Collection<FilterItem<T>>)((Object)addedChilds));
            }
            if (item.negatedSimpleChilds != null) {
                addedChilds = item.negatedSimpleChilds;
                if (item.negatedSimpleChilds.containsKey(token)) {
                    addedChilds = new HashMap(item.negatedSimpleChilds);
                    addedChilds.remove(token);
                }
                matchedItems.addAll(addedChilds.values());
            }
            if (item.sharpedChilds != null && (sharpedChildItems = item.sharpedChilds.get(token)) != null) {
                for (FilterItem sharpedChild : sharpedChildItems) {
                    result = this.add(sharpedChild.objects, result);
                }
            }
            if (item.wildcardedChilds != null && (wildcardedChildItems = item.wildcardedChilds.get(token)) != null) {
                matchedItems.addAll(wildcardedChildItems);
            }
            if (item.simpleChilds == null || (childItem = item.simpleChilds.get(token)) == null) continue;
            matchedItems.add(childItem);
        }
        return result;
    }

    protected List<T> add(List<T> objects, List<T> result) {
        if (result == null) {
            result = new ArrayList<T>();
        }
        result.addAll(objects);
        return result;
    }

    protected boolean containsComplex(List<String> tokens, List<FilterItem<T>> currentItems, int tokenIndex) {
        boolean status = true;
        if (tokenIndex < tokens.size()) {
            ArrayList<FilterItem<T>> matchedItems = new ArrayList<FilterItem<T>>();
            String token = tokens.get(tokenIndex++);
            for (FilterItem<T> item : currentItems) {
                FilterItem childItem;
                List wildcardedChildItems;
                List sharpedChildItems;
                HashMap addedChilds;
                if (item.sharpChild != null) {
                    return true;
                }
                if (item.wildcardChild != null) {
                    matchedItems.add(item.wildcardChild);
                }
                if (item.negatedSharpedChilds != null && (addedChilds = item.negatedSharpedChilds.getNegated(token)) != null) {
                    return true;
                }
                if (item.negatedWildcardedChilds != null && (addedChilds = item.negatedWildcardedChilds.getNegated(token)) != null) {
                    matchedItems.addAll((Collection<FilterItem<T>>)((Object)addedChilds));
                }
                if (item.negatedSimpleChilds != null) {
                    addedChilds = item.negatedSimpleChilds;
                    if (item.negatedSimpleChilds.containsKey(token)) {
                        addedChilds = new HashMap(item.negatedSimpleChilds);
                        addedChilds.remove(token);
                    }
                    matchedItems.addAll(addedChilds.values());
                }
                if (item.sharpedChilds != null && (sharpedChildItems = item.sharpedChilds.get(token)) != null) {
                    return true;
                }
                if (item.wildcardedChilds != null && (wildcardedChildItems = item.wildcardedChilds.get(token)) != null) {
                    matchedItems.addAll(wildcardedChildItems);
                }
                if (item.simpleChilds == null || (childItem = item.simpleChilds.get(token)) == null) continue;
                matchedItems.add(childItem);
            }
            if (matchedItems.isEmpty()) {
                return false;
            }
            status = this.containsComplex(tokens, matchedItems, tokenIndex);
        }
        if (status) {
            for (FilterItem<T> item : currentItems) {
                if (item.objects == null) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean containsFilterComplex(List<FilterToken> tokens) {
        FilterItem<T> currentItem = this.complexFiltersRoot;
        for (FilterToken token : tokens) {
            if (token.isSharp) {
                if (currentItem.sharpChild != null) {
                    return true;
                }
            } else if (token.isWildcard) {
                if (currentItem.wildcardChild != null) {
                    currentItem = currentItem.wildcardChild;
                    continue;
                }
            } else if (token.isNegated) {
                if (token.hasSharp) {
                    if (currentItem.negatedSharpedChilds != null && currentItem.negatedSharpedChilds.containsKey(token.name)) {
                        currentItem = currentItem.negatedSharpedChilds.getByKey(token.name);
                        continue;
                    }
                } else if (token.hasWildcard) {
                    if (currentItem.negatedWildcardedChilds != null && currentItem.negatedWildcardedChilds.containsKey(token.name)) {
                        currentItem = currentItem.negatedWildcardedChilds.getByKey(token.name);
                        continue;
                    }
                } else if (currentItem.negatedSimpleChilds != null && currentItem.negatedSimpleChilds.containsKey(token.name)) {
                    currentItem = currentItem.negatedSimpleChilds.get(token.name);
                    continue;
                }
            } else if (token.hasSharp) {
                if (currentItem.sharpedChilds == null) {
                    currentItem = currentItem.sharpedChilds.getByKey(token.name);
                    continue;
                }
            } else if (token.hasWildcard) {
                if (currentItem.wildcardedChilds != null && currentItem.wildcardedChilds.containsKey(token.name)) {
                    currentItem = currentItem.wildcardedChilds.getByKey(token.name);
                    continue;
                }
            } else if (currentItem.simpleChilds != null && currentItem.simpleChilds.containsKey(token.name)) {
                currentItem = currentItem.simpleChilds.get(token.name);
                continue;
            }
            return false;
        }
        return currentItem.objects != null;
    }

    protected static void checkNull(String filter) throws FilterFormatException {
        if (filter == null) {
            FilterUtils.throwFilterFormatException(filter);
        }
    }

    private static class FilterItem<T> {
        FilterItem<T> sharpChild = null;
        FilterItem<T> wildcardChild = null;
        WildcardMap<FilterItem<T>> negatedSharpedChilds = null;
        WildcardMap<FilterItem<T>> negatedWildcardedChilds = null;
        Map<String, FilterItem<T>> negatedSimpleChilds = null;
        WildcardMap<FilterItem<T>> sharpedChilds = null;
        WildcardMap<FilterItem<T>> wildcardedChilds = null;
        Map<String, FilterItem<T>> simpleChilds = null;
        List<T> objects = null;

        private FilterItem() {
        }

        boolean hasChildItems() {
            return this.sharpChild != null || this.wildcardChild != null || this.negatedSharpedChilds != null || this.negatedWildcardedChilds != null || this.negatedSimpleChilds != null || this.sharpedChilds != null || this.wildcardedChilds != null || this.simpleChilds != null;
        }

        boolean isEmpty() {
            return this.objects == null && !this.hasChildItems();
        }
    }
}

