/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.filter;

import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.filter.FilterUtils;
import java.util.ArrayList;
import java.util.List;

public class CompositeFilter {
    List<Filter> filters;
    String stringForm;

    public CompositeFilter(String from) throws FilterFormatException {
        this(from, true);
    }

    public CompositeFilter(String from, boolean initStringForm) throws FilterFormatException {
        this.filters = FilterUtils.splitIntoFilters(from);
        if (initStringForm) {
            this.initStringForm();
        }
    }

    public CompositeFilter(Filter filter) {
        this.filters = new ArrayList<Filter>();
        this.filters.add(filter);
        this.stringForm = filter.stringForm;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public boolean hasMetacharacters() {
        return this.filters.stream().anyMatch(Filter::hasMetacharacters);
    }

    public boolean isSimple() {
        return this.filters.size() == 1;
    }

    public String toString() {
        return this.stringForm;
    }

    private void initStringForm() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Filter filter : this.filters) {
            if (i++ > 0) {
                builder.append("&");
            }
            builder.append(filter.stringForm);
        }
        this.stringForm = builder.toString();
    }
}

