/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.FileDescriptorRecord;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class RecordSubTypeGroupDefinition
extends FileDescriptorRecord {
    private int subKeyFieldStart = 0;
    private int subKeyFieldEnd = 0;
    private List<FileDescriptorRecord> subRecords = new ArrayList<FileDescriptorRecord>();

    public int getSubKeyFieldStart() {
        return this.subKeyFieldStart;
    }

    public void setSubKeyFieldStart(int subKeyFieldStart) {
        this.subKeyFieldStart = subKeyFieldStart;
    }

    public int getSubKeyFieldEnd() {
        return this.subKeyFieldEnd;
    }

    public void setSubKeyFieldEnd(int subKeyFieldEnd) {
        this.subKeyFieldEnd = subKeyFieldEnd;
    }

    public List<FileDescriptorRecord> getSubTypeRecords() {
        return this.subRecords;
    }

    public void setSubTypeRecords(List<FileDescriptorRecord> subRecords) {
        HashSet<String> keys = new HashSet<String>();
        for (FileDescriptorRecord record : subRecords) {
            if (keys.add(record.getTypeKey())) continue;
            throw new IllegalArgumentException("Sub type record list contain duplicate records for type key '" + record.getTypeKey() + "'.");
        }
        this.subRecords = subRecords;
    }

    public void addSubTypeRecord(FileDescriptorRecord record) {
        this.checkSubTypeRecordExistance(record);
        this.subRecords.add(record);
    }

    public void addSubTypeRecord(int index, FileDescriptorRecord record) {
        this.checkSubTypeRecordExistance(record);
        this.subRecords.add(index, record);
    }

    private void checkSubTypeRecordExistance(FileDescriptorRecord record) {
        for (FileDescriptorRecord temp : this.subRecords) {
            if (!Objects.equals(temp.getTypeKey(), record.getTypeKey())) continue;
            throw new IllegalArgumentException("File descriptor already contain record for type key '" + record.getTypeKey() + "'.");
        }
    }

    public void removeSubTypeRecord(int index) {
        this.subRecords.remove(index);
    }

    public void removeSubTypeRecord(String typeCode) {
        Iterator<FileDescriptorRecord> it = this.subRecords.iterator();
        while (it.hasNext()) {
            if (!Objects.equals(it.next().getTypeKey(), typeCode)) continue;
            it.remove();
            break;
        }
    }

    public FileDescriptorRecord getSubTypeRecord(String subRecordKey) {
        return this.subRecords.stream().filter(r -> r.getTypeKey().equals(subRecordKey)).findFirst().orElse(null);
    }

    public FileDescriptorRecord getMatchedSubTypeRecord(String recordKey) {
        return this.subRecords.stream().filter(r -> r.getKeyPattern().matcher(recordKey).matches()).findFirst().orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordSubTypeGroupDefinition)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RecordSubTypeGroupDefinition that = (RecordSubTypeGroupDefinition)o;
        return this.subKeyFieldStart == that.subKeyFieldStart && this.subKeyFieldEnd == that.subKeyFieldEnd && Objects.equals(this.subRecords, that.subRecords);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subKeyFieldStart, this.subKeyFieldEnd, this.subRecords);
    }
}

