/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.Formatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class RecordField {
    private String fieldName = "";
    private String description = "";
    private String converterName = "";
    private String format = "";
    private int start;
    private int end;
    private String[] spaths;
    private String dataType;
    private String defaultValue;
    private Boolean autotrimWhitespaces = null;
    private Boolean nullable = true;
    private String nullIndicator = null;
    private transient Formatter<?> formatter;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getConverterName() {
        return this.converterName;
    }

    public void setConverterName(String converterName) {
        this.converterName = converterName;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String[] getSpaths() {
        return this.spaths;
    }

    public String getSpathsString() {
        if (this.spaths == null) {
            return "";
        }
        return Arrays.asList(this.getSpaths()).stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
    }

    public void setSpaths(String[] spaths) {
        this.spaths = spaths;
    }

    public void addSpath(String spath) {
        if (this.spaths == null) {
            this.spaths = new String[1];
            this.spaths[0] = spath;
        } else {
            String[] newSpaths = new String[this.spaths.length + 1];
            System.arraycopy(this.spaths, 0, newSpaths, 0, this.spaths.length);
            newSpaths[this.spaths.length] = spath;
            this.spaths = newSpaths;
        }
    }

    public void removeSpath(int index) {
        if (this.spaths == null || this.spaths.length < 1) {
            throw new IllegalArgumentException("Spaths are empty. Nothing to remove.");
        }
        if (index >= this.spaths.length) {
            throw new IllegalArgumentException("Specified index " + index + " out of spaths bounds.");
        }
        String[] newSpaths = new String[this.spaths.length - 1];
        System.arraycopy(this.spaths, 0, newSpaths, 0, index);
        if (index < this.spaths.length) {
            System.arraycopy(this.spaths, index + 1, newSpaths, 0, this.spaths.length - index - 1);
        }
        this.spaths = newSpaths;
    }

    public void removeSpath(String spath) {
        if (this.spaths == null || this.spaths.length < 1) {
            throw new IllegalArgumentException("Spaths are empty. Nothing to remove.");
        }
        for (int i = 0; i < this.spaths.length; ++i) {
            if (!this.spaths[i].equals(spath)) continue;
            this.removeSpath(i);
            break;
        }
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getDataTypeForDescribe() {
        if (this.dataType != null && this.dataType.trim().equalsIgnoreCase("decimal")) {
            return "decimal(128,0)";
        }
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setFormatter(Formatter<?> formatter) {
        this.formatter = formatter;
    }

    public Formatter<?> getFormatter() {
        return this.formatter;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Boolean getAutotrimWhitespaces() {
        return this.autotrimWhitespaces;
    }

    public void setAutotrimWhitespaces(Boolean autotrimWhitespaces) {
        this.autotrimWhitespaces = autotrimWhitespaces;
    }

    public boolean isNullable() {
        return this.nullable == null ? true : this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public String getNullIndicator() {
        return this.nullIndicator;
    }

    public void setNullIndicator(String nullIndicator) {
        this.nullIndicator = nullIndicator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordField)) {
            return false;
        }
        RecordField that = (RecordField)o;
        return this.start == that.start && this.end == that.end && this.autotrimWhitespaces == that.autotrimWhitespaces && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.description, that.description) && Objects.equals(this.converterName, that.converterName) && Objects.equals(this.format, that.format) && Arrays.equals(this.spaths, that.spaths) && Objects.equals(this.dataType, that.dataType) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.nullable, that.nullable) && Objects.equals(this.nullIndicator, that.nullIndicator);
    }

    public int hashCode() {
        int result = Objects.hash(this.fieldName, this.description, this.converterName, this.format, this.start, this.end, this.dataType, this.defaultValue, this.autotrimWhitespaces, this.nullable, this.nullIndicator);
        result = 31 * result + Arrays.hashCode(this.spaths);
        return result;
    }
}

