/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.OneRecordWriter;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.file.RecordSubTypeGroupDefinition;
import com.streamscape.lib.utils.Pair;
import java.math.BigDecimal;
import java.util.List;

class PositionalOneRecordWriter
extends OneRecordWriter {
    PositionalOneRecordWriter(FileDescriptorFactory factory) {
        super(factory);
    }

    @Override
    public String writeRecord(String recordKey, Object recordObject) throws FileDescriptorFactory.FileDescriptorProcessingException {
        FileDescriptorRecord record = this.validateRecordForWrite(recordKey, recordObject);
        StringBuilder builder = new StringBuilder();
        if (this.factory.getFileDescriptor().hasKey()) {
            this.write(builder, recordKey, this.factory.getFileDescriptor().getKeyFieldStart(), this.factory.getFileDescriptor().getKeyFieldEnd());
        }
        this.writeRecord(builder, (AbstractRecordTypeDefinition)record, recordObject);
        return builder.toString();
    }

    @Override
    public String writeGroupRecord(String recordGroupKey, String recordKey, Object recordObject) throws FileDescriptorFactory.FileDescriptorProcessingException {
        Pair<RecordSubTypeGroupDefinition, AbstractRecordTypeDefinition> pair = this.validateGroupRecordForWrite(recordGroupKey, recordKey, recordObject);
        StringBuilder builder = new StringBuilder();
        this.write(builder, recordGroupKey, this.factory.getFileDescriptor().getKeyFieldStart(), this.factory.getFileDescriptor().getKeyFieldEnd());
        this.writeRecord(builder, (AbstractRecordTypeDefinition)pair.second, recordObject);
        return builder.toString();
    }

    private void writeRecord(StringBuilder builder, AbstractRecordTypeDefinition record, Object recordObject) throws FileDescriptorFactory.FileDescriptorProcessingException {
        List<RecordField> fields = record.getSortedFields();
        if (recordObject == null && fields.size() > 0) {
            this.write(builder, null, this.factory.getFileDescriptor().getKeyFieldEnd() + 1, fields.get(fields.size() - 1).getEnd());
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                RecordField field = fields.get(i);
                if (field.getClass() != RecordField.class) {
                    throw new FileDescriptorFactory.FileDescriptorProcessingException("Only simple record type field are allowed for write.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                }
                Object value = this.getFieldValueAndFormat(field, recordObject, i);
                this.write(builder, value, field.getStart(), field.getEnd());
            }
        }
    }

    @Override
    public String writeRecordFields(FileDescriptorRecord record, Object ... recordFields) throws FileDescriptorFactory.FileDescriptorProcessingException {
        StringBuilder builder = new StringBuilder();
        if (this.factory.getFileDescriptor().hasKey()) {
            this.write(builder, record.getTypeKey(), this.factory.getFileDescriptor().getKeyFieldStart(), this.factory.getFileDescriptor().getKeyFieldEnd());
        }
        if (!(record instanceof AbstractRecordTypeDefinition)) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Only record type definitions are allowed for write.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        }
        AbstractRecordTypeDefinition recordDefinition = (AbstractRecordTypeDefinition)record;
        if (recordFields == null && recordDefinition.getFields().size() > 0) {
            List<RecordField> fields = recordDefinition.getSortedFields();
            this.write(builder, null, this.factory.getFileDescriptor().getKeyFieldEnd() + 1, fields.get(fields.size() - 1).getEnd());
        } else {
            if (recordDefinition.getFields().size() != recordFields.length) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Record fields size mistatch. Expected '" + recordDefinition.getFields().size() + "' but passed '" + recordFields.length + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
            for (int i = 0; i < recordDefinition.getFields().size(); ++i) {
                RecordField field = recordDefinition.getFields().get(i);
                if (field.getClass() != RecordField.class) {
                    throw new FileDescriptorFactory.FileDescriptorProcessingException("Only simple record type field are allowed for write.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                }
                Object value = this.formatFieldValue(field, recordFields[i]);
                this.write(builder, value, field.getStart(), field.getEnd());
            }
        }
        return builder.toString();
    }

    private void write(StringBuilder builder, Object value, int startPostion, int endPosition) {
        int valueLength;
        int valueLength1;
        if (value == null) {
            value = "";
        }
        String svalue = "";
        svalue = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : value.toString();
        if (builder.length() < startPostion - 1) {
            while (builder.length() != startPostion - 1) {
                builder.append(' ');
            }
        }
        int n = valueLength1 = svalue.length() > valueLength ? valueLength : svalue.length();
        if (builder.length() == startPostion - 1) {
            builder.append(svalue, 0, valueLength1);
            for (valueLength = endPosition - startPostion + 1; valueLength > svalue.length(); --valueLength) {
                builder.insert(svalue.length() + startPostion++ - 1, ' ');
            }
        } else {
            for (int i = 0; i < valueLength1; ++i) {
                if (startPostion - 1 + i < builder.length()) {
                    builder.setCharAt(startPostion - 1 + i, svalue.charAt(i));
                    continue;
                }
                builder.append(svalue.charAt(i));
            }
            while (builder.length() < endPosition - 1) {
                builder.append(' ');
            }
        }
    }
}

