/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.OneRecordReader;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.file.RecordSubTypeGroupDefinition;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.file.SubRecordField;
import com.streamscape.lib.utils.Pair;
import java.util.HashSet;
import java.util.regex.Matcher;

public class PositionalOneRecordReader
extends OneRecordReader {
    private HashSet<String> observableRecordTypes;
    private Pair<Object, AbstractRecordTypeDefinition> currentGroupRecord;

    PositionalOneRecordReader(FileDescriptorFactory factory) {
        super(factory);
        this.observableRecordTypes = factory.getObservableRecordTypes();
    }

    @Override
    protected Pair<Object, AbstractRecordTypeDefinition> doReadRecord(String recordLine) throws FileDescriptorFactory.FileDescriptorProcessingException {
        String key = this.readKey(recordLine);
        if (this.observableRecordTypes != null && this.observableRecordTypes.size() > 0 && !this.observableRecordTypes.contains(key)) {
            return new Pair<Object, Object>(null, null);
        }
        FileDescriptorRecord record = this.factory.getRecordDefinition(key, FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.SKIPPED);
        if (this.fileDescriptor.hasKey() && this.fileDescriptor.getRecordGroupKey().equals(key)) {
            if (this.currentGroupRecord != null) {
                this.processGroupRecord(this.currentGroupRecord, "end", key);
            }
            this.currentGroupRecord = this.processRecord(recordLine, record, false);
            this.processGroupRecord(this.currentGroupRecord, "begin", key);
            return this.currentGroupRecord;
        }
        return this.processRecord(recordLine, record, false);
    }

    @Override
    public void startFileProcessing() {
        super.startFileProcessing();
        this.currentGroupRecord = null;
    }

    @Override
    public void endFileProcessing() {
        super.endFileProcessing();
        if (this.currentGroupRecord != null) {
            this.processGroupRecord(this.currentGroupRecord, "end", this.fileDescriptor.getRecordGroupKey());
        }
    }

    @Override
    public String readKey(String recordLine) throws FileDescriptorFactory.FileDescriptorProcessingException {
        if (!this.fileDescriptor.hasKey()) {
            return "";
        }
        if (this.fileDescriptor.getKeyFieldEnd() > recordLine.length()) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Invalid record encountered (record length less than the key end position)", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.SKIPPED);
        }
        return recordLine.substring(this.fileDescriptor.getKeyFieldStart() - 1, this.fileDescriptor.getKeyFieldEnd());
    }

    private Pair<Object, AbstractRecordTypeDefinition> processRecord(String currentRecordString, FileDescriptorRecord record, boolean sub) throws FileDescriptorFactory.FileDescriptorProcessingException {
        if (record instanceof AbstractRecordTypeDefinition) {
            Pair<Object, AbstractRecordTypeDefinition> recordPair = this.processRecordTypeDefinition(currentRecordString, (AbstractRecordTypeDefinition)record, false);
            if (this.recordListener != null) {
                this.recordListener.onRecord(recordPair.first, (AbstractRecordTypeDefinition)recordPair.second);
            }
            return recordPair;
        }
        if (record instanceof RecordSubTypeGroupDefinition) {
            return this.processRecordSubTypeGroupDefinition(currentRecordString, (RecordSubTypeGroupDefinition)record, sub);
        }
        throw new IllegalStateException("Unsupported record type '" + record.getClass().getSimpleName() + "' encountered.");
    }

    private Pair<Object, AbstractRecordTypeDefinition> processRecordTypeDefinition(String currentRecordString, AbstractRecordTypeDefinition record, boolean sub) throws FileDescriptorFactory.FileDescriptorProcessingException {
        Object currentRecord = this.createRecordObject(record);
        for (RecordField field : record.getFields()) {
            int end;
            int start = field.getStart();
            if (start > (end = field.getEnd()) || start < 1 || end > currentRecordString.length()) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Unable to retrieve field '" + field.getFieldName() + "' for the record with key '" + record.getTypeKey() + "'. Field starts at " + start + " ends at " + end + ".", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
            String fieldValue = null;
            if (field instanceof SubRecordField) {
                int subRecordKeyEnd;
                int subRecordKeyStart = ((SubRecordField)field).getKeyFieldStart();
                if (subRecordKeyStart > (subRecordKeyEnd = ((SubRecordField)field).getKeyFieldEnd()) || subRecordKeyStart < 1) {
                    throw new IllegalArgumentException("Invalid subrecord key field positions specified.");
                }
                RecordTypeDefinition subRec = null;
                String subRecKey = currentRecordString.substring(subRecordKeyStart - 1, subRecordKeyEnd);
                for (RecordTypeDefinition entry : ((SubRecordField)field).getSubRecords().values()) {
                    Matcher matcher = entry.getKeyPattern().matcher(subRecKey);
                    if (!matcher.matches()) continue;
                    subRec = entry;
                    break;
                }
                if (subRec == null) continue;
                fieldValue = this.processRecordTypeDefinition((String)currentRecordString, subRec, (boolean)true).first;
            } else {
                fieldValue = currentRecordString.substring(start - 1, end).trim();
                if (fieldValue.trim().length() == 0) {
                    fieldValue = "";
                }
            }
            this.setRecordObjectValueForField(currentRecord, field, fieldValue, record);
        }
        return new Pair<Object, AbstractRecordTypeDefinition>(currentRecord, record);
    }

    private Pair<Object, AbstractRecordTypeDefinition> processRecordSubTypeGroupDefinition(String currentRecordString, RecordSubTypeGroupDefinition record, boolean sub) throws FileDescriptorFactory.FileDescriptorProcessingException {
        int keyEnd;
        int keyStart = record.getSubKeyFieldStart();
        if (keyStart > (keyEnd = record.getSubKeyFieldEnd()) || keyStart < 1) {
            throw new IllegalArgumentException("Invalid key field positions specified.");
        }
        String key = currentRecordString.substring(keyStart - 1, keyEnd);
        FileDescriptorRecord rec = null;
        for (FileDescriptorRecord subRec : record.getSubTypeRecords()) {
            Matcher matcher = subRec.getKeyPattern().matcher(key);
            if (!matcher.matches()) continue;
            rec = subRec;
            break;
        }
        if (rec == null) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Unknown sub type record with key '" + key + "' encountered.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.SKIPPED);
        }
        return this.processRecord(currentRecordString, rec, sub);
    }

    private void processGroupRecord(Pair<Object, AbstractRecordTypeDefinition> record, String type, String key) {
        if (this.recordListener != null) {
            this.recordListener.onGroupRecord(record.first, type, key);
        }
    }
}

