/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.file.RecordSubTypeGroupDefinition;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.file.UntypedRecordTypeDefinition;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.sdrpath.ReferencePathException;
import java.util.List;

public abstract class OneRecordWriter {
    protected FileDescriptorFactory factory;

    OneRecordWriter(FileDescriptorFactory factory) {
        this.factory = factory;
    }

    protected FileDescriptorRecord validateRecordForWrite(String recordKey, Object recordObject) throws FileDescriptorFactory.FileDescriptorProcessingException {
        FileDescriptorRecord record = this.factory.getRecordDefinition(recordKey, FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        if (!(record instanceof AbstractRecordTypeDefinition)) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Record type definition with key '" + recordKey + "' not found.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        }
        this.validateRecord(record, recordObject);
        return record;
    }

    protected Pair<RecordSubTypeGroupDefinition, AbstractRecordTypeDefinition> validateGroupRecordForWrite(String groupRecordKey, String recordKey, Object recordObject) throws FileDescriptorFactory.FileDescriptorProcessingException {
        FileDescriptorRecord record = this.factory.getRecordDefinition(groupRecordKey, FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        if (!(record instanceof RecordSubTypeGroupDefinition)) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Group record with key '" + groupRecordKey + "' not found.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        }
        RecordSubTypeGroupDefinition recordSubTypeGroupDefinition = (RecordSubTypeGroupDefinition)record;
        if ((record = recordSubTypeGroupDefinition.getSubTypeRecord(recordKey)) == null) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Unknown sub record with key '" + recordKey + "' specified.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        }
        if (!(record instanceof AbstractRecordTypeDefinition)) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Only subrecords of record type are allowed for write.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        }
        this.validateRecord(record, recordObject);
        return new Pair<RecordSubTypeGroupDefinition, AbstractRecordTypeDefinition>(recordSubTypeGroupDefinition, (AbstractRecordTypeDefinition)record);
    }

    private void validateRecord(FileDescriptorRecord record, Object recordObject) throws FileDescriptorFactory.FileDescriptorProcessingException {
        if (record instanceof RecordTypeDefinition) {
            RecordTypeDefinition recordDefinition = (RecordTypeDefinition)record;
            if (recordObject != null) {
                SemanticType semanticType = this.factory.getTypeCache().lookupSemanticClass(recordObject.getClass().getName());
                if (semanticType == null) {
                    throw new FileDescriptorFactory.FileDescriptorProcessingException("Semantic type corresponding to record object now found.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                }
                if (!semanticType.getTypeName().equals(recordDefinition.getSemanticType())) {
                    throw new FileDescriptorFactory.FileDescriptorProcessingException("Record object type '" + semanticType.getClassName() + "' doesn't correspond to record type '" + recordDefinition.getSemanticType() + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                }
            }
        } else if (record instanceof UntypedRecordTypeDefinition) {
            if (!(recordObject instanceof List)) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Record object should be of type List for record type '" + record.getTypeName() + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
            if (((List)recordObject).size() != ((UntypedRecordTypeDefinition)record).getFields().size()) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Record object size and fields count mismatch. Should be '" + ((UntypedRecordTypeDefinition)record).getFields().size() + "', but passed '" + ((List)recordObject).size() + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
        }
    }

    public abstract String writeRecord(String var1, Object var2) throws FileDescriptorFactory.FileDescriptorProcessingException;

    public abstract String writeGroupRecord(String var1, String var2, Object var3) throws FileDescriptorFactory.FileDescriptorProcessingException;

    public String writeRecordFields(String recordKey, Object ... recordFields) throws FileDescriptorFactory.FileDescriptorProcessingException {
        return this.writeRecordFields(this.factory.getRecordDefinition(recordKey, FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED), recordFields);
    }

    public abstract String writeRecordFields(FileDescriptorRecord var1, Object ... var2) throws FileDescriptorFactory.FileDescriptorProcessingException;

    protected Object getFieldValue(RecordField field, Object recordObject, int index) {
        return OneRecordWriter.getFieldValue(this.factory, field, recordObject, index);
    }

    public static Object getFieldValue(FileDescriptorFactory factory, RecordField field, Object recordObject, int index) {
        Object value = null;
        if (recordObject != null && field.getSpaths() != null && field.getSpaths().length > 0) {
            try {
                value = factory.getSdrManager().getValueAtPath(field.getSpaths()[0], recordObject);
            }
            catch (ReferencePathException e) {
                value = null;
            }
        } else if (field.getDataType() != null && recordObject instanceof List) {
            return ((List)recordObject).get(index);
        }
        return value;
    }

    protected Object formatFieldValue(RecordField field, Object value) {
        if (field.getFormatter() != null) {
            value = field.getFormatter().format(value);
        }
        return value;
    }

    protected Object getFieldValueAndFormat(RecordField field, Object recordObject, int index) {
        return this.formatFieldValue(field, this.getFieldValue(field, recordObject, index));
    }
}

