/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.file.UntypedRecordTypeDefinition;
import com.streamscape.lib.reflection.ReflectionProvider;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.SemanticType;
import java.util.ArrayList;
import java.util.List;

public abstract class OneRecordReader {
    private int recordCounter = 0;
    private int skippedCounter = 0;
    private int rejectedCounter = 0;
    protected FileDescriptorFactory.RecordListener recordListener;
    protected FileDescriptorFactory factory;
    protected FileDescriptor fileDescriptor;

    OneRecordReader(FileDescriptorFactory factory) {
        this.resetCounters();
        this.recordListener = factory.getRecordListener();
        this.fileDescriptor = factory.getFileDescriptor();
        this.factory = factory;
    }

    public void setRecordListener(FileDescriptorFactory.RecordListener recordListener) {
        this.recordListener = recordListener;
    }

    protected void resetCounters() {
        this.recordCounter = 0;
        this.skippedCounter = 0;
        this.rejectedCounter = 0;
    }

    public int getRecordCounter() {
        return this.recordCounter;
    }

    public int getSkippedCounter() {
        return this.skippedCounter;
    }

    public int getRejectedCounter() {
        return this.rejectedCounter;
    }

    public void startFileProcessing() {
        this.resetCounters();
    }

    public Pair<Object, AbstractRecordTypeDefinition> readRecord(String recordLine) throws FileDescriptorFactory.FileDescriptorProcessingException {
        ++this.recordCounter;
        if (recordLine.length() == 0) {
            return new Pair<Object, Object>(null, null);
        }
        try {
            return this.doReadRecord(recordLine);
        }
        catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
            exception.setRecordNumber(this.recordCounter);
            exception.setRecordLine(recordLine);
            if (exception.getAction() == FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED) {
                ++this.rejectedCounter;
            } else if (exception.getAction() == FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.SKIPPED) {
                ++this.skippedCounter;
            }
            throw exception;
        }
    }

    protected abstract Pair<Object, AbstractRecordTypeDefinition> doReadRecord(String var1) throws FileDescriptorFactory.FileDescriptorProcessingException;

    public void endFileProcessing() {
    }

    protected Object createRecordObject(AbstractRecordTypeDefinition record) throws FileDescriptorFactory.FileDescriptorProcessingException {
        if (record instanceof RecordTypeDefinition) {
            String semanticTypeName = ((RecordTypeDefinition)record).getSemanticType();
            SemanticType semanticType = this.factory.getTypeCache().lookupSemanticType(semanticTypeName);
            if (semanticType == null) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Semantic type '" + semanticTypeName + "' for record '" + record.getTypeKey() + "' doesn't exist.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
            Class<?> objectClass = null;
            try {
                objectClass = this.factory.getClassLoader().loadClass(semanticType.getClassName());
            }
            catch (Exception exception) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Unable to load class for semantic type '" + semanticTypeName + "' for record '" + record.getTypeKey() + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
            Object recordObject = null;
            try {
                recordObject = ReflectionProvider.getInstance().newInstance(objectClass);
            }
            catch (Exception exception) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Unable to instantiate object for semantic type '" + semanticTypeName + "' for record '" + record.getTypeKey() + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
            return recordObject;
        }
        if (record instanceof UntypedRecordTypeDefinition) {
            return new ArrayList();
        }
        throw new FileDescriptorFactory.FileDescriptorProcessingException("Unsupported record type definition class " + String.valueOf(record.getClass()), FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
    }

    protected void setRecordObjectValueForField(Object recordObject, RecordField field, Object value, AbstractRecordTypeDefinition record) throws FileDescriptorFactory.FileDescriptorProcessingException {
        if (record instanceof RecordTypeDefinition) {
            for (String spath : field.getSpaths()) {
                value = this.formatField(field, value, record);
                try {
                    this.factory.getSdrManager().setValueAtPath(spath, recordObject, value, true);
                }
                catch (Exception error) {
                    throw new FileDescriptorFactory.FileDescriptorProcessingException("Unable to set field '" + field.getFieldName() + "' for the record with key '" + record.getTypeKey() + "'. " + error.getMessage() + ".", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                }
            }
        } else if (record instanceof UntypedRecordTypeDefinition) {
            value = this.formatField(field, value, record);
            ((List)recordObject).add(value);
        } else {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Unsupported record type definition class " + String.valueOf(record.getClass()), FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        }
    }

    private Object formatField(RecordField field, Object value, AbstractRecordTypeDefinition record) throws FileDescriptorFactory.FileDescriptorProcessingException {
        try {
            String nullIndicator = this.fileDescriptor.getNullIndicator();
            if (field.getNullIndicator() != null) {
                nullIndicator = field.getNullIndicator();
            }
            if (value != null && nullIndicator != null && nullIndicator.length() > 0 && value.equals(nullIndicator)) {
                if (!field.isNullable()) {
                    throw new FileDescriptorFactory.FileDescriptorProcessingException("Null value '" + String.valueOf(value) + "' is passed for not nullable field '" + field.getFieldName() + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                }
                value = null;
            }
            if ((value == null || value instanceof String && ((String)value).length() == 0) && field.getDefaultValue() != null && field.getDefaultValue().length() > 0) {
                value = field.getDefaultValue();
            }
            if (field.getFormatter() != null) {
                value = field.getFormatter().parse(value);
            }
        }
        catch (Exception error) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Unable to format field '" + field.getFieldName() + "' for the record with key '" + record.getTypeKey() + "'. " + error.getMessage() + ".", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        }
        return value;
    }

    public String readKey(String recordLine) throws FileDescriptorFactory.FileDescriptorProcessingException {
        return null;
    }
}

