/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.Formatter;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class FormatterFactory {
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private String sqlTimeFormat = "HH:mm:ss";
    private String sqlDateFormat = "yyyy-MM-dd";
    private String sqlTimestampFormat = "yyyy-MM-dd HH:mm:ss.SSS";

    public String getDateFormat() {
        return this.dateFormat;
    }

    public FormatterFactory setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public String getSqlTimeFormat() {
        return this.sqlTimeFormat;
    }

    public FormatterFactory setSqlTimeFormat(String sqlTimeFormat) {
        this.sqlTimeFormat = sqlTimeFormat;
        return this;
    }

    public String getSqlDateFormat() {
        return this.sqlDateFormat;
    }

    public FormatterFactory setSqlDateFormat(String sqlDateFormat) {
        this.sqlDateFormat = sqlDateFormat;
        return this;
    }

    public String getSqlTimestampFormat() {
        return this.sqlTimestampFormat;
    }

    public FormatterFactory setSqlTimestampFormat(String sqlTimestampFormat) {
        this.sqlTimestampFormat = sqlTimestampFormat;
        return this;
    }

    private <T> Formatter<T> formatter(Class<?> type, String dataspaceType, String format) {
        if (type == Date.class) {
            return new Formatter.DateFormatter(format);
        }
        if (type == java.sql.Date.class) {
            return new Formatter.SqlDateFormatter(format);
        }
        if (type == Timestamp.class) {
            return new Formatter.SqlTimestampFormatter(format);
        }
        if (type == Time.class) {
            return new Formatter.SqlTimeFormatter(format);
        }
        if (type == BigDecimal.class) {
            return new Formatter.BigDecimalFormatter(format, dataspaceType);
        }
        throw new IllegalArgumentException("Formatter for type '" + type.getName() + "' not supported.");
    }

    private Formatter<?> formatter(String dataspaceType, String format) {
        return this.formatter(this.dataspaceTypeToClass(dataspaceType), dataspaceType, format);
    }

    private <T> Formatter<T> defaultFormatter(Class<?> type, String dataspaceType) {
        if (type == Date.class) {
            return new Formatter.DateFormatter(this.dateFormat);
        }
        if (type == Time.class) {
            return new Formatter.SqlTimeFormatter(this.sqlTimeFormat);
        }
        if (type == java.sql.Date.class) {
            return new Formatter.SqlDateFormatter(this.sqlDateFormat);
        }
        if (type == Timestamp.class) {
            return new Formatter.SqlTimestampFormatter(this.sqlTimestampFormat);
        }
        if (type == BigDecimal.class) {
            return new Formatter.BigDecimalFormatter(null, dataspaceType);
        }
        return null;
    }

    private Formatter<?> defaultFormatter(String dataspaceType) {
        return this.defaultFormatter(this.dataspaceTypeToClass(dataspaceType), dataspaceType);
    }

    public <T> Formatter<T> formatterOrDefault(Class<T> type, String dataspaceType, String format) {
        if (format != null && format.length() > 0) {
            return this.formatter(type, dataspaceType, format);
        }
        return this.defaultFormatter(type, dataspaceType);
    }

    public Formatter<?> formatterOrDefault(String dataspaceType, String format) {
        if (format != null && format.length() > 0) {
            return this.formatter(this.dataspaceTypeToClass(dataspaceType), dataspaceType, format);
        }
        return this.defaultFormatter(this.dataspaceTypeToClass(dataspaceType), dataspaceType);
    }

    private Class<?> dataspaceTypeToClass(String dataspaceType) {
        Class clazz = null;
        if (dataspaceType.toLowerCase().startsWith("date")) {
            clazz = Date.class;
        } else if (dataspaceType.toLowerCase().startsWith("sqltimestamp")) {
            clazz = Timestamp.class;
        } else if (dataspaceType.toLowerCase().startsWith("sqldate")) {
            clazz = java.sql.Date.class;
        } else if (dataspaceType.toLowerCase().startsWith("sqltime")) {
            clazz = Time.class;
        } else if (dataspaceType.toLowerCase().startsWith("decimal")) {
            clazz = BigDecimal.class;
        }
        return clazz;
    }
}

