/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.java.JavaSystem;
import com.streamscape.lib.file.FormatterException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Formatter<T> {
    public abstract T parse(Object var1) throws FormatterException;

    public abstract String format(Object var1);

    public static class BigDecimalFormatter
    extends Formatter<BigDecimal> {
        static final Pattern decimalFormatPattern = Pattern.compile("\\((\\d+)\\s*,\\s*(\\d+)\\)");
        private String format;
        private String dataspaceType;
        private int precision;
        private int scale;

        BigDecimalFormatter(String format, String dataspaceType) {
            this.format = format;
            this.dataspaceType = dataspaceType;
            this.initPrecisionScale();
        }

        private void initPrecisionScale() {
            Matcher matcher;
            this.precision = -1;
            this.scale = -1;
            if (this.dataspaceType != null && (matcher = decimalFormatPattern.matcher(this.dataspaceType)).find()) {
                this.precision = Integer.valueOf(matcher.group(1));
                this.scale = Integer.valueOf(matcher.group(2));
            }
            if (this.format != null && this.format.length() > 0 && (matcher = decimalFormatPattern.matcher(this.format)).find()) {
                this.precision = Integer.valueOf(matcher.group(1));
                this.scale = Integer.valueOf(matcher.group(2));
            }
        }

        @Override
        public BigDecimal parse(Object value) throws FormatterException {
            if (value == null) {
                return null;
            }
            if (value.getClass() == BigDecimal.class) {
                return this.convertToTypeLimits((BigDecimal)value);
            }
            String svalue = value.toString().trim();
            if (svalue.length() == 0) {
                return null;
            }
            return this.convertToTypeLimits(new BigDecimal(svalue));
        }

        @Override
        public String format(Object value) {
            if (value instanceof BigDecimal) {
                return this.convertToTypeLimits((BigDecimal)value).toString();
            }
            return null;
        }

        BigDecimal convertToTypeLimits(BigDecimal value) throws FormatterException {
            int p;
            if (this.scale == -1 || this.precision == -1) {
                return value;
            }
            if (this.scale != value.scale()) {
                value = value.setScale(this.scale, 5);
            }
            if ((p = JavaSystem.precision(value)) > this.precision) {
                throw new FormatterException("Value " + String.valueOf(value) + " cannot fit to precision scale (" + this.precision + "," + this.scale + ")");
            }
            return value;
        }
    }

    public static class SqlTimestampFormatter
    extends AbstractDateFormatter<Timestamp> {
        SqlTimestampFormatter(String format) {
            super(format, java.util.Date.class);
        }

        @Override
        public Timestamp doParse(String value) throws FormatterException {
            try {
                return new Timestamp(this.simpleDateFormat.parse(value).getTime());
            }
            catch (ParseException exception) {
                throw new FormatterException("Failed to parse value '" + value.toString() + "' to java.sql.Timestamp in format '" + this.format + "'. Cause: " + exception.getMessage());
            }
        }

        @Override
        public Timestamp doParseFromLong(long value) throws FormatterException {
            return new Timestamp(value);
        }
    }

    public static class SqlTimeFormatter
    extends AbstractDateFormatter<Time> {
        SqlTimeFormatter(String format) {
            super(format, java.util.Date.class);
        }

        @Override
        public Time doParse(String value) throws FormatterException {
            try {
                return new Time(this.simpleDateFormat.parse(value).getTime());
            }
            catch (ParseException exception) {
                throw new FormatterException("Failed to parse value '" + value.toString() + "' to java.sql.Time in format '" + this.format + "'. Cause: " + exception.getMessage());
            }
        }

        @Override
        public Time doParseFromLong(long value) throws FormatterException {
            return new Time(value);
        }
    }

    public static class SqlDateFormatter
    extends AbstractDateFormatter<Date> {
        SqlDateFormatter(String format) {
            super(format, java.util.Date.class);
        }

        @Override
        public Date doParse(String value) throws FormatterException {
            try {
                return new Date(this.simpleDateFormat.parse(value).getTime());
            }
            catch (ParseException exception) {
                throw new FormatterException("Failed to parse value '" + value.toString() + "' to java.sql.Date in format '" + this.format + "'. Cause: " + exception.getMessage());
            }
        }

        @Override
        public Date doParseFromLong(long value) throws FormatterException {
            return new Date(value);
        }
    }

    public static class DateFormatter
    extends AbstractDateFormatter<java.util.Date> {
        DateFormatter(String format) {
            super(format, java.util.Date.class);
        }

        @Override
        public java.util.Date doParse(String value) throws FormatterException {
            try {
                return this.simpleDateFormat.parse(value);
            }
            catch (ParseException exception) {
                throw new FormatterException("Failed to parse value '" + value.toString() + "' to java.util.Date in format '" + this.format + "'. Cause: " + exception.getMessage());
            }
        }

        @Override
        public java.util.Date doParseFromLong(long value) throws FormatterException {
            return new java.util.Date(value);
        }
    }

    public static abstract class AbstractDateFormatter<T>
    extends Formatter<T> {
        protected SimpleDateFormat simpleDateFormat;
        protected String format;
        protected Class<?> clazz;

        public static SimpleDateFormat getSimpleDateFormat(String format) {
            SimpleDateFormat result = new SimpleDateFormat(format, DataspaceDateTime.defaultLocale);
            result.setTimeZone(DataspaceDateTime.getTimezone());
            return result;
        }

        private AbstractDateFormatter(String format, Class<?> clazz) {
            this.format = format;
            this.clazz = clazz;
            if (!format.equalsIgnoreCase("long")) {
                this.simpleDateFormat = AbstractDateFormatter.getSimpleDateFormat(format);
            }
        }

        @Override
        public T parse(Object value) throws FormatterException {
            String svalue;
            if (value == null) {
                return null;
            }
            if (value.getClass() == this.clazz) {
                return (T)value;
            }
            if (value instanceof java.util.Date) {
                value = this.simpleDateFormat != null ? this.simpleDateFormat.format((java.util.Date)value) : Long.valueOf(((java.util.Date)value).getTime());
            }
            if ((svalue = value.toString().trim()).length() == 0) {
                return null;
            }
            if (this.simpleDateFormat != null) {
                return this.doParse(svalue);
            }
            long lvalue = 0L;
            try {
                lvalue = Long.parseLong(svalue);
            }
            catch (Exception exception) {
                throw new FormatterException("Failed to parse value '" + value.toString() + "' to long.");
            }
            return this.doParseFromLong(lvalue);
        }

        protected abstract T doParse(String var1) throws FormatterException;

        protected abstract T doParseFromLong(long var1) throws FormatterException;

        @Override
        public String format(Object value) {
            if (value == null) {
                return null;
            }
            if (this.simpleDateFormat != null) {
                return this.simpleDateFormat.format(value);
            }
            return String.valueOf(((java.util.Date)value).getTime());
        }
    }
}

