/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.FileDescriptorFactory;
import java.io.IOException;
import java.io.Writer;

public class FileRecordsWriter {
    private Writer writer;
    private String lineSeparator = "\n";
    private FileDescriptorFactory factory;

    FileRecordsWriter(FileDescriptorFactory factory, Writer writer) {
        this.writer = writer;
        this.factory = factory;
        if (factory.getFileDescriptor().getLinesDelimiter() != null && factory.getFileDescriptor().getLinesDelimiter().length() > 0) {
            this.setLineSeparator(factory.getFileDescriptor().getUnescapedLinesDelimiter());
        }
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void writeRecord(String recordKey, Object recordObject) throws IOException, FileDescriptorFactory.FileDescriptorProcessingException {
        this.writer.append(this.factory.createOneRecordWriter().writeRecord(recordKey, recordObject)).append(this.lineSeparator);
    }

    public void writeGroupRecord(String groupRecordKey, String recordKey, Object recordObject) throws IOException, FileDescriptorFactory.FileDescriptorProcessingException {
        this.writer.append(this.factory.createOneRecordWriter().writeGroupRecord(groupRecordKey, recordKey, recordObject)).append(this.lineSeparator);
    }

    public void writeRecordFields(String recordKey, Object ... recordFields) throws IOException, FileDescriptorFactory.FileDescriptorProcessingException {
        this.writer.append(this.factory.createOneRecordWriter().writeRecordFields(recordKey, recordFields)).append(this.lineSeparator);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }
}

