/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.FileLinesReader;
import com.streamscape.lib.file.OneRecordReader;
import java.io.IOException;

public class FileRecordsReader {
    private long recordLimit = 0L;
    private OneRecordReader oneRecordReader;
    private FileDescriptorFactory.FileDescriptorProcessorExceptionStrategy exceptionStrategy;
    private FileDescriptorFactory.RecordListener recordListener;
    private FileDescriptor fileDescriptor;
    private Logger logger;
    private boolean isRecordLimitReached;
    private int skippedLinesCount = 0;
    private int totalLinesCounter = 0;
    private int totalRecordsCounter = 0;

    FileRecordsReader(FileDescriptorFactory factory) {
        this.recordListener = factory.getRecordListener();
        this.fileDescriptor = factory.getFileDescriptor();
        this.oneRecordReader = factory.createOneRecordReader();
        this.logger = factory.getLogger();
    }

    public void setRecordLimit(long recordLimit) {
        this.recordLimit = recordLimit;
    }

    public boolean isRecordLimitReached() {
        return this.isRecordLimitReached;
    }

    public void setExceptionStrategy(FileDescriptorFactory.FileDescriptorProcessorExceptionStrategy exceptionStrategy) {
        this.exceptionStrategy = exceptionStrategy;
    }

    public void setRecordListener(FileDescriptorFactory.RecordListener recordListener) {
        this.recordListener = recordListener;
    }

    public int getRecordCounter() {
        return this.oneRecordReader.getRecordCounter();
    }

    public int getSkippedCounter() {
        return this.oneRecordReader.getSkippedCounter();
    }

    public int getRejectedCounter() {
        return this.oneRecordReader.getRejectedCounter();
    }

    public void readSingleFile(FileLinesReader reader) throws IOException, FileDescriptorFactory.FileDescriptorProcessingException {
        this.oneRecordReader.startFileProcessing();
        this.isRecordLimitReached = false;
        this.totalLinesCounter = 0;
        this.totalRecordsCounter = 0;
        this.doReadFile(reader, true, false);
        this.oneRecordReader.endFileProcessing();
    }

    public void readStreamedFile(FileLinesReader reader, boolean skipLines, boolean skipFirstTimeOnly) throws IOException, FileDescriptorFactory.FileDescriptorProcessingException {
        this.doReadFile(reader, skipLines, skipFirstTimeOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadFile(FileLinesReader reader, boolean skipLines, boolean skipFirstTimeOnly) throws IOException, FileDescriptorFactory.FileDescriptorProcessingException {
        this.oneRecordReader.setRecordListener(this.recordListener);
        this.oneRecordReader.resetCounters();
        if (this.isRecordLimitReached) {
            return;
        }
        if (skipLines) {
            if (skipFirstTimeOnly) {
                if (this.skippedLinesCount >= this.fileDescriptor.getSkipLinesCount()) {
                    skipLines = false;
                }
            } else {
                this.skippedLinesCount = 0;
            }
        }
        if (skipLines) {
            while (this.fileDescriptor.getSkipLinesCount() > 0 && this.skippedLinesCount < this.fileDescriptor.getSkipLinesCount() && reader.hasNext(false)) {
                ++this.skippedLinesCount;
            }
            this.totalLinesCounter += this.skippedLinesCount;
            if (this.skippedLinesCount != this.fileDescriptor.getSkipLinesCount()) {
                return;
            }
        }
        try {
            while (reader.hasNext(false)) {
                block17: {
                    ++this.totalLinesCounter;
                    try {
                        this.oneRecordReader.readRecord(reader.current());
                    }
                    catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
                        Trace.logError(this, exception.getMessageForLog());
                        if (this.exceptionStrategy == null) break block17;
                        FileDescriptorFactory.FileDescriptorProcessorExceptionStrategy.StrategyAction strategyAction = this.exceptionStrategy.onException(exception);
                        if (strategyAction == FileDescriptorFactory.FileDescriptorProcessorExceptionStrategy.StrategyAction.RETHROW) {
                            throw exception;
                        }
                        if (strategyAction != FileDescriptorFactory.FileDescriptorProcessorExceptionStrategy.StrategyAction.STOP) break block17;
                        break;
                    }
                }
                if (this.recordLimit > 0L && (long)(this.totalRecordsCounter + this.oneRecordReader.getRecordCounter()) > this.recordLimit) {
                    this.isRecordLimitReached = true;
                    this.logger.logInfo("Record limit " + this.recordLimit + " is reached. Interrupting reading...");
                } else if (this.fileDescriptor.getEndAtLine() <= 0 || this.totalLinesCounter != this.fileDescriptor.getEndAtLine()) continue;
                break;
            }
        }
        finally {
            this.totalRecordsCounter += this.oneRecordReader.getRecordCounter();
        }
    }

    public void finish() {
        if (this.oneRecordReader != null) {
            this.oneRecordReader.endFileProcessing();
        }
    }
}

