/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.DelimitedFileLinesReader;
import com.streamscape.lib.file.DelimitedOneRecordReader;
import com.streamscape.lib.file.DelimitedOneRecordWriter;
import com.streamscape.lib.file.DelimitedRegexpOneRecordReader;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.FileFormat;
import com.streamscape.lib.file.FileLinesReader;
import com.streamscape.lib.file.FileRecordsReader;
import com.streamscape.lib.file.FileRecordsWriter;
import com.streamscape.lib.file.FormatterFactory;
import com.streamscape.lib.file.OneRecordReader;
import com.streamscape.lib.file.OneRecordWriter;
import com.streamscape.lib.file.PositionalOneRecordReader;
import com.streamscape.lib.file.PositionalOneRecordWriter;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.file.RecordSubTypeGroupDefinition;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.file.SubRecordField;
import com.streamscape.lib.file.UntypedRecordTypeDefinition;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.sdrpath.ReferencePathException;
import com.streamscape.sdo.sdrpath.ReferencePathManager;
import com.streamscape.sef.mf.admin.FabricContext;
import java.io.InputStream;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class FileDescriptorFactory {
    private FileDescriptor fileDescriptor;
    private ClassLoader classLoader;
    private SemanticTypeCache typeCache;
    private ReferencePathManager sdrManager;
    private Set<String> observableRecordTypes = new HashSet<String>();
    private RecordListener recordListener;
    private Logger logger;
    private FormatterFactory formatterFactory = new FormatterFactory();

    public void init(FileDescriptor fileDescriptor, ClassLoader classLoader, FabricContext fabricContext) {
        this.fileDescriptor = fileDescriptor;
        this.classLoader = classLoader;
        this.typeCache = fabricContext.getSemanticTypeCache();
        this.sdrManager = fabricContext.getSDRManagerFactory().createManager();
        this.validateAndInit();
    }

    public void validateAndInit() {
        if (this.fileDescriptor.getRecords() == null || this.fileDescriptor.getRecords().size() == 0) {
            throw new IllegalArgumentException("File descriptor should define at least one record type.");
        }
        if (this.fileDescriptor.getStartAtLine() > 0 && this.fileDescriptor.getEndAtLine() > 0 && this.fileDescriptor.getEndAtLine() < this.fileDescriptor.getStartAtLine()) {
            throw new IllegalArgumentException("End at line should be greater or equals start at line. 0 or -1 means last line of the file");
        }
        switch (this.fileDescriptor.getFileFormat()) {
            case CSV: 
            case DELIMITED: 
            case DELIMITED_REGEXP: 
            case POSITIONAL: {
                String types = "'" + String.valueOf((Object)FileFormat.CSV) + "' or '" + String.valueOf((Object)FileFormat.DELIMITED) + "' or '" + String.valueOf((Object)FileFormat.POSITIONAL) + "' or '" + String.valueOf((Object)FileFormat.DELIMITED_REGEXP) + "'";
                if (this.fileDescriptor.getRecords().size() != 1) {
                    throw new IllegalArgumentException("If file descriptor format is " + types + " it should contain only one record.");
                }
                if (this.fileDescriptor.hasGroupKey()) {
                    throw new IllegalArgumentException("If file descriptor format is " + types + " it should doesn't have group key.");
                }
                if (this.fileDescriptor.getRecords().stream().anyMatch(r -> !(r instanceof AbstractRecordTypeDefinition))) {
                    throw new IllegalArgumentException("If file descriptor format is " + types + " it should define one record of type RecordTypeDefinition or UntypedRecordTypeDefinition.");
                }
                switch (this.fileDescriptor.getFileFormat()) {
                    case CSV: {
                        if (this.fileDescriptor.getDelimiter() != null && !this.fileDescriptor.getDelimiter().equals("") && !this.fileDescriptor.getDelimiter().equals(",")) {
                            this.getLogger().logInfo("WARNING: If file descriptor format is '" + String.valueOf((Object)FileFormat.CSV) + "' delimiter should be not set or set to comma(,). Setting delimiter to comma.");
                        }
                        if (this.fileDescriptor.isQuoteSymbolSet() && this.fileDescriptor.getQuoteSymbol() != '\"') {
                            this.getLogger().logInfo("WARNING: If file descriptor format is '" + String.valueOf((Object)FileFormat.CSV) + "' quote symbol should be not set or set to double quotes(\"). Setting quote symbol to double quotes.");
                        }
                        this.fileDescriptor.setDelimiter(",");
                        this.fileDescriptor.setQuoteSymbol('\"');
                        break;
                    }
                    case DELIMITED: {
                        if (this.fileDescriptor.getDelimiter() == null || this.fileDescriptor.getDelimiter().equals("")) {
                            throw new IllegalArgumentException("If file descriptor format is '" + String.valueOf((Object)FileFormat.DELIMITED) + "' delimiter should be set.");
                        }
                        if (this.fileDescriptor.isQuoteSymbolSet() && this.fileDescriptor.getDelimiter().indexOf(this.fileDescriptor.getQuoteSymbol()) != -1) {
                            throw new IllegalArgumentException("If file descriptor format is '" + String.valueOf((Object)FileFormat.DELIMITED) + "' quote symbol cannot be contained in delimiter.");
                        }
                        if (this.fileDescriptor.isQuoteEscapeSymbolSet() && this.fileDescriptor.getDelimiter().indexOf(this.fileDescriptor.getQuoteEscapeSymbol()) != -1) {
                            throw new IllegalArgumentException("If file descriptor format is '" + String.valueOf((Object)FileFormat.DELIMITED) + "' quote escape symbol cannot be contained in delimiter.");
                        }
                        switch (this.fileDescriptor.getQuoteSymbol()) {
                            case '\u0000': 
                            case ' ': 
                            case '\"': 
                            case '\'': {
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("If file descriptor format is '" + String.valueOf((Object)FileFormat.DELIMITED) + "' quote symbol can be set to one or double quote symbol or to \\0 or to space that means no quote symbol.");
                            }
                        }
                        if (this.fileDescriptor.isQuoteEscapeSymbolSet() || !this.fileDescriptor.isAllQuoted()) break;
                        throw new IllegalArgumentException("All quoted cannot be set to true if quote symbol is not set.");
                    }
                    case DELIMITED_REGEXP: {
                        this.fileDescriptor.setDelimiter("");
                        this.fileDescriptor.setQuoteSymbol('\u0000');
                        this.fileDescriptor.setQuoteEscapeSymbol('\u0000');
                        this.fileDescriptor.setIgnoreInnerQuotes(false);
                        this.fileDescriptor.setRegexpPattern(Pattern.compile(this.fileDescriptor.getRegexp()));
                        break;
                    }
                }
                break;
            }
            case POSITIONAL_RECORD_TYPE: 
            case POSITIONAL_MULTI_RECORD_TYPE: {
                if (!this.fileDescriptor.hasKey()) {
                    throw new IllegalArgumentException("If file descriptor format is '" + String.valueOf((Object)FileFormat.POSITIONAL_RECORD_TYPE) + "' or '" + String.valueOf((Object)FileFormat.POSITIONAL_MULTI_RECORD_TYPE) + "' key field start/end positions should be specified.");
                }
                if (this.fileDescriptor.getKeyFieldStart() <= this.fileDescriptor.getKeyFieldEnd() && this.fileDescriptor.getKeyFieldStart() >= 1) break;
                throw new IllegalArgumentException("Invalid key field positions specified. Should be start<=end and start>=1 or start==end==0(means no key).");
            }
            default: {
                throw new IllegalArgumentException("File format '" + String.valueOf((Object)this.fileDescriptor.getFileFormat()) + "' not supported yet.");
            }
        }
        this.fileDescriptor.getRecords().forEach(this::validateAndInitRecord);
    }

    private void validateAndInitRecord(FileDescriptorRecord record) {
        block29: {
            block30: {
                Pattern pattern;
                block28: {
                    if (record.getTypeKey() == null) {
                        record.setTypeKey("");
                    }
                    pattern = Pattern.compile(record.getTypeKey());
                    record.setKeyPattern(pattern);
                    if (!(record instanceof RecordTypeDefinition)) break block28;
                    RecordTypeDefinition recordDefinition = (RecordTypeDefinition)record;
                    SemanticType recordSemanticType = this.typeCache.lookupSemanticType(recordDefinition.getSemanticType());
                    if (recordSemanticType == null) {
                        throw new IllegalArgumentException("Semantic type '" + recordSemanticType.getTypeName() + "' for record '" + recordDefinition.getTypeKey() + "' doesn't exist.");
                    }
                    Class<?> recordSemanticClass = null;
                    try {
                        recordSemanticClass = this.classLoader.loadClass(recordSemanticType.getClassName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Class '" + recordSemanticType.getClassName() + "' for semantic type '" + recordSemanticType.getTypeName() + "' for record '" + recordDefinition.getTypeKey() + "' doesn't exist.");
                    }
                    if (recordDefinition.getFields() == null) break block29;
                    for (RecordField field : recordDefinition.getFields()) {
                        if (field.getDataType() != null && field.getDataType().length() > 0) {
                            this.getLogger().logError("WARNING: Record definition '" + recordDefinition.getTypeName() + "' based on semantic type contains record field '" + field.getFieldName() + "' with data type '" + field.getDataType() + "'. This type will not be used.");
                        }
                        if (field instanceof SubRecordField) {
                            for (RecordTypeDefinition subRec : ((SubRecordField)field).getSubRecords().values()) {
                                pattern = Pattern.compile(subRec.getTypeKey());
                                subRec.setKeyPattern(pattern);
                            }
                        }
                        if (field.getSpaths() == null) continue;
                        for (String spath : field.getSpaths()) {
                            Class<?> fieldType = null;
                            try {
                                Class<?> fieldTypeTmp = this.sdrManager.getTypeAtPath(spath, recordSemanticClass);
                                if (fieldTypeTmp == null) {
                                    throw new IllegalArgumentException("Invalid spath '" + spath + "' for field '" + field.getFieldName() + "' of record '" + recordDefinition.getTypeKey() + "'. Spath doesn't exist in type '" + recordDefinition.getSemanticType() + "'.");
                                }
                                if (fieldType == null) {
                                    fieldType = fieldTypeTmp;
                                }
                                if (field.getFormat() != null && field.getFormat().length() > 0 && fieldType != fieldTypeTmp) {
                                    throw new IllegalArgumentException("If formatter is set for record field, all spath should be reference the same type. But spath '" + spath + "' references to type '" + fieldTypeTmp.getName() + "' and another spath references to type '" + fieldType.getName() + "'. Field '" + field.getFieldName() + "' of record '" + recordDefinition.getTypeKey() + "'.");
                                }
                            }
                            catch (ReferencePathException exception) {
                                throw new IllegalArgumentException("Invalid spath '" + spath + "' for field '" + field.getFieldName() + "' of record '" + recordDefinition.getTypeKey() + "'. Cause: " + exception.getMessage());
                            }
                            try {
                                field.setFormatter(this.formatterFactory.formatterOrDefault(fieldType, null, field.getFormat()));
                            }
                            catch (Exception exception) {
                                throw new IllegalArgumentException("Cannot create formatter '" + field.getFormat() + "' for spath '" + spath + "' for field '" + field.getFieldName() + "' of record '" + recordDefinition.getTypeKey() + "'. Cause: " + exception.getMessage());
                            }
                        }
                    }
                    break block29;
                }
                if (!(record instanceof UntypedRecordTypeDefinition)) break block30;
                UntypedRecordTypeDefinition recordDefinition = (UntypedRecordTypeDefinition)record;
                if (recordDefinition.getFields() == null) break block29;
                for (RecordField field : recordDefinition.getFields()) {
                    if (field.getDataType() == null || field.getDataType().length() == 0) {
                        throw new IllegalArgumentException("Record definition '" + recordDefinition.getTypeName() + "' is not based on semantic type but field '" + field.getFieldName() + "' doesn't define data type. Also this field should not define spathes.");
                    }
                    if (field.getSpaths() != null && field.getSpaths().length > 0) {
                        this.getLogger().logInfo("WARNING: Record definition '" + recordDefinition.getTypeName() + "' is not based on semantic type, but contains record field '" + field.getFieldName() + "' with spathes [" + field.getSpathsString() + "].");
                    }
                    if (field instanceof SubRecordField) {
                        for (RecordTypeDefinition subRec : ((SubRecordField)field).getSubRecords().values()) {
                            pattern = Pattern.compile(subRec.getTypeKey());
                            subRec.setKeyPattern(pattern);
                        }
                    }
                    try {
                        if (field.getFormat() != null && field.getFormat().length() > 0 && ("date".equalsIgnoreCase(field.getDataType()) || "sqldate".equalsIgnoreCase(field.getDataType()))) {
                            field.setFormatter(this.formatterFactory.formatterOrDefault(Date.class, field.getDataType(), field.getFormat()));
                        }
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Cannot create formatter '" + field.getFormat() + "' for field '" + field.getFieldName() + "' of record '" + recordDefinition.getTypeKey() + "'. Cause: " + exception.getMessage());
                    }
                    if (field.getDataType() == null) continue;
                    try {
                        field.setFormatter(this.formatterFactory.formatterOrDefault(field.getDataType(), field.getFormat()));
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Cannot create formatter '" + field.getFormat() + "' of type '" + field.getDataType() + "' for field '" + field.getFieldName() + "' of record '" + recordDefinition.getTypeKey() + "'. Cause: " + exception.getMessage());
                    }
                }
                break block29;
            }
            if (record instanceof RecordSubTypeGroupDefinition) {
                RecordSubTypeGroupDefinition subTypeGroup = (RecordSubTypeGroupDefinition)record;
                for (FileDescriptorRecord subRec : subTypeGroup.getSubTypeRecords()) {
                    this.validateAndInitRecord(subRec);
                }
            }
        }
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public ReferencePathManager getSdrManager() {
        return this.sdrManager;
    }

    public void setRecordListener(RecordListener recordListener) {
        this.recordListener = recordListener;
    }

    public RecordListener getRecordListener() {
        return this.recordListener;
    }

    public void setObservableRecordType(String recordType) {
        this.observableRecordTypes = new HashSet<String>();
        this.observableRecordTypes.add(recordType);
    }

    public void setObservableRecordTypes(List<String> recordTypes) {
        this.observableRecordTypes = new HashSet<String>(recordTypes);
    }

    public HashSet<String> getObservableRecordTypes() {
        return new HashSet<String>(this.observableRecordTypes);
    }

    public SemanticTypeCache getTypeCache() {
        return this.typeCache;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public FormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    public FileDescriptorFactory setFormatterFactory(FormatterFactory formatterFactory) {
        this.formatterFactory = formatterFactory;
        return this;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            return new Logger(this){

                @Override
                public void logDebug(String message) {
                    Trace.logDebug(this, message);
                }

                @Override
                public void logInfo(String message) {
                    Trace.logInfo(this, message);
                }

                @Override
                public void logError(String message) {
                    Trace.logError(this, message);
                }
            };
        }
        return this.logger;
    }

    public FileLinesReader createFileLinesReader(InputStream inputStream, String encoding, boolean eofIsEndOfLine) {
        if (encoding == null || encoding.length() == 0) {
            encoding = this.fileDescriptor.getEncoding();
        }
        DelimitedFileLinesReader fileLinesReader = new DelimitedFileLinesReader(inputStream, encoding, eofIsEndOfLine);
        switch (this.fileDescriptor.getFileFormat()) {
            case CSV: 
            case DELIMITED: 
            case DELIMITED_REGEXP: {
                fileLinesReader.setQuoteSymbol(this.fileDescriptor.getQuoteSymbol());
                fileLinesReader.setQuoteEscapeSymbol(this.fileDescriptor.getQuoteEscapeSymbol());
                fileLinesReader.setFieldsDelimiter(this.fileDescriptor.getDelimiter());
                fileLinesReader.setLinesDelimiter(this.fileDescriptor.getUnescapedLinesDelimiter());
                break;
            }
            case POSITIONAL: 
            case POSITIONAL_RECORD_TYPE: 
            case POSITIONAL_MULTI_RECORD_TYPE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("File format '" + String.valueOf((Object)this.fileDescriptor.getFileFormat()) + "' not supported yet.");
            }
        }
        return fileLinesReader;
    }

    public FileRecordsReader createFileRecordsReader() {
        return new FileRecordsReader(this);
    }

    public OneRecordReader createOneRecordReader() {
        switch (this.fileDescriptor.getFileFormat()) {
            case CSV: 
            case DELIMITED: {
                return new DelimitedOneRecordReader(this);
            }
            case DELIMITED_REGEXP: {
                return new DelimitedRegexpOneRecordReader(this);
            }
            case POSITIONAL: 
            case POSITIONAL_RECORD_TYPE: 
            case POSITIONAL_MULTI_RECORD_TYPE: {
                return new PositionalOneRecordReader(this);
            }
        }
        throw new IllegalArgumentException("File format '" + String.valueOf((Object)this.fileDescriptor.getFileFormat()) + "' not supported yet.");
    }

    public FileRecordsWriter createFileRecordsWriter(Writer writer) {
        return new FileRecordsWriter(this, writer);
    }

    public OneRecordWriter createOneRecordWriter() {
        switch (this.fileDescriptor.getFileFormat()) {
            case CSV: 
            case DELIMITED: {
                return new DelimitedOneRecordWriter(this);
            }
            case DELIMITED_REGEXP: {
                throw new IllegalArgumentException("Writer for '" + String.valueOf((Object)this.fileDescriptor.getFileFormat()) + "' is not supported.");
            }
            case POSITIONAL: 
            case POSITIONAL_RECORD_TYPE: 
            case POSITIONAL_MULTI_RECORD_TYPE: {
                return new PositionalOneRecordWriter(this);
            }
        }
        throw new IllegalArgumentException("File format '" + String.valueOf((Object)this.fileDescriptor.getFileFormat()) + "' not supported yet.");
    }

    FileDescriptorRecord getRecordDefinition(String recordKey, FileDescriptorProcessingException.RecordAction action) throws FileDescriptorProcessingException {
        if (!(this.fileDescriptor.hasKey() || recordKey != null && recordKey.length() != 0)) {
            return this.fileDescriptor.getRecords().get(0);
        }
        if (recordKey == null) {
            throw new FileDescriptorProcessingException("Invalid record key specified.", action);
        }
        FileDescriptorRecord record = this.fileDescriptor.getRecords().stream().filter(r -> r.getKeyPattern().matcher(recordKey).matches()).findFirst().orElse(null);
        if (record == null) {
            throw new FileDescriptorProcessingException("Unknown record with key '" + recordKey + "' specified.", action);
        }
        return record;
    }

    static {
        try {
            if (!TypeFactory.existsSemanticType(FileDescriptor.class.getSimpleName())) {
                SemanticType type = new SemanticType(FileDescriptor.class.getSimpleName(), FileDescriptor.class.getName());
                TypeFactory.addSemanticType(type);
            }
        }
        catch (Exception error) {
            Trace.logError(FileDescriptorFactory.class, "Unable to add semantic type {}.", FileDescriptor.class.getName());
        }
    }

    public static interface RecordListener {
        public void onRecord(Object var1, AbstractRecordTypeDefinition var2);

        public void onGroupRecord(Object var1, String var2, String var3);
    }

    public static class FileDescriptorProcessingException
    extends Exception {
        private RecordAction action;
        private String recordLine;
        private int recordNumber;

        FileDescriptorProcessingException(String message, RecordAction action) {
            super(message);
            this.action = action;
        }

        public void setRecordLine(String recordLine) {
            this.recordLine = recordLine;
        }

        public void setRecordNumber(int recordNumber) {
            this.recordNumber = recordNumber;
        }

        public String getRecordLine() {
            return this.recordLine;
        }

        public int getRecordNumber() {
            return this.recordNumber;
        }

        public RecordAction getAction() {
            return this.action;
        }

        public String getMessageForLog() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getMessage());
            if (this.action == RecordAction.REJECTED) {
                builder.append(" Rejecting record number " + this.recordNumber + "...");
            } else if (this.action == RecordAction.SKIPPED) {
                builder.append(" Skipping record number " + this.recordNumber + "...");
            }
            return builder.toString();
        }

        public static enum RecordAction {
            PROCESSED,
            REJECTED,
            SKIPPED;

        }
    }

    public static interface FileDescriptorProcessorExceptionStrategy {
        public StrategyAction onException(FileDescriptorProcessingException var1);

        public static enum StrategyAction {
            RETHROW,
            STOP,
            CONTINUTE;

        }
    }
}

