/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.DelimitedFileHeaderParser;
import com.streamscape.lib.file.DelimitedFileLinesReader;
import com.streamscape.lib.file.DelimitedOneRecordReader;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.FileFormat;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.file.RecordSubTypeGroupDefinition;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.file.SubRecordField;
import com.streamscape.lib.file.UntypedRecordTypeDefinition;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class FileDescriptorBuilder<T extends FileDescriptorBuilder> {
    private FileFormat fileFormat;
    private boolean skipFirstLine = false;
    private int startAtLine = 0;
    private int endAtLine = 0;
    private String description = "";
    private boolean trimWhitespaces = false;
    private String nullIndicator = "";
    private boolean isSystem = false;
    private String linesDelimiter;
    private List<FileDescriptorRecord> records = new ArrayList<FileDescriptorRecord>();

    private FileDescriptorBuilder(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public static DelimitedFileDescriptorBuilder delimited() {
        return new DelimitedFileDescriptorBuilder();
    }

    public static DelimitedRegexpFileDescriptorBuilder delimitedRegexp() {
        return new DelimitedRegexpFileDescriptorBuilder();
    }

    public static CsvFileDescriptorBuilder csv() {
        return new CsvFileDescriptorBuilder();
    }

    public static PositionalFileDescriptorBuilder positional() {
        return new PositionalFileDescriptorBuilder();
    }

    public static PositionalRecordFileDescriptorBuilder positionalRecord() {
        return new PositionalRecordFileDescriptorBuilder();
    }

    public static PositionalMultiRecordFileDescriptorBuilder positionalMultiRecord() {
        return new PositionalMultiRecordFileDescriptorBuilder();
    }

    public FileDescriptor build() {
        FileDescriptor descriptor = new FileDescriptor();
        descriptor.setFileFormat(this.fileFormat);
        descriptor.setSkipFirstLine(this.skipFirstLine);
        descriptor.setStartAtLine(this.startAtLine);
        descriptor.setEndAtLine(this.endAtLine);
        descriptor.setDescription(this.description);
        descriptor.setAutotrimWhitespaces(this.trimWhitespaces);
        descriptor.setNullIndicator(this.nullIndicator);
        descriptor.setRecords(this.records);
        descriptor.setIsSystem(this.isSystem);
        descriptor.setLinesDelimiter(this.linesDelimiter);
        this.doBuild(descriptor);
        return descriptor;
    }

    protected abstract void doBuild(FileDescriptor var1);

    public T setSkipFirstLine(boolean skipFirstLine) {
        this.skipFirstLine = skipFirstLine;
        return (T)this;
    }

    public T setStartAtLine(int startAtLine) {
        this.startAtLine = startAtLine;
        return (T)this;
    }

    public T setEndAtLine(int endAtLine) {
        this.endAtLine = endAtLine;
        return (T)this;
    }

    public T setDescription(String description) {
        this.description = description;
        return (T)this;
    }

    public T setTrimWhitespaces(boolean trimWhitespaces) {
        this.trimWhitespaces = trimWhitespaces;
        return (T)this;
    }

    public T setNullIndicator(String nullIndicator) {
        this.nullIndicator = nullIndicator;
        return (T)this;
    }

    public T setLinesDelimiter(String linesDelimiter) {
        this.linesDelimiter = linesDelimiter;
        return (T)this;
    }

    public T setIsSystem(boolean isSystem) {
        this.isSystem = isSystem;
        return (T)this;
    }

    public T addRecord(FileDescriptorRecord record) {
        if (record == null) {
            throw new IllegalArgumentException("null record cannot be added.");
        }
        switch (this.fileFormat) {
            case CSV: 
            case DELIMITED: 
            case POSITIONAL: 
            case DELIMITED_REGEXP: {
                if (!(record instanceof AbstractRecordTypeDefinition)) {
                    throw new IllegalArgumentException("Only record of type 'RecordTypeDefinition' or 'UntypedRecordTypeDefinition' can be added for file format '" + String.valueOf((Object)this.fileFormat) + "'.");
                }
                if (this.records.size() < 1) break;
                throw new IllegalArgumentException("Only one record of type 'AbstractRecordTypeDefinition' or 'UntypedRecordTypeDefinition' can be added for file format '" + String.valueOf((Object)this.fileFormat) + "'.");
            }
            case POSITIONAL_MULTI_RECORD_TYPE: 
            case POSITIONAL_RECORD_TYPE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("File format '" + String.valueOf((Object)this.fileFormat) + "' not yet supported.");
            }
        }
        this.records.add(record);
        return (T)this;
    }

    public RecordTypeDefinitionBuilderForDescriptor<T> recordTypeDefinition() {
        return new RecordTypeDefinitionBuilderForDescriptor(this);
    }

    public UntypedRecordTypeDefinitionBuilderForDescriptor<T> untypedRecordTypeDefinition() {
        return new UntypedRecordTypeDefinitionBuilderForDescriptor(this);
    }

    public static class DelimitedFileDescriptorBuilder
    extends AbstractDelimitedFileDescriptorBuilder<DelimitedFileDescriptorBuilder> {
        private String delimiter = "";
        private char quoteSymbol = '\u0000';
        private char quoteEscapeSymbol = '\u0000';
        private boolean ignoreInnerQuotes = false;
        private boolean allQuoted = false;

        private DelimitedFileDescriptorBuilder() {
            super(FileFormat.DELIMITED);
        }

        public DelimitedFileDescriptorBuilder setDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public DelimitedFileDescriptorBuilder setQuoteSymbol(char quoteSymbol) {
            this.quoteSymbol = quoteSymbol;
            return this;
        }

        public DelimitedFileDescriptorBuilder setQuoteEscapeSymbol(char quoteEscapeSymbol) {
            this.quoteEscapeSymbol = quoteEscapeSymbol;
            return this;
        }

        public DelimitedFileDescriptorBuilder setIgnoreInnerQuotes(boolean ignoreInnerQuotes) {
            this.ignoreInnerQuotes = ignoreInnerQuotes;
            return this;
        }

        public DelimitedFileDescriptorBuilder setAllQuoted(boolean allQuoted) {
            this.allQuoted = allQuoted;
            return this;
        }

        @Override
        protected void doBuild(FileDescriptor descriptor) {
            if (this.delimiter == null || this.delimiter.length() == 0) {
                throw new IllegalArgumentException("Delimiter should be set for DELIMITED file descriptor.");
            }
            descriptor.setDelimiter(this.delimiter);
            descriptor.setQuoteSymbol(this.quoteSymbol);
            descriptor.setQuoteEscapeSymbol(this.quoteEscapeSymbol);
            descriptor.setIgnoreInnerQuotes(this.ignoreInnerQuotes);
            descriptor.setAllQuoted(this.allQuoted);
        }
    }

    public static class DelimitedRegexpFileDescriptorBuilder
    extends AbstractDelimitedFileDescriptorBuilder<DelimitedRegexpFileDescriptorBuilder> {
        private String regexp = null;

        private DelimitedRegexpFileDescriptorBuilder() {
            super(FileFormat.DELIMITED_REGEXP);
        }

        public String getRegexp() {
            return this.regexp;
        }

        public DelimitedRegexpFileDescriptorBuilder setRegexp(String regexp) {
            this.regexp = regexp;
            return this;
        }

        @Override
        protected void doBuild(FileDescriptor descriptor) {
            if (this.regexp == null || this.regexp.length() == 0) {
                throw new IllegalArgumentException("Regular expression should be set for DELIMITED_REGEXP file descriptor.");
            }
            try {
                Pattern pattern = Pattern.compile(this.regexp);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Regular expression is invalid.", exception);
            }
            descriptor.setRegexp(this.regexp);
        }
    }

    public static class CsvFileDescriptorBuilder
    extends AbstractDelimitedFileDescriptorBuilder<CsvFileDescriptorBuilder> {
        private boolean allQuoted = false;
        private String delimiter = ",";
        private char quoteSymbol = (char)34;
        private char quoteEscapeSymbol = (char)34;
        private boolean ignoreInnerQuotes = false;

        private CsvFileDescriptorBuilder() {
            super(FileFormat.CSV);
        }

        public CsvFileDescriptorBuilder setAllQuoted(boolean allQuoted) {
            this.allQuoted = allQuoted;
            return this;
        }

        public CsvFileDescriptorBuilder setQuoteEscapeSymbol(char quoteEscapeSymbol) {
            this.quoteEscapeSymbol = quoteEscapeSymbol;
            return this;
        }

        public CsvFileDescriptorBuilder setIgnoreInnerQuotes(boolean ignoreInnerQuotes) {
            this.ignoreInnerQuotes = ignoreInnerQuotes;
            return this;
        }

        @Override
        protected void doBuild(FileDescriptor descriptor) {
            descriptor.setAllQuoted(this.allQuoted);
            descriptor.setDelimiter(this.delimiter);
            descriptor.setQuoteSymbol(this.quoteSymbol);
            descriptor.setQuoteEscapeSymbol(this.quoteEscapeSymbol);
            descriptor.setIgnoreInnerQuotes(this.ignoreInnerQuotes);
        }
    }

    public static class PositionalFileDescriptorBuilder
    extends FileDescriptorBuilder<PositionalFileDescriptorBuilder> {
        private PositionalFileDescriptorBuilder() {
            super(FileFormat.POSITIONAL);
        }

        @Override
        protected void doBuild(FileDescriptor descriptor) {
        }
    }

    public static class PositionalRecordFileDescriptorBuilder
    extends AbstractPositionalRecordFileDescriptorBuilder<PositionalRecordFileDescriptorBuilder> {
        private PositionalRecordFileDescriptorBuilder() {
            super(FileFormat.POSITIONAL_RECORD_TYPE);
        }
    }

    public static class PositionalMultiRecordFileDescriptorBuilder
    extends AbstractPositionalRecordFileDescriptorBuilder<PositionalMultiRecordFileDescriptorBuilder> {
        private PositionalMultiRecordFileDescriptorBuilder() {
            super(FileFormat.POSITIONAL_MULTI_RECORD_TYPE);
        }
    }

    public static class RecordTypeDefinitionBuilderForDescriptor<T1 extends FileDescriptorBuilder>
    extends RecordTypeDefinitionBuilder<T1, RecordTypeDefinitionBuilderForDescriptor<T1>> {
        private RecordTypeDefinitionBuilderForDescriptor(FileDescriptorBuilder<T1> descriptorBuilder) {
            super(descriptorBuilder);
        }

        public T1 add() {
            this.descriptorBuilder.addRecord(this.build());
            return (T1)this.descriptorBuilder;
        }

        public RecordTypeDefinitionBuilderForDescriptor<T1> autobuildFromHeaderFile(String fileName, int headerAtLine) throws IOException {
            RecordTypeDefinitionBuilderForDescriptorHelper.autobuildFromHeaderFile(fileName, headerAtLine, null, (AbstractRecordTypeDefinitionBuilder)this);
            return this;
        }

        public RecordTypeDefinitionBuilderForDescriptor<T1> autobuildFromHeaderFile(InputStream input, int headerAtLine) throws IOException {
            RecordTypeDefinitionBuilderForDescriptorHelper.autobuildFromHeaderFile(input, headerAtLine, null, (AbstractRecordTypeDefinitionBuilder)this);
            return this;
        }

        public RecordTypeDefinitionBuilderForDescriptor<T1> autobuildFromHeader(String headerLine) throws IOException {
            RecordTypeDefinitionBuilderForDescriptorHelper.autobuildFromHeader(headerLine, null, this);
            return this;
        }
    }

    public static class UntypedRecordTypeDefinitionBuilderForDescriptor<T1 extends FileDescriptorBuilder>
    extends UntypedRecordTypeDefinitionBuilder<T1, UntypedRecordTypeDefinitionBuilderForDescriptor<T1>> {
        private UntypedRecordTypeDefinitionBuilderForDescriptor(FileDescriptorBuilder<T1> descriptorBuilder) {
            super(descriptorBuilder);
        }

        public T1 add() {
            this.descriptorBuilder.addRecord(this.build());
            return (T1)this.descriptorBuilder;
        }

        public UntypedRecordTypeDefinitionBuilderForDescriptor<T1> autobuildFromHeaderFile(String fileName, int headerAtLine, Map<String, String> typesMap) throws IOException {
            RecordTypeDefinitionBuilderForDescriptorHelper.autobuildFromHeaderFile(fileName, headerAtLine, typesMap, (AbstractRecordTypeDefinitionBuilder)this);
            return this;
        }

        public UntypedRecordTypeDefinitionBuilderForDescriptor<T1> autobuildFromHeaderFile(InputStream input, int headerAtLine, Map<String, String> typesMap) throws IOException {
            RecordTypeDefinitionBuilderForDescriptorHelper.autobuildFromHeaderFile(input, headerAtLine, typesMap, (AbstractRecordTypeDefinitionBuilder)this);
            return this;
        }

        public UntypedRecordTypeDefinitionBuilderForDescriptor<T1> autobuildFromHeader(String headerLine, Map<String, String> typesMap) throws IOException {
            RecordTypeDefinitionBuilderForDescriptorHelper.autobuildFromHeader(headerLine, typesMap, this);
            return this;
        }
    }

    public static class SubRecordFieldBuilder<T1 extends FileDescriptorBuilder, T2 extends RecordTypeDefinitionBuilder>
    extends AbstractRecordFieldBuilder<T1, T2, SubRecordFieldBuilder<T1, T2>> {
        private int keyFieldStart = 0;
        private int keyFieldEnd = 0;
        private Map<String, RecordTypeDefinition> subRecords = new HashMap<String, RecordTypeDefinition>();

        private SubRecordFieldBuilder(T2 recordTypeDefinitionBuilder) {
            super(recordTypeDefinitionBuilder);
        }

        @Override
        public RecordField build() {
            SubRecordField recordField = new SubRecordField();
            this.doBuild(recordField);
            return recordField;
        }

        @Override
        protected void doBuild(RecordField recordField) {
            ((SubRecordField)recordField).setKeyFieldStart(this.keyFieldStart);
            ((SubRecordField)recordField).setKeyFieldEnd(this.keyFieldEnd);
            ((SubRecordField)recordField).setSubRecords(this.subRecords);
        }

        public SubRecordFieldBuilder<T1, T2> setKeyFieldStart(int keyFieldStart) {
            this.keyFieldStart = keyFieldStart;
            return this;
        }

        public SubRecordFieldBuilder<T1, T2> setKeyFieldEnd(int keyFieldEnd) {
            this.keyFieldEnd = keyFieldEnd;
            return this;
        }

        public SubRecordFieldBuilder<T1, T2> addSubRecord(String typeCode, RecordTypeDefinition record) {
            this.subRecords.put(typeCode, record);
            return this;
        }

        public RecordTypeDefinitionBuilderForRecordSubRecordField<T1, T2> recordTypeDefinition(String typeCode) {
            return new RecordTypeDefinitionBuilderForRecordSubRecordField(((RecordTypeDefinitionBuilder)this.recordTypeDefinitionBuilder).descriptorBuilder, this, typeCode);
        }
    }

    public static class RecordFieldBuilder<T1 extends FileDescriptorBuilder, T2 extends AbstractRecordTypeDefinitionBuilder>
    extends AbstractRecordFieldBuilder<T1, T2, RecordFieldBuilder<T1, T2>> {
        private RecordFieldBuilder(T2 recordTypeDefinitionBuilder) {
            super(recordTypeDefinitionBuilder);
        }

        @Override
        public RecordField build() {
            RecordField recordField = new RecordField();
            this.doBuild(recordField);
            return recordField;
        }
    }

    public static abstract class AbstractRecordFieldBuilder<T1 extends FileDescriptorBuilder, T2 extends AbstractRecordTypeDefinitionBuilder, T3 extends AbstractRecordFieldBuilder> {
        protected T2 recordTypeDefinitionBuilder;
        private String fieldName = "";
        private String description = "";
        private String converterName = "";
        private String format = "";
        private int start;
        private int end;
        private Set<String> spaths = new HashSet<String>();
        private String dataType = null;
        private String defaultValue;
        private boolean nullable = true;
        private Boolean trimWhitespaces = null;
        private String nullIndicator = null;

        private AbstractRecordFieldBuilder(T2 recordTypeDefinitionBuilder) {
            this.recordTypeDefinitionBuilder = recordTypeDefinitionBuilder;
        }

        public abstract RecordField build();

        protected void doBuild(RecordField recordField) {
            recordField.setFieldName(this.fieldName);
            recordField.setDescription(this.description);
            recordField.setConverterName(this.converterName);
            recordField.setFormat(this.format);
            recordField.setDefaultValue(this.defaultValue);
            recordField.setNullable(this.nullable);
            recordField.setNullIndicator(this.nullIndicator);
            recordField.setAutotrimWhitespaces(this.trimWhitespaces);
            recordField.setStart(this.start);
            recordField.setEnd(this.end);
            recordField.setSpaths(this.spaths.toArray(new String[0]));
            recordField.setDataType(this.dataType);
        }

        public T2 add() {
            ((AbstractRecordTypeDefinitionBuilder)this.recordTypeDefinitionBuilder).addRecordField(this.build());
            return this.recordTypeDefinitionBuilder;
        }

        public T3 setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return (T3)this;
        }

        public T3 setDescription(String description) {
            this.description = description;
            return (T3)this;
        }

        public T3 setConverterName(String converterName) {
            this.converterName = converterName;
            return (T3)this;
        }

        public T3 setFormat(String format) {
            this.format = format;
            return (T3)this;
        }

        public T3 setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return (T3)this;
        }

        public T3 setTrimWhitespaces(boolean trimWhitespaces) {
            this.trimWhitespaces = trimWhitespaces;
            return (T3)this;
        }

        public T3 setNullable(boolean nullable) {
            this.nullable = nullable;
            return (T3)this;
        }

        public T3 setNullIndicator(String nullIndicator) {
            this.nullIndicator = nullIndicator;
            return (T3)this;
        }

        public T3 setStart(int start) {
            this.start = start;
            return (T3)this;
        }

        public T3 setEnd(int end) {
            this.end = end;
            return (T3)this;
        }

        public T3 setSpaths(String[] spaths) {
            if (!(this.recordTypeDefinitionBuilder instanceof RecordTypeDefinitionBuilder)) {
                throw new IllegalArgumentException("Spath can be set for record type definition only.");
            }
            this.spaths.clear();
            this.spaths.addAll(Arrays.asList(spaths));
            return (T3)this;
        }

        public T3 addSpath(String spath) {
            if (!(this.recordTypeDefinitionBuilder instanceof RecordTypeDefinitionBuilder)) {
                throw new IllegalArgumentException("Spath can be set for record type definition only.");
            }
            this.spaths.add(spath);
            return (T3)this;
        }

        public T3 setDataType(String dataType) {
            if (!(this.recordTypeDefinitionBuilder instanceof UntypedRecordTypeDefinitionBuilder)) {
                throw new IllegalArgumentException("Data type can be set for untyped record type definition only.");
            }
            this.dataType = dataType;
            return (T3)this;
        }
    }

    public static class RecordTypeDefinitionBuilderForRecordSubRecordField<T1 extends FileDescriptorBuilder, T2 extends RecordTypeDefinitionBuilder>
    extends RecordTypeDefinitionBuilder<T1, RecordTypeDefinitionBuilderForRecordSubRecordField<T1, T2>> {
        private SubRecordFieldBuilder<T1, T2> subRecordFieldBuilder;
        private String typeCode;

        private RecordTypeDefinitionBuilderForRecordSubRecordField(FileDescriptorBuilder<T1> descriptorBuilder, SubRecordFieldBuilder<T1, T2> subRecordFieldBuilder, String typeCode) {
            super(descriptorBuilder);
            this.subRecordFieldBuilder = subRecordFieldBuilder;
            this.typeCode = typeCode;
        }

        public SubRecordFieldBuilder<T1, T2> add() {
            this.subRecordFieldBuilder.addSubRecord(this.typeCode, (RecordTypeDefinition)this.build());
            return this.subRecordFieldBuilder;
        }
    }

    public static class RecordSubTypeGroupDefinitionBuilderForRecordSubTypeGroup<T1 extends FileDescriptorBuilder, T2 extends RecordSubTypeGroupDefinitionBuilder>
    extends RecordSubTypeGroupDefinitionBuilder<T1, RecordSubTypeGroupDefinitionBuilderForRecordSubTypeGroup<T1, T2>> {
        protected T2 recordSubTypeGroupDefinitionBuilder;

        private RecordSubTypeGroupDefinitionBuilderForRecordSubTypeGroup(FileDescriptorBuilder<T1> descriptorBuilder, T2 recordSubTypeGroupDefinitionBuilder) {
            super(descriptorBuilder);
            this.recordSubTypeGroupDefinitionBuilder = recordSubTypeGroupDefinitionBuilder;
        }

        public T2 add() {
            ((RecordSubTypeGroupDefinitionBuilder)this.recordSubTypeGroupDefinitionBuilder).addRecord(this.build());
            return this.recordSubTypeGroupDefinitionBuilder;
        }
    }

    public static class RecordTypeDefinitionBuilderForRecordSubTypeGroup<T1 extends FileDescriptorBuilder, T2 extends RecordSubTypeGroupDefinitionBuilder>
    extends RecordTypeDefinitionBuilder<T1, RecordTypeDefinitionBuilderForRecordSubTypeGroup<T1, T2>> {
        protected T2 recordSubTypeGroupDefinitionBuilder;

        private RecordTypeDefinitionBuilderForRecordSubTypeGroup(FileDescriptorBuilder<T1> descriptorBuilder, T2 recordSubTypeGroupDefinitionBuilder) {
            super(descriptorBuilder);
            this.recordSubTypeGroupDefinitionBuilder = recordSubTypeGroupDefinitionBuilder;
        }

        public T2 add() {
            ((RecordSubTypeGroupDefinitionBuilder)this.recordSubTypeGroupDefinitionBuilder).addRecord(this.build());
            return this.recordSubTypeGroupDefinitionBuilder;
        }
    }

    public static class RecordSubTypeGroupDefinitionBuilderForDescriptor<T1 extends FileDescriptorBuilder>
    extends RecordSubTypeGroupDefinitionBuilder<T1, RecordSubTypeGroupDefinitionBuilderForDescriptor<T1>> {
        private RecordSubTypeGroupDefinitionBuilderForDescriptor(FileDescriptorBuilder<T1> descriptorBuilder) {
            super(descriptorBuilder);
        }

        public T1 add() {
            this.descriptorBuilder.addRecord(this.build());
            return (T1)this.descriptorBuilder;
        }

        public RecordTypeDefinitionBuilderForRecordSubTypeGroup<T1, RecordSubTypeGroupDefinitionBuilderForDescriptor<T1>> recordTypeDefinition() {
            return new RecordTypeDefinitionBuilderForRecordSubTypeGroup(this.descriptorBuilder, this);
        }

        public RecordSubTypeGroupDefinitionBuilderForRecordSubTypeGroup<T1, RecordSubTypeGroupDefinitionBuilderForDescriptor<T1>> recordSubTypeGroupDefinition() {
            return new RecordSubTypeGroupDefinitionBuilderForRecordSubTypeGroup(this.descriptorBuilder, this);
        }
    }

    public static class RecordTypeDefinitionBuilderForDescriptorHelper {
        private static void autobuildFromHeaderFile(String fileName, int headerAtLine, Map<String, String> typesMap, AbstractRecordTypeDefinitionBuilder typeDefinitionBuilder) throws IOException {
            try (FileInputStream input = new FileInputStream(fileName);){
                RecordTypeDefinitionBuilderForDescriptorHelper.autobuildFromHeaderFile(input, headerAtLine, typesMap, typeDefinitionBuilder);
            }
        }

        public static void autobuildFromHeaderFile(InputStream input, int headerAtLine, Map<String, String> typesMap, AbstractRecordTypeDefinitionBuilder typeDefinitionBuilder) throws IOException {
            FileDescriptorBuilder descriptorBuilder = typeDefinitionBuilder.descriptorBuilder;
            DelimitedFileLinesReader reader = new DelimitedFileLinesReader(input, null);
            if (descriptorBuilder.fileFormat == FileFormat.DELIMITED) {
                reader.setQuoteSymbol(((DelimitedFileDescriptorBuilder)descriptorBuilder).quoteSymbol);
                reader.setQuoteEscapeSymbol(((DelimitedFileDescriptorBuilder)descriptorBuilder).quoteEscapeSymbol);
                reader.setFieldsDelimiter(((DelimitedFileDescriptorBuilder)descriptorBuilder).delimiter);
            } else {
                reader.setQuoteSymbol('\"');
                reader.setQuoteEscapeSymbol('\"');
            }
            String headerLine = null;
            while (headerAtLine-- > 0) {
                if (!reader.hasNext(false)) {
                    throw new IOException("End of file reached.");
                }
                headerLine = reader.current();
            }
            RecordTypeDefinitionBuilderForDescriptorHelper.autobuildFromHeader(headerLine, typesMap, typeDefinitionBuilder);
        }

        private static void autobuildFromHeader(String headerLine, Map<String, String> typesMap, AbstractRecordTypeDefinitionBuilder typeDefinitionBuilder) throws IOException {
            FileDescriptorBuilder descriptorBuilder = typeDefinitionBuilder.descriptorBuilder;
            if (descriptorBuilder.fileFormat != FileFormat.CSV && descriptorBuilder.fileFormat != FileFormat.DELIMITED) {
                throw new IllegalArgumentException("Autobuild allowed for CSV and DELIMITED files only.");
            }
            String delimiter = ",";
            char quoteSymbol = '\"';
            char quoteEscapeSymbol = '\"';
            if (descriptorBuilder.fileFormat == FileFormat.DELIMITED) {
                delimiter = ((DelimitedFileDescriptorBuilder)descriptorBuilder).delimiter;
                quoteSymbol = ((DelimitedFileDescriptorBuilder)descriptorBuilder).quoteSymbol;
                quoteEscapeSymbol = ((DelimitedFileDescriptorBuilder)descriptorBuilder).quoteEscapeSymbol;
            }
            DelimitedOneRecordReader.DelimitedRecordLineFieldsReader reader = new DelimitedOneRecordReader.DelimitedRecordLineFieldsReader(headerLine, delimiter);
            reader.setQuoteSymbol(quoteSymbol);
            reader.setQuoteEscapeSymbol(quoteEscapeSymbol);
            reader.setAutotrimWhitespaces(true);
            try {
                while (reader.hasNext()) {
                    String name = reader.current();
                    LinkedHashSet<String> names = new LinkedHashSet<String>();
                    String fieldName = DelimitedFileHeaderParser.escapeFieldName(names, name);
                    RecordFieldBuilder recordFieldBuilder = typeDefinitionBuilder.recordField();
                    recordFieldBuilder.setFieldName(fieldName);
                    recordFieldBuilder.setDescription(name);
                    if (typeDefinitionBuilder instanceof RecordTypeDefinitionBuilderForDescriptor) {
                        recordFieldBuilder.addSpath("//" + fieldName);
                    } else {
                        String typeName;
                        String string = typeName = typesMap != null ? typesMap.get(name.trim()) : null;
                        if (typeName == null) {
                            typeName = "string";
                        }
                        recordFieldBuilder.setDataType(typeName);
                    }
                    recordFieldBuilder.add();
                }
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
    }

    public static class RecordSubTypeGroupDefinitionBuilder<T1 extends FileDescriptorBuilder, T2 extends RecordSubTypeGroupDefinitionBuilder>
    extends FileDescriptorRecordBuilder<T1, T2> {
        private int subKeyFieldStart = 0;
        private int subKeyFieldEnd = 0;
        private List<FileDescriptorRecord> subRecords = new ArrayList<FileDescriptorRecord>();

        private RecordSubTypeGroupDefinitionBuilder(FileDescriptorBuilder<T1> descriptorBuilder) {
            super(descriptorBuilder);
        }

        @Override
        public FileDescriptorRecord build() {
            RecordSubTypeGroupDefinition record = new RecordSubTypeGroupDefinition();
            this.doBuild(record);
            return record;
        }

        @Override
        protected void doBuild(FileDescriptorRecord record) {
            super.doBuild(record);
            ((RecordSubTypeGroupDefinition)record).setSubKeyFieldStart(this.subKeyFieldStart);
            ((RecordSubTypeGroupDefinition)record).setSubKeyFieldEnd(this.subKeyFieldEnd);
            ((RecordSubTypeGroupDefinition)record).setSubTypeRecords(this.subRecords);
        }

        public T2 setSubKeyFieldStart(int subKeyFieldStart) {
            this.subKeyFieldStart = subKeyFieldStart;
            return (T2)this;
        }

        public T2 setSubKeyFieldEnd(int subKeyFieldEnd) {
            this.subKeyFieldEnd = subKeyFieldEnd;
            return (T2)this;
        }

        public T2 addRecord(FileDescriptorRecord record) {
            this.subRecords.add(record);
            return (T2)this;
        }
    }

    public static class UntypedRecordTypeDefinitionBuilder<T1 extends FileDescriptorBuilder, T2 extends UntypedRecordTypeDefinitionBuilder>
    extends AbstractRecordTypeDefinitionBuilder<T1, T2> {
        private UntypedRecordTypeDefinitionBuilder(FileDescriptorBuilder<T1> descriptorBuilder) {
            super(descriptorBuilder);
        }

        @Override
        public FileDescriptorRecord build() {
            UntypedRecordTypeDefinition record = new UntypedRecordTypeDefinition();
            this.doBuild(record);
            return record;
        }

        @Override
        protected void doBuild(FileDescriptorRecord record) {
            super.doBuild(record);
        }

        @Override
        public RecordFieldBuilder<T1, T2> recordField() {
            return new RecordFieldBuilder(this);
        }
    }

    public static class RecordTypeDefinitionBuilder<T1 extends FileDescriptorBuilder, T2 extends RecordTypeDefinitionBuilder>
    extends AbstractRecordTypeDefinitionBuilder<T1, T2> {
        private String eventId = "";
        private String semanticType = "";

        private RecordTypeDefinitionBuilder(FileDescriptorBuilder<T1> descriptorBuilder) {
            super(descriptorBuilder);
        }

        @Override
        public FileDescriptorRecord build() {
            RecordTypeDefinition record = new RecordTypeDefinition();
            this.doBuild(record);
            return record;
        }

        @Override
        protected void doBuild(FileDescriptorRecord record) {
            super.doBuild(record);
            ((RecordTypeDefinition)record).setEventId(this.eventId);
            ((RecordTypeDefinition)record).setSemanticType(this.semanticType);
        }

        @Override
        public RecordFieldBuilder<T1, T2> recordField() {
            return new RecordFieldBuilder(this);
        }

        public T2 setEventId(String eventId) {
            this.eventId = eventId;
            return (T2)this;
        }

        public T2 setSemanticType(String semanticType) {
            this.semanticType = semanticType;
            return (T2)this;
        }
    }

    public static abstract class AbstractRecordTypeDefinitionBuilder<T1 extends FileDescriptorBuilder, T2 extends AbstractRecordTypeDefinitionBuilder>
    extends FileDescriptorRecordBuilder<T1, T2> {
        private String description = "";
        private List<RecordField> fields = new ArrayList<RecordField>();

        private AbstractRecordTypeDefinitionBuilder(FileDescriptorBuilder<T1> descriptorBuilder) {
            super(descriptorBuilder);
        }

        @Override
        protected void doBuild(FileDescriptorRecord record) {
            super.doBuild(record);
            ((AbstractRecordTypeDefinition)record).setDescription(this.description);
            ((AbstractRecordTypeDefinition)record).setFields(this.fields);
        }

        public RecordFieldBuilder<T1, T2> recordField() {
            return new RecordFieldBuilder(this);
        }

        public T2 setDescription(String description) {
            this.description = description;
            return (T2)this;
        }

        public T2 addRecordField(RecordField field) {
            this.fields.add(field);
            return (T2)this;
        }
    }

    public static abstract class FileDescriptorRecordBuilder<T1 extends FileDescriptorBuilder, T2 extends FileDescriptorRecordBuilder> {
        protected FileDescriptorBuilder<T1> descriptorBuilder;
        private String typeName = "";
        private String typeKey = "";

        private FileDescriptorRecordBuilder(FileDescriptorBuilder<T1> descriptorBuilder) {
            this.descriptorBuilder = descriptorBuilder;
        }

        public abstract FileDescriptorRecord build();

        protected void doBuild(FileDescriptorRecord record) {
            record.setTypeName(this.typeName);
            record.setTypeKey(this.typeKey);
        }

        public T2 setTypeName(String typeName) {
            this.typeName = typeName;
            return (T2)this;
        }

        public T2 setTypeKey(String typeKey) {
            this.typeKey = typeKey;
            return (T2)this;
        }
    }

    public static class AbstractPositionalRecordFileDescriptorBuilder<T extends FileDescriptorBuilder>
    extends FileDescriptorBuilder<T> {
        private int keyFieldStart = 0;
        private int keyFieldEnd = 0;
        private String recordGroupKey = "";
        private Map<String, String> recordGroupAnnotations;

        private AbstractPositionalRecordFileDescriptorBuilder(FileFormat fileFormat) {
            super(fileFormat);
        }

        public T setKeyFieldStart(int keyFieldStart) {
            this.keyFieldStart = keyFieldStart;
            return (T)this;
        }

        public T setKeyFieldEnd(int keyFieldEnd) {
            this.keyFieldEnd = keyFieldEnd;
            return (T)this;
        }

        public T setRecordGroupKey(String recordGroupKey) {
            this.recordGroupKey = recordGroupKey;
            return (T)this;
        }

        public T setRecordGroupAnnotations(Map<String, String> recordGroupAnnotations) {
            this.recordGroupAnnotations = recordGroupAnnotations;
            return (T)this;
        }

        public T addRecordGroupAnnotation(String propertyName, String spath) {
            if (this.recordGroupAnnotations == null) {
                this.recordGroupAnnotations = new HashMap<String, String>();
            }
            this.recordGroupAnnotations.put(propertyName, spath);
            return (T)this;
        }

        public RecordSubTypeGroupDefinitionBuilderForDescriptor<T> recordSubTypeGroupDefinition() {
            return new RecordSubTypeGroupDefinitionBuilderForDescriptor(this);
        }

        @Override
        protected void doBuild(FileDescriptor descriptor) {
            descriptor.setKeyFieldStart(this.keyFieldStart);
            descriptor.setKeyFieldEnd(this.keyFieldEnd);
            descriptor.setRecordGroupKey(this.recordGroupKey);
            descriptor.setRecordGroupAnnotations(this.recordGroupAnnotations);
        }
    }

    public static abstract class AbstractDelimitedFileDescriptorBuilder<T extends AbstractDelimitedFileDescriptorBuilder>
    extends FileDescriptorBuilder<T> {
        private AbstractDelimitedFileDescriptorBuilder(FileFormat fileFormat) {
            super(fileFormat);
        }
    }
}

