/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.FileFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class FileDescriptor {
    public static String FILE_DESCRIPTOR_OBJECTS_NAMESPACE = "/file/descriptor";
    private FileFormat fileFormat = FileFormat.DELIMITED;
    private boolean skipFirstLine = false;
    private int startAtLine = 0;
    private int endAtLine = 0;
    private String description = "";
    private String delimiter = "";
    private char quoteSymbol = '\u0000';
    private char quoteEscapeSymbol = '\u0000';
    private boolean ignoreInnerQuotes = false;
    private boolean allQuoted = false;
    private String encoding = "";
    private boolean autotrimWhitespaces = true;
    private String nullIndicator = "";
    private String linesDelimiter = "";
    private int keyFieldStart = 0;
    private int keyFieldEnd = 0;
    private String regexp;
    private transient Pattern regexpPattern;
    private String recordGroupKey = "";
    private Map<String, String> recordGroupAnnotations;
    private List<FileDescriptorRecord> records = new ArrayList<FileDescriptorRecord>();
    private boolean isSystem = false;

    public boolean hasGroupKey() {
        return !this.recordGroupKey.equals("");
    }

    public boolean hasKey() {
        return this.keyFieldStart != 0 || this.keyFieldEnd != 0;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public char getQuoteSymbol() {
        return this.quoteSymbol;
    }

    public void setQuoteSymbol(char quoteSymbol) {
        this.quoteSymbol = quoteSymbol;
    }

    public boolean isQuoteSymbolSet() {
        return FileDescriptor.isQuoteSymbolSet(this.quoteSymbol);
    }

    public char getQuoteEscapeSymbol() {
        return this.quoteEscapeSymbol;
    }

    public void setQuoteEscapeSymbol(char quoteEscapeSymbol) {
        this.quoteEscapeSymbol = quoteEscapeSymbol;
    }

    public boolean isQuoteEscapeSymbolSet() {
        return FileDescriptor.isQuoteSymbolSet(this.quoteEscapeSymbol);
    }

    public static boolean isQuoteSymbolSet(char symbol) {
        return symbol != '\u0000' && symbol != ' ';
    }

    public boolean isIgnoreInnerQuotes() {
        return this.ignoreInnerQuotes;
    }

    public FileDescriptor setIgnoreInnerQuotes(boolean ignoreInnerQuotes) {
        this.ignoreInnerQuotes = ignoreInnerQuotes;
        return this;
    }

    public void setSkipFirstLine(boolean skipFirstLine) {
        this.skipFirstLine = skipFirstLine;
    }

    public boolean isSkipFirstLine() {
        return this.skipFirstLine;
    }

    public int getStartAtLine() {
        return this.startAtLine;
    }

    public void setStartAtLine(int startAtLine) {
        this.startAtLine = startAtLine;
    }

    public int getEndAtLine() {
        return this.endAtLine;
    }

    public void setEndAtLine(int endAtLine) {
        this.endAtLine = endAtLine;
    }

    public int getSkipLinesCount() {
        if (this.startAtLine > 0) {
            return this.startAtLine - 1;
        }
        if (this.skipFirstLine) {
            return 1;
        }
        return 0;
    }

    public int getKeyFieldStart() {
        return this.keyFieldStart;
    }

    public void setKeyFieldStart(int keyFieldStart) {
        this.keyFieldStart = keyFieldStart;
    }

    public int getKeyFieldEnd() {
        return this.keyFieldEnd;
    }

    public void setKeyFieldEnd(int keyFieldEnd) {
        this.keyFieldEnd = keyFieldEnd;
    }

    public String getRecordGroupKey() {
        return this.recordGroupKey;
    }

    public void setRecordGroupKey(String recordGroupKey) {
        this.recordGroupKey = recordGroupKey;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public List<FileDescriptorRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<FileDescriptorRecord> records) {
        HashSet<String> keys = new HashSet<String>();
        for (FileDescriptorRecord record : records) {
            if (keys.add(record.getTypeKey())) continue;
            throw new IllegalArgumentException("Record list contain duplicate records for type key '" + record.getTypeKey() + "'.");
        }
        this.records = records;
    }

    public void addRecord(int index, FileDescriptorRecord record) {
        for (FileDescriptorRecord temp : this.records) {
            if (!Objects.equals(temp.getTypeKey(), record.getTypeKey())) continue;
            throw new IllegalArgumentException("File descriptor already contain record for type key '" + record.getTypeKey() + "'.");
        }
        this.records.add(index, record);
    }

    public void addRecord(FileDescriptorRecord record) {
        for (FileDescriptorRecord temp : this.records) {
            if (!Objects.equals(temp.getTypeKey(), record.getTypeKey())) continue;
            throw new IllegalArgumentException("File descriptor already contain record for type key '" + record.getTypeKey() + "'.");
        }
        this.records.add(record);
    }

    public FileDescriptorRecord getRecord(String typeKey) {
        return this.records.stream().filter(r -> {
            String k = r.getTypeKey();
            if (k == null) {
                k = "";
            }
            return k.equals(typeKey == null ? "" : typeKey);
        }).findFirst().orElse(null);
    }

    public void removeRecord(int index) {
        this.records.remove(index);
    }

    public Map<String, String> getRecordGroupAnnotations() {
        return this.recordGroupAnnotations;
    }

    public void setRecordGroupAnnotations(Map<String, String> recordGroupAnnotations) {
        this.recordGroupAnnotations = recordGroupAnnotations;
    }

    public void addRecordGroupAnnotation(String propertyName, String spath) {
        if (this.recordGroupAnnotations == null) {
            this.recordGroupAnnotations = new HashMap<String, String>();
        }
        this.recordGroupAnnotations.put(propertyName, spath);
    }

    public void removeRecord(String key) {
        Iterator<FileDescriptorRecord> it = this.records.iterator();
        while (it.hasNext()) {
            if (!Objects.equals(it.next().getTypeKey(), key)) continue;
            it.remove();
            break;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isAutotrimWhitespaces() {
        return this.autotrimWhitespaces;
    }

    public void setAutotrimWhitespaces(boolean autotrimWhitespaces) {
        this.autotrimWhitespaces = autotrimWhitespaces;
    }

    public String getNullIndicator() {
        return this.nullIndicator;
    }

    public void setNullIndicator(String nullIndicator) {
        this.nullIndicator = nullIndicator;
    }

    public boolean isAllQuoted() {
        return this.allQuoted;
    }

    public void setAllQuoted(boolean allQuoted) {
        this.allQuoted = allQuoted;
    }

    public String getLinesDelimiter() {
        return this.linesDelimiter;
    }

    public String getUnescapedLinesDelimiter() {
        return FileDescriptor.unescapedDelimiter(this.linesDelimiter);
    }

    public void setLinesDelimiter(String linesDelimiter) {
        this.linesDelimiter = linesDelimiter;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public void setIsSystem(boolean isSystem) {
        this.isSystem = isSystem;
    }

    public static String unescapedDelimiter(String delimiter) {
        if (delimiter == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < delimiter.length(); ++i) {
            int c = delimiter.charAt(i);
            if (c == 92 && i < delimiter.length() - 1) {
                if ((c = delimiter.charAt(++i)) == 110) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c >= 48 && c <= 57) {
                    c = (char)(c - 48);
                } else {
                    builder.append('\\');
                }
            }
            builder.append((char)c);
        }
        return builder.toString();
    }

    public void setRegexpPattern(Pattern regexpPattern) {
        this.regexpPattern = regexpPattern;
    }

    public Pattern getRegexpPattern() {
        return this.regexpPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileDescriptor)) {
            return false;
        }
        FileDescriptor that = (FileDescriptor)o;
        return this.skipFirstLine == that.skipFirstLine && this.startAtLine == that.startAtLine && this.endAtLine == that.endAtLine && this.quoteSymbol == that.quoteSymbol && this.quoteEscapeSymbol == that.quoteEscapeSymbol && this.ignoreInnerQuotes == that.ignoreInnerQuotes && this.allQuoted == that.allQuoted && this.autotrimWhitespaces == that.autotrimWhitespaces && this.keyFieldStart == that.keyFieldStart && this.keyFieldEnd == that.keyFieldEnd && this.isSystem == that.isSystem && this.fileFormat == that.fileFormat && Objects.equals(this.description, that.description) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.encoding, that.encoding) && Objects.equals(this.nullIndicator, that.nullIndicator) && Objects.equals(this.linesDelimiter, that.linesDelimiter) && Objects.equals(this.regexp, that.regexp) && Objects.equals(this.recordGroupKey, that.recordGroupKey) && Objects.equals(this.recordGroupAnnotations, that.recordGroupAnnotations) && Objects.equals(this.records, that.records);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileFormat, this.skipFirstLine, this.startAtLine, this.endAtLine, this.description, this.delimiter, Character.valueOf(this.quoteSymbol), Character.valueOf(this.quoteEscapeSymbol), this.ignoreInnerQuotes, this.allQuoted, this.encoding, this.autotrimWhitespaces, this.nullIndicator, this.linesDelimiter, this.keyFieldStart, this.keyFieldEnd, this.regexp, this.regexpPattern, this.recordGroupKey, this.recordGroupAnnotations, this.records, this.isSystem});
    }
}

