/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.OneRecordReader;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.utils.Pair;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DelimitedRegexpOneRecordReader
extends OneRecordReader {
    private final Integer minStartIndex;
    private final Integer maxEndIndex;
    private AbstractRecordTypeDefinition record;

    DelimitedRegexpOneRecordReader(FileDescriptorFactory factory) {
        super(factory);
        this.record = (AbstractRecordTypeDefinition)factory.getFileDescriptor().getRecords().get(0);
        this.minStartIndex = this.record.getFields().stream().map(f -> f.getStart()).min(Integer::compareTo).get();
        this.maxEndIndex = this.record.getFields().stream().map(f -> f.getEnd()).max(Integer::compareTo).get();
    }

    @Override
    protected Pair<Object, AbstractRecordTypeDefinition> doReadRecord(String recordLine) throws FileDescriptorFactory.FileDescriptorProcessingException {
        Object recordObject = this.processRecordTypeDefinition(recordLine);
        if (this.recordListener != null) {
            this.recordListener.onRecord(recordObject, this.record);
        }
        return new Pair<Object, AbstractRecordTypeDefinition>(recordObject, this.record);
    }

    private Object processRecordTypeDefinition(String recordLine) throws FileDescriptorFactory.FileDescriptorProcessingException {
        Object recordObject = this.createRecordObject(this.record);
        DelimitedRegexpRecordLineFieldsReader reader = new DelimitedRegexpRecordLineFieldsReader(recordLine, this.fileDescriptor.getRegexpPattern());
        if (this.minStartIndex > reader.getFieldsCount() || this.maxEndIndex > reader.getFieldsCount()) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Invalid fields count. Expected at least " + this.maxEndIndex + ", but passed at least " + reader.getFieldsCount() + ".", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        }
        for (RecordField field : this.record.getFields()) {
            String fieldValue = null;
            StringBuilder fieldValueBuilder = null;
            for (int i = field.getStart(); i <= field.getEnd(); ++i) {
                if (fieldValueBuilder != null) {
                    fieldValueBuilder.append(" ").append(reader.getFieldValue(i));
                    continue;
                }
                if (fieldValue == null) {
                    fieldValue = reader.getFieldValue(i);
                    continue;
                }
                fieldValueBuilder = new StringBuilder();
                fieldValueBuilder.append(fieldValue).append(" ").append(reader.getFieldValue(i));
                fieldValue = null;
            }
            if (fieldValueBuilder != null) {
                fieldValue = fieldValueBuilder.toString();
            }
            String nullIndicator = this.fileDescriptor.getNullIndicator();
            if (field.getNullIndicator() != null) {
                nullIndicator = field.getNullIndicator();
            }
            if (fieldValue != null) {
                if (fieldValue.length() == 0) {
                    if (field.isNullable()) {
                        fieldValue = null;
                    } else if (field.getDefaultValue() != null && field.getDefaultValue().length() > 0) {
                        fieldValue = field.getDefaultValue();
                    } else {
                        throw new FileDescriptorFactory.FileDescriptorProcessingException("Empty value is passed for not nullable field '" + field.getFieldName() + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                    }
                }
                if (fieldValue != null && nullIndicator != null && nullIndicator.length() > 0 && fieldValue.equals(nullIndicator)) {
                    if (!field.isNullable()) {
                        throw new FileDescriptorFactory.FileDescriptorProcessingException("Null value '" + fieldValue + "' is passed for not nullable field '" + field.getFieldName() + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                    }
                    fieldValue = null;
                    if (field.getDefaultValue() != null && field.getDefaultValue().length() > 0) {
                        fieldValue = field.getDefaultValue();
                    }
                }
                if (fieldValue != null && (field.getAutotrimWhitespaces() != null && field.getAutotrimWhitespaces().booleanValue() || field.getAutotrimWhitespaces() == null && this.fileDescriptor.isAutotrimWhitespaces())) {
                    fieldValue = fieldValue.trim();
                }
            }
            this.setRecordObjectValueForField(recordObject, field, fieldValue, this.record);
        }
        return recordObject;
    }

    public static class DelimitedRegexpRecordLineFieldsReader {
        private final Matcher matcher;

        public DelimitedRegexpRecordLineFieldsReader(String recordLine, Pattern regexpPatterm) throws FileDescriptorFactory.FileDescriptorProcessingException {
            this.matcher = regexpPatterm.matcher(recordLine);
            if (!this.matcher.matches()) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Line doesn't match to regular expression.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
        }

        public int getFieldsCount() {
            return this.matcher.groupCount();
        }

        public String getFieldValue(int index) {
            return this.matcher.group(index);
        }
    }
}

