/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.OneRecordWriter;
import com.streamscape.lib.file.RecordField;
import java.math.BigDecimal;
import java.util.List;

public class DelimitedOneRecordWriter
extends OneRecordWriter {
    DelimitedOneRecordWriter(FileDescriptorFactory factory) {
        super(factory);
    }

    @Override
    public String writeRecord(String recordKey, Object recordObject) throws FileDescriptorFactory.FileDescriptorProcessingException {
        FileDescriptorRecord record = this.validateRecordForWrite(recordKey, recordObject);
        StringBuilder builder = new StringBuilder();
        List<RecordField> fields = ((AbstractRecordTypeDefinition)record).getFields();
        if (recordObject == null && fields.size() > 0) {
            builder.append("");
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                RecordField field = fields.get(i);
                if (field.getClass() != RecordField.class) {
                    throw new FileDescriptorFactory.FileDescriptorProcessingException("Only simple record type field are allowed for write.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                }
                Object value = this.getFieldValueAndFormat(field, recordObject, i);
                this.write(builder, value);
                if (i == fields.size() - 1) continue;
                builder.append(this.factory.getFileDescriptor().getDelimiter());
            }
        }
        return builder.toString();
    }

    @Override
    public String writeGroupRecord(String recordGroupKey, String recordKey, Object recordObject) throws FileDescriptorFactory.FileDescriptorProcessingException {
        throw new FileDescriptorFactory.FileDescriptorProcessingException("Writing of group record not supported for delimited files.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
    }

    @Override
    public String writeRecordFields(FileDescriptorRecord record, Object ... recordFields) throws FileDescriptorFactory.FileDescriptorProcessingException {
        StringBuilder builder = new StringBuilder();
        if (!(record instanceof AbstractRecordTypeDefinition)) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Only record type definitions are allowed for write.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        }
        AbstractRecordTypeDefinition recordDefinition = (AbstractRecordTypeDefinition)record;
        if (recordFields != null || recordDefinition.getFields().size() <= 0) {
            if (recordDefinition.getFields().size() != recordFields.length) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Record fields size mismatch. Expected '" + recordDefinition.getFields().size() + "' but passed '" + recordFields.length + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
            List<RecordField> fields = recordDefinition.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                RecordField field = fields.get(i);
                if (field.getClass() != RecordField.class) {
                    throw new FileDescriptorFactory.FileDescriptorProcessingException("Only simple record type field are allowed for write.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                }
                Object value = this.formatFieldValue(field, recordFields[i]);
                this.write(builder, value);
                if (i == fields.size() - 1) continue;
                builder.append(this.factory.getFileDescriptor().getDelimiter());
            }
        }
        return builder.toString();
    }

    private void write(StringBuilder builder, Object value) throws FileDescriptorFactory.FileDescriptorProcessingException {
        boolean needQuotes;
        if (value == null) {
            value = "";
        }
        String svalue = "";
        svalue = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : value.toString();
        boolean containsDelimiter = false;
        boolean containsNewLine = false;
        boolean containsSpace = false;
        boolean containsQuote = false;
        String delimiter = this.factory.getFileDescriptor().getDelimiter();
        if (!this.factory.getFileDescriptor().isAllQuoted() || this.factory.getFileDescriptor().isQuoteSymbolSet()) {
            for (int i = 0; i < svalue.length(); ++i) {
                char c = svalue.charAt(i);
                if (c == '\n') {
                    containsNewLine = true;
                } else if (c == ' ') {
                    containsSpace = true;
                } else if (c == this.factory.getFileDescriptor().getQuoteSymbol()) {
                    containsQuote = true;
                }
                if (delimiter.charAt(0) == c) {
                    if (delimiter.length() == 1) {
                        containsDelimiter = true;
                    } else if (svalue.length() - i >= delimiter.length() && svalue.substring(i, i + delimiter.length()).equals(delimiter)) {
                        containsDelimiter = true;
                    }
                }
                if (containsDelimiter && (containsNewLine || containsSpace) && containsQuote) break;
            }
        }
        boolean bl = needQuotes = this.factory.getFileDescriptor().isAllQuoted() || containsDelimiter || containsNewLine || containsQuote || containsSpace;
        if (this.factory.getFileDescriptor().isQuoteSymbolSet()) {
            if (needQuotes && svalue.length() > 0) {
                builder.append(this.factory.getFileDescriptor().getQuoteSymbol());
                if (containsQuote) {
                    if (!this.factory.getFileDescriptor().isQuoteEscapeSymbolSet()) {
                        throw new FileDescriptorFactory.FileDescriptorProcessingException("Cannot write value with quote(" + this.factory.getFileDescriptor().getQuoteSymbol() + ") when quote escape symbol not set.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                    }
                    this.writeEscapedValues(builder, svalue, this.factory.getFileDescriptor().getQuoteSymbol(), this.factory.getFileDescriptor().getQuoteEscapeSymbol());
                } else {
                    builder.append(svalue);
                }
                builder.append(this.factory.getFileDescriptor().getQuoteSymbol());
            } else {
                builder.append(svalue);
            }
        } else {
            if (containsDelimiter) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Cannot write value with delimiter(" + this.factory.getFileDescriptor().getDelimiter() + ") inside field value when quote symbol not set.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
            if (containsNewLine) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Cannot write value with new line symbol inside field value when quote symbol not set.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
            builder.append(svalue);
        }
    }

    private void writeEscapedValues(StringBuilder builder, String svalue, char quoteSymbol, char quoteEscapeSymbol) {
        for (int i = 0; i < svalue.length(); ++i) {
            char c = svalue.charAt(i);
            if (c == quoteSymbol) {
                builder.append(quoteEscapeSymbol);
            }
            builder.append(c);
        }
    }
}

