/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.OneRecordReader;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.utils.Pair;

public class DelimitedOneRecordReader
extends OneRecordReader {
    private AbstractRecordTypeDefinition record;

    DelimitedOneRecordReader(FileDescriptorFactory factory) {
        super(factory);
        this.record = (AbstractRecordTypeDefinition)factory.getFileDescriptor().getRecords().get(0);
    }

    @Override
    protected Pair<Object, AbstractRecordTypeDefinition> doReadRecord(String recordLine) throws FileDescriptorFactory.FileDescriptorProcessingException {
        Object recordObject = this.processRecordTypeDefinition(recordLine);
        if (this.recordListener != null) {
            this.recordListener.onRecord(recordObject, this.record);
        }
        return new Pair<Object, AbstractRecordTypeDefinition>(recordObject, this.record);
    }

    private Object processRecordTypeDefinition(String recordLine) throws FileDescriptorFactory.FileDescriptorProcessingException {
        Object recordObject = this.createRecordObject(this.record);
        DelimitedRecordLineFieldsReader reader = new DelimitedRecordLineFieldsReader(recordLine, this.fileDescriptor.getDelimiter());
        reader.setQuoteSymbol(this.fileDescriptor.getQuoteSymbol());
        reader.setQuoteEscapeSymbol(this.fileDescriptor.getQuoteEscapeSymbol());
        reader.setIgnoreInnerQuotes(this.fileDescriptor.isIgnoreInnerQuotes());
        reader.setAutotrimWhitespaces(false);
        int fieldsCount = 0;
        while (reader.hasNext()) {
            String fieldValue = reader.current();
            if (fieldsCount >= this.record.getFields().size()) {
                throw new FileDescriptorFactory.FileDescriptorProcessingException("Invalid fields count. Expected " + this.record.getFields().size() + ", but passed at least " + (fieldsCount + 1) + ".", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
            }
            RecordField field = this.record.getFields().get(fieldsCount);
            String nullIndicator = this.fileDescriptor.getNullIndicator();
            if (field.getNullIndicator() != null) {
                nullIndicator = field.getNullIndicator();
            }
            if (fieldValue != null && !reader.isCurrentQuoted()) {
                if (fieldValue.length() == 0) {
                    if (field.isNullable()) {
                        fieldValue = null;
                    } else if (field.getDefaultValue() != null && field.getDefaultValue().length() > 0) {
                        fieldValue = field.getDefaultValue();
                    } else {
                        throw new FileDescriptorFactory.FileDescriptorProcessingException("Empty value is passed for not nullable field '" + field.getFieldName() + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                    }
                }
                if (fieldValue != null && nullIndicator != null && nullIndicator.length() > 0 && fieldValue.equals(nullIndicator)) {
                    if (!field.isNullable()) {
                        throw new FileDescriptorFactory.FileDescriptorProcessingException("Null value '" + fieldValue + "' is passed for not nullable field '" + field.getFieldName() + "'.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                    }
                    fieldValue = null;
                    if (field.getDefaultValue() != null && field.getDefaultValue().length() > 0) {
                        fieldValue = field.getDefaultValue();
                    }
                }
                if (fieldValue != null && (reader.isAutotrimWhitespaces() || field.getAutotrimWhitespaces() != null && field.getAutotrimWhitespaces().booleanValue() || field.getAutotrimWhitespaces() == null && this.fileDescriptor.isAutotrimWhitespaces())) {
                    fieldValue = fieldValue.trim();
                }
            }
            this.setRecordObjectValueForField(recordObject, field, fieldValue, this.record);
            ++fieldsCount;
        }
        if (fieldsCount != this.record.getFields().size()) {
            throw new FileDescriptorFactory.FileDescriptorProcessingException("Fields count mismatch. Expected " + this.record.getFields().size() + ", but passed " + fieldsCount + ".", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
        }
        return recordObject;
    }

    public static class DelimitedRecordLineFieldsReader {
        private String delimiter;
        private char quoteSymbol;
        private char quoteEscapeSymbol;
        private boolean ignoreInnerQuotes;
        private String recordLine;
        private int pos = 0;
        private String next = null;
        private boolean isNextQuoted = false;
        private DelimiterRingBuffer delimiterRing;
        private int fieldsCounter = 0;
        private boolean lastEndOnDelimiter = false;
        private boolean autotrimWhitespaces = false;
        private boolean allQuoted = true;

        public DelimitedRecordLineFieldsReader(String recordLine, String delimiter) {
            this.recordLine = recordLine;
            this.delimiter = delimiter;
            this.delimiterRing = new DelimiterRingBuffer(delimiter);
            if (!this.autotrimWhitespaces) {
                int i;
                for (i = recordLine.length(); i > 0 && (recordLine.charAt(i - 1) == '\n' || recordLine.charAt(i - 1) == '\r'); --i) {
                }
                this.recordLine = recordLine.substring(0, i);
            }
        }

        public boolean isAutotrimWhitespaces() {
            return this.autotrimWhitespaces;
        }

        public void setAutotrimWhitespaces(boolean autotrimWhitespaces) {
            this.autotrimWhitespaces = autotrimWhitespaces;
        }

        public char getQuoteSymbol() {
            return this.quoteSymbol;
        }

        public void setQuoteSymbol(char quoteSymbol) {
            this.quoteSymbol = quoteSymbol;
        }

        public char getQuoteEscapeSymbol() {
            return this.quoteEscapeSymbol;
        }

        public void setQuoteEscapeSymbol(char quoteEscapeSymbol) {
            this.quoteEscapeSymbol = quoteEscapeSymbol;
        }

        public DelimitedRecordLineFieldsReader setIgnoreInnerQuotes(boolean ignoreInnerQuotes) {
            this.ignoreInnerQuotes = ignoreInnerQuotes;
            return this;
        }

        public boolean hasNext() throws FileDescriptorFactory.FileDescriptorProcessingException {
            this.next = null;
            this.isNextQuoted = false;
            int startPos = this.pos;
            this.skipWhitespaces(this.delimiterRing);
            if (this.pos == this.recordLine.length()) {
                if (this.lastEndOnDelimiter) {
                    this.lastEndOnDelimiter = false;
                    this.next = startPos < this.pos && !this.autotrimWhitespaces ? this.recordLine.substring(startPos, this.pos) : "";
                    return true;
                }
                return false;
            }
            int startPosAfterSpaces = this.autotrimWhitespaces ? startPos : this.pos;
            this.lastEndOnDelimiter = false;
            int closeQuotePos = -1;
            if (FileDescriptor.isQuoteSymbolSet(this.getQuoteSymbol())) {
                StringBuilder builder = new StringBuilder();
                boolean insideQuotes = false;
                this.delimiterRing.reset();
                while (this.pos < this.recordLine.length()) {
                    char c = this.recordLine.charAt(this.pos++);
                    if (FileDescriptor.isQuoteSymbolSet(this.getQuoteEscapeSymbol()) && c == this.getQuoteEscapeSymbol() && (insideQuotes || builder.length() > 0 || startPosAfterSpaces != this.pos - 1) && this.pos < this.recordLine.length() && this.recordLine.charAt(this.pos) == this.getQuoteSymbol()) {
                        if (startPos < this.pos - 1) {
                            builder.append(this.recordLine, startPos, this.pos - 1);
                        }
                        builder.append(this.getQuoteSymbol());
                        startPos = ++this.pos;
                        this.delimiterRing.reset();
                        continue;
                    }
                    if (c == this.getQuoteSymbol()) {
                        if (this.ignoreInnerQuotes) {
                            if (insideQuotes) {
                                boolean endOfValue = false;
                                if (this.allQuoted) {
                                    if (this.pos == this.recordLine.length()) {
                                        endOfValue = true;
                                    } else if (this.pos + this.delimiter.length() + 1 - 1 < this.recordLine.length() && this.recordLine.substring(this.pos, this.pos + this.delimiter.length() + 1).equals(this.delimiter + this.quoteSymbol)) {
                                        endOfValue = true;
                                    } else if (this.pos + 2 * this.delimiter.length() - 1 < this.recordLine.length() && this.recordLine.substring(this.pos, this.pos + 2 * this.delimiter.length()).equals(this.delimiter + this.delimiter)) {
                                        endOfValue = true;
                                    }
                                } else {
                                    endOfValue = true;
                                }
                                if (endOfValue) {
                                    insideQuotes = false;
                                    if (startPos < this.pos - 1) {
                                        builder.append(this.recordLine, startPos, this.pos - 1);
                                    }
                                    this.skipWhitespaces(this.delimiterRing);
                                    startPos = this.pos;
                                    closeQuotePos = this.pos;
                                }
                            } else if (builder.length() == 0 && startPosAfterSpaces == this.pos - 1) {
                                startPos = startPosAfterSpaces;
                                insideQuotes = true;
                                ++startPos;
                            }
                            this.delimiterRing.reset();
                            continue;
                        }
                        if (insideQuotes) {
                            insideQuotes = false;
                            if (startPos < this.pos - 1) {
                                builder.append(this.recordLine, startPos, this.pos - 1);
                            }
                            this.skipWhitespaces(this.delimiterRing);
                            startPos = this.pos;
                            closeQuotePos = this.pos;
                        } else if (builder.length() == 0 && startPosAfterSpaces == this.pos - 1) {
                            startPos = startPosAfterSpaces;
                            insideQuotes = true;
                            ++startPos;
                        }
                        this.delimiterRing.reset();
                        continue;
                    }
                    if (insideQuotes) continue;
                    this.delimiterRing.add(c);
                    if (!this.delimiterRing.isDelimiter()) continue;
                    if (closeQuotePos != -1 && closeQuotePos != this.pos - this.delimiterRing.length()) {
                        throw new FileDescriptorFactory.FileDescriptorProcessingException("Invalid field with index [" + (this.fieldsCounter + 1) + "]. If field is in quotes, then delimiter should be right after closing quote.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                    }
                    if (startPos < this.pos - this.delimiterRing.length()) {
                        builder.append(this.recordLine, startPos, this.pos - this.delimiterRing.length());
                        this.allQuoted = false;
                    }
                    startPos = this.pos;
                    this.lastEndOnDelimiter = true;
                    break;
                }
                if (insideQuotes) {
                    throw new FileDescriptorFactory.FileDescriptorProcessingException("Invalid field with index [" + (this.fieldsCounter + 1) + "]. If field is started with quote, it should be ended with quote.", FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED);
                }
                if (startPos < this.pos) {
                    builder.append(this.recordLine, startPos, this.pos);
                }
                this.next = builder.toString();
                if (closeQuotePos == -1) {
                    if (this.autotrimWhitespaces) {
                        this.next = this.next.trim();
                    }
                } else {
                    this.isNextQuoted = true;
                }
            } else {
                this.pos = this.recordLine.indexOf(this.delimiter, this.pos);
                if (this.pos == -1) {
                    this.pos = this.recordLine.length();
                } else {
                    this.lastEndOnDelimiter = true;
                }
                this.next = this.recordLine.substring(startPos, this.pos);
                if (this.autotrimWhitespaces) {
                    this.next = this.next.trim();
                }
                if (this.pos < this.recordLine.length()) {
                    this.pos += this.delimiter.length();
                }
            }
            ++this.fieldsCounter;
            return true;
        }

        public String current() {
            return this.next;
        }

        public boolean isCurrentQuoted() {
            return this.isNextQuoted;
        }

        private void skipWhitespaces(DelimiterRingBuffer delimiter) {
            char c;
            if (delimiter != null) {
                delimiter.reset();
            }
            while (this.pos < this.recordLine.length() && Character.isWhitespace(c = this.recordLine.charAt(this.pos))) {
                if (delimiter != null) {
                    delimiter.add(c);
                    if (delimiter.isDelimiter()) {
                        this.pos -= delimiter.length() - 1;
                        break;
                    }
                }
                ++this.pos;
            }
        }

        public static class DelimiterRingBuffer {
            private String delimiter;
            private int[] buffer;
            private int pos = 0;
            private int length = 0;

            DelimiterRingBuffer(String delimiter) {
                this.delimiter = delimiter;
                this.buffer = new int[delimiter.length()];
            }

            public int length() {
                return this.length;
            }

            public int delimiterLength() {
                return this.delimiter.length();
            }

            void reset() {
                this.pos = 0;
                this.length = 0;
            }

            public void add(int c) {
                int i = this.pos;
                if (this.length == this.buffer.length) {
                    i = this.pos++;
                    if (this.pos == this.buffer.length) {
                        this.pos = 0;
                    }
                } else {
                    i = this.pos + this.length;
                    if (i >= this.buffer.length) {
                        i -= this.buffer.length;
                    }
                    ++this.length;
                }
                this.buffer[i] = c;
            }

            boolean isDelimiter() {
                if (this.length != this.delimiter.length()) {
                    return false;
                }
                int i = this.pos;
                for (int count = 0; count < this.length; ++count) {
                    if (this.buffer[i] != this.delimiter.charAt(count)) {
                        return false;
                    }
                    if (++i < this.buffer.length) continue;
                    i = 0;
                }
                return true;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public int removeFirst() {
                if (this.length == 0) {
                    return -1;
                }
                int c = this.buffer[this.pos];
                ++this.pos;
                if (this.pos == this.buffer.length) {
                    this.pos = 0;
                }
                --this.length;
                return c;
            }
        }
    }
}

