/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.DelimitedOneRecordReader;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileLinesReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class DelimitedFileLinesReader
implements FileLinesReader {
    private InputStream inputStream;
    private char quoteSymbol = '\u0000';
    private char quoteEscapeSymbol = '\u0000';
    private String fieldsDelimiter = null;
    private byte[] fieldsDelimiterBytes = null;
    private boolean fieldsDelimiterContainsWhitespaces = false;
    private DelimitedOneRecordReader.DelimitedRecordLineFieldsReader.DelimiterRingBuffer linesDelimiter = null;
    private String charset;
    private boolean eofIsEndOFLine;
    private long currentPosition = 0L;
    private long currentStartPosition = 0L;
    private int lastSkippedLines;
    private ByteArrayOutputStream currentBytes;
    private int linesDelimiterSizeInBytes;
    private UnhandledCharacters lastUnhandledCharacters = new UnhandledCharacters();
    private long resetMarker;
    private boolean wasCR = false;
    private boolean inQuotes = false;
    private boolean afterQuoteEscapeSymbol = false;
    private boolean lastLineFinished = true;

    public DelimitedFileLinesReader(InputStream inputStream, String charset) {
        this(inputStream, charset, true);
    }

    public DelimitedFileLinesReader(InputStream inputStream, String charset, boolean eofIsEndOFLine) {
        this.inputStream = inputStream;
        if (this.inputStream.markSupported()) {
            if (this.inputStream instanceof BufferedInputStream) {
                this.inputStream.mark(0);
            } else {
                this.inputStream.mark(-1);
            }
        }
        this.currentBytes = new ByteArrayOutputStream();
        this.linesDelimiterSizeInBytes = 0;
        this.charset = charset;
        this.eofIsEndOFLine = eofIsEndOFLine;
    }

    @Override
    public void resetCurrentReads() {
        this.currentBytes = new ByteArrayOutputStream();
        this.linesDelimiterSizeInBytes = 0;
        this.currentPosition = 0L;
        this.currentStartPosition = 0L;
        this.lastUnhandledCharacters.reset();
        this.resetMarker = -1L;
        this.lastLineFinished = true;
        this.wasCR = false;
        this.inQuotes = false;
        this.afterQuoteEscapeSymbol = false;
    }

    public char getQuoteSymbol() {
        return this.quoteSymbol;
    }

    public void setQuoteSymbol(char quoteSymbol) {
        this.quoteSymbol = quoteSymbol;
    }

    public char getQuoteEscapeSymbol() {
        return this.quoteEscapeSymbol;
    }

    public void setQuoteEscapeSymbol(char quoteEscapeSymbol) {
        this.quoteEscapeSymbol = quoteEscapeSymbol;
    }

    public String getFieldsDelimiter() {
        return this.fieldsDelimiter;
    }

    public void setFieldsDelimiter(String fieldsDelimiter) {
        this.fieldsDelimiter = fieldsDelimiter;
        this.fieldsDelimiterBytes = null;
        this.fieldsDelimiterContainsWhitespaces = false;
    }

    public void setLinesDelimiter(String linesDelimiter) {
        this.linesDelimiter = linesDelimiter != null && linesDelimiter.length() > 0 ? new DelimitedOneRecordReader.DelimitedRecordLineFieldsReader.DelimiterRingBuffer(linesDelimiter) : null;
    }

    public String getLinesDelimiter() {
        if (this.linesDelimiter == null) {
            return null;
        }
        return this.linesDelimiter.getDelimiter();
    }

    @Override
    public int getLastSkippedLines() {
        return this.lastSkippedLines;
    }

    @Override
    public long getCurrentStartPositionInBytes() {
        return this.currentStartPosition;
    }

    @Override
    public int getCurrentWithDelimiterLengthBytes() {
        return (int)(this.currentPosition - this.currentStartPosition);
    }

    public int getCurrentLengthBytes() {
        return (int)(this.currentPosition - this.currentStartPosition - (long)this.linesDelimiterSizeInBytes);
    }

    @Override
    public boolean isLastLineFinished() {
        return this.lastLineFinished;
    }

    @Override
    public boolean hasNext(boolean skipWhitespaces) throws IOException {
        this.resetIfNeeded();
        if (this.lastLineFinished) {
            this.currentBytes.reset();
            this.linesDelimiterSizeInBytes = 0;
            if (skipWhitespaces) {
                this.skipWhitespaceLines();
            }
            this.wasCR = false;
            this.inQuotes = false;
            this.afterQuoteEscapeSymbol = false;
            this.currentStartPosition = this.currentPosition - (long)this.currentBytes.size();
        }
        while (true) {
            int c;
            if ((c = this.read()) == -1) {
                if (this.eofIsEndOFLine || this.currentBytes.size() == 0) break;
                this.lastLineFinished = false;
                return false;
            }
            if (this.afterQuoteEscapeSymbol) {
                this.afterQuoteEscapeSymbol = false;
                if (c == this.quoteSymbol) {
                    this.currentBytes.write(c);
                    continue;
                }
                if (this.quoteSymbol == this.quoteEscapeSymbol) {
                    this.inQuotes = false;
                }
            }
            boolean wroteToCurrentBytes = false;
            boolean handled = false;
            if (this.linesDelimiter != null) {
                wroteToCurrentBytes = true;
                if (!this.inQuotes) {
                    this.currentBytes.write(c);
                    this.linesDelimiter.add(c);
                    if (this.linesDelimiter.isDelimiter()) {
                        this.linesDelimiterSizeInBytes = this.linesDelimiter.length();
                        this.linesDelimiter.reset();
                        break;
                    }
                } else {
                    this.currentBytes.write(c);
                }
            } else if (c == 13) {
                handled = true;
                wroteToCurrentBytes = true;
                if (!this.inQuotes) {
                    this.currentBytes.write(c);
                    ++this.linesDelimiterSizeInBytes;
                    this.wasCR = true;
                } else {
                    this.currentBytes.write(c);
                }
            } else if (c == 10) {
                handled = true;
                wroteToCurrentBytes = true;
                if (!this.inQuotes) {
                    this.currentBytes.write(c);
                    ++this.linesDelimiterSizeInBytes;
                    break;
                }
                this.currentBytes.write(c);
            } else {
                wroteToCurrentBytes = false;
                if (this.wasCR) {
                    this.storeLastUnhandledCharacter(c);
                    break;
                }
            }
            if (handled) continue;
            this.linesDelimiterSizeInBytes = 0;
            if (c == this.quoteEscapeSymbol && this.inQuotes && FileDescriptor.isQuoteSymbolSet(this.quoteEscapeSymbol)) {
                this.afterQuoteEscapeSymbol = true;
            } else if (c == this.quoteSymbol && FileDescriptor.isQuoteSymbolSet(this.quoteSymbol)) {
                if (!this.inQuotes && this.fieldsDelimiter != null && this.fieldsDelimiter.length() > 0) {
                    if (this.currentBytesEndsWithDelimiter()) {
                        this.inQuotes = !this.inQuotes;
                    }
                } else {
                    boolean bl = this.inQuotes = !this.inQuotes;
                }
            }
            if (wroteToCurrentBytes) continue;
            this.currentBytes.write(c);
        }
        this.lastLineFinished = true;
        return this.currentBytes.size() > 0;
    }

    @Override
    public String current() {
        if (this.currentBytes.size() == 0) {
            return null;
        }
        if (this.currentBytes.size() == this.linesDelimiterSizeInBytes) {
            return "";
        }
        return this.toStringInternal(this.currentBytes, 0, this.currentBytes.size() - this.linesDelimiterSizeInBytes);
    }

    @Override
    public String currentWithDelimiter() {
        if (this.currentBytes.size() == 0) {
            return null;
        }
        return this.toStringInternal(this.currentBytes, 0, this.currentBytes.size());
    }

    @Override
    public String currentDelimiter() {
        if (this.currentBytes.size() == 0) {
            return null;
        }
        if (this.linesDelimiterSizeInBytes == 0) {
            return "";
        }
        return this.toStringInternal(this.currentBytes, this.currentBytes.size() - this.linesDelimiterSizeInBytes, this.linesDelimiterSizeInBytes);
    }

    private String toStringInternal(ByteArrayOutputStream bytes, final int off, final int len) {
        final String[] result = new String[1];
        try {
            bytes.writeTo(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }

                @Override
                public void write(byte[] b, int off1, int len1) throws IOException {
                    result[0] = DelimitedFileLinesReader.this.toStringInternal(b, off, len);
                }
            });
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return result[0];
    }

    private String toStringInternal(byte[] bytes, int off, int len) {
        try {
            if (this.charset != null && this.charset.length() > 0) {
                return new String(bytes, off, len, this.charset);
            }
            return new String(bytes, off, len);
        }
        catch (Exception exception) {
            return new String(bytes, off, len);
        }
    }

    @Override
    public long resetMark(long resetMarker) throws IOException {
        if (resetMarker != this.currentPosition) {
            this.resetMarker = resetMarker;
            this.currentPosition = resetMarker;
        }
        return resetMarker;
    }

    public long resetIfNeeded() throws IOException {
        if (this.resetMarker != -1L) {
            this.inputStream.reset();
            this.currentPosition = 0L;
            this.currentPosition = this.inputStream.skip(this.resetMarker);
            this.currentPosition = this.resetMarker;
            this.currentStartPosition = 0L;
            this.lastUnhandledCharacters.reset();
            this.resetMarker = -1L;
            this.lastLineFinished = true;
            this.currentBytes.reset();
            this.linesDelimiterSizeInBytes = 0;
            this.wasCR = false;
            this.inQuotes = false;
            this.afterQuoteEscapeSymbol = false;
        }
        return this.currentPosition;
    }

    @Override
    public String readHeaderLines(int lines) throws IOException {
        StringBuilder builder = new StringBuilder();
        while (lines-- > 0 && this.hasNext(false)) {
            builder.append(this.currentWithDelimiter());
        }
        return builder.toString();
    }

    private int skipWhitespaceLines() throws IOException {
        int c;
        this.resetIfNeeded();
        this.lastSkippedLines = 0;
        boolean wasCR = false;
        while ((c = this.read()) != -1) {
            if (this.linesDelimiter != null) {
                this.linesDelimiter.add((char)c);
                if (this.linesDelimiter.isDelimiter()) {
                    ++this.lastSkippedLines;
                    this.linesDelimiter.reset();
                    this.currentBytes.reset();
                    continue;
                }
                if (this.linesDelimiter.length() != this.linesDelimiter.delimiterLength()) continue;
                c = this.linesDelimiter.removeFirst();
                if (!Character.isWhitespace(c)) {
                    this.lastUnhandledCharacters.add(c);
                    while ((c = this.linesDelimiter.removeFirst()) != -1) {
                        this.lastUnhandledCharacters.add(c);
                    }
                    break;
                }
                this.currentBytes.write(c);
                continue;
            }
            if (c == 13) {
                wasCR = true;
                continue;
            }
            if (c == 10) {
                wasCR = false;
                ++this.lastSkippedLines;
                this.currentBytes.reset();
                continue;
            }
            if (wasCR) {
                wasCR = false;
                ++this.lastSkippedLines;
                this.currentBytes.reset();
            }
            if (!Character.isWhitespace(c)) {
                this.storeLastUnhandledCharacter(c);
                break;
            }
            this.currentBytes.write(c);
        }
        return this.lastSkippedLines;
    }

    private int read() throws IOException {
        this.resetIfNeeded();
        int result = this.lastUnhandledCharacters.length() > 0 ? this.lastUnhandledCharacters.removeFirst() : this.inputStream.read();
        if (result != -1) {
            ++this.currentPosition;
        }
        return result;
    }

    private void storeLastUnhandledCharacter(int c) {
        this.lastUnhandledCharacters.add(c);
    }

    private boolean currentBytesEndsWithDelimiter() {
        if (this.fieldsDelimiter == null || this.fieldsDelimiter.length() == 0) {
            return false;
        }
        try {
            if (this.fieldsDelimiterBytes == null) {
                this.fieldsDelimiterBytes = this.charset != null && this.charset.length() > 0 ? this.fieldsDelimiter.getBytes(this.charset) : this.fieldsDelimiter.getBytes();
                this.fieldsDelimiterContainsWhitespaces = false;
                for (char c : this.fieldsDelimiter.toCharArray()) {
                    if (!Character.isWhitespace(c)) continue;
                    this.fieldsDelimiterContainsWhitespaces = true;
                }
            }
            final boolean[] result = new boolean[]{true};
            this.currentBytes.writeTo(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    byte bb;
                    while (len > 0 && Character.isWhitespace(bb = b[off + len - 1])) {
                        if (DelimitedFileLinesReader.this.fieldsDelimiterContainsWhitespaces) {
                            boolean found = false;
                            for (int i = 0; i < DelimitedFileLinesReader.this.fieldsDelimiterBytes.length; ++i) {
                                if (DelimitedFileLinesReader.this.fieldsDelimiterBytes[i] != bb) continue;
                                found = true;
                                break;
                            }
                            if (found) break;
                        }
                        --len;
                    }
                    if (len == 0) {
                        return;
                    }
                    if (len >= DelimitedFileLinesReader.this.fieldsDelimiterBytes.length) {
                        for (int i = 0; i < DelimitedFileLinesReader.this.fieldsDelimiterBytes.length; ++i) {
                            if (b[off + len - i - 1] == DelimitedFileLinesReader.this.fieldsDelimiterBytes[DelimitedFileLinesReader.this.fieldsDelimiterBytes.length - i - 1]) continue;
                            result[0] = false;
                            break;
                        }
                    } else {
                        result[0] = false;
                    }
                }
            });
            return result[0];
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private class UnhandledCharacters {
        private int[] unhandledCharacters;
        private int length = 0;
        private int pos = 0;

        UnhandledCharacters() {
        }

        void add(int c) {
            if (this.unhandledCharacters == null) {
                this.unhandledCharacters = new int[1];
                this.unhandledCharacters[0] = c;
                --DelimitedFileLinesReader.this.currentPosition;
                this.length = 1;
                return;
            }
            if (this.pos + this.length <= this.unhandledCharacters.length) {
                this.unhandledCharacters = Arrays.copyOf(this.unhandledCharacters, this.pos + this.length + 1);
            }
            this.unhandledCharacters[this.pos + this.length] = c;
            ++this.length;
            --DelimitedFileLinesReader.this.currentPosition;
        }

        int length() {
            return this.length;
        }

        public void reset() {
            this.length = 0;
            this.pos = 0;
        }

        public int removeFirst() {
            if (this.length == 0) {
                return -1;
            }
            int c = this.unhandledCharacters[this.pos];
            ++this.pos;
            --this.length;
            if (this.length == 0) {
                this.reset();
            }
            return c;
        }
    }
}

