/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.DelimitedFileLinesReader;
import com.streamscape.lib.file.DelimitedOneRecordReader;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.omf.xsd.AbstractParser;
import com.streamscape.omf.xsd.ComplexType;
import com.streamscape.omf.xsd.EDLType;
import com.streamscape.omf.xsd.Parser;
import com.streamscape.omf.xsd.XsdElement;
import com.streamscape.omf.xsd.XsdException;
import com.streamscape.omf.xsd.XsdSchema;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DelimitedFileHeaderParser
implements Parser {
    private String delimiter;
    private int headerLineNumber = 1;
    private char quoteSymbol = '\u0000';
    private char quoteEscapeSymbol = '\u0000';
    private String sdoName;

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setHeaderLineNumber(int headerLineNumber) {
        this.headerLineNumber = headerLineNumber;
    }

    public void setQuoteSymbol(char quoteSymbol) {
        this.quoteSymbol = quoteSymbol;
    }

    public void setQuoteEscapeSymbol(char quoteEscapeSymbol) {
        this.quoteEscapeSymbol = quoteEscapeSymbol;
    }

    public void setSdoName(String sdoName) {
        this.sdoName = sdoName;
    }

    @Override
    public XsdSchema parse(InputStream input) throws XsdException {
        return this.parse(input, null, null);
    }

    @Override
    public XsdSchema parse(InputStream input, String charset) throws XsdException, UnsupportedEncodingException {
        return this.parse(input, null, null, charset);
    }

    @Override
    public XsdSchema parse(InputStream input, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        return this.onParse(new DelimitedFileLinesReader(input, null), typesMap, aliasesMap);
    }

    @Override
    public XsdSchema parse(InputStream input, Map<String, String> typesMap, Map<String, String> aliasesMap, String charset) throws XsdException, UnsupportedEncodingException {
        return this.onParse(new DelimitedFileLinesReader(input, charset), typesMap, aliasesMap);
    }

    protected XsdSchema onParse(DelimitedFileLinesReader reader, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        try {
            reader.setQuoteSymbol(this.quoteSymbol);
            reader.setQuoteEscapeSymbol(this.quoteEscapeSymbol);
            reader.setFieldsDelimiter(this.delimiter);
            int skipLinesCount = this.headerLineNumber;
            if (skipLinesCount < 0) {
                skipLinesCount = 1;
            }
            String header = null;
            while (skipLinesCount-- > 0) {
                if (!reader.hasNext(false)) {
                    throw new Exception("End of file reached before header line.");
                }
                header = reader.current();
            }
            return this.parseHeader(header, typesMap, aliasesMap);
        }
        catch (Exception exception) {
            throw new XsdException(exception.toString());
        }
    }

    private XsdSchema parseHeader(String header, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        try {
            DelimitedOneRecordReader.DelimitedRecordLineFieldsReader reader = new DelimitedOneRecordReader.DelimitedRecordLineFieldsReader(header, this.delimiter);
            reader.setQuoteSymbol(this.quoteSymbol);
            reader.setQuoteEscapeSymbol(this.quoteEscapeSymbol);
            XsdSchema schema = new XsdSchema();
            ComplexType complexType = new ComplexType(this.sdoName);
            XsdElement element = new XsdElement(this.sdoName);
            element.setType(complexType);
            element.setIsGlobal(true);
            schema.addElement(element);
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            while (reader.hasNext()) {
                String fieldName = DelimitedFileHeaderParser.escapeFieldName(names, reader.current());
                XsdElement fieldElement = new XsdElement(fieldName);
                fieldElement.setAlias(this.resolveAlias(aliasesMap, fieldName));
                String typeName = this.getTypeName(typesMap, fieldName);
                if (typeName == null) {
                    typeName = "string";
                }
                fieldElement.setType(EDLType.createType(typeName));
                fieldElement.setIsGlobal(false);
                complexType.addElement(fieldElement);
            }
            return schema;
        }
        catch (FileDescriptorFactory.FileDescriptorProcessingException exception) {
            throw new XsdException("Failed to parse header line. Cause: " + exception.getMessage());
        }
    }

    protected String getTypeName(Map<String, String> typesMap, String filedName) {
        if (typesMap == null) {
            return null;
        }
        return typesMap.get("//" + filedName);
    }

    protected String getAlias(Map<String, String> aliasMap, String filedName) {
        if (aliasMap == null) {
            return null;
        }
        return aliasMap.get("//" + filedName);
    }

    protected String resolveAlias(Map<String, String> aliasMap, String filedName) {
        return AbstractParser.resolveAlias(this.getAlias(aliasMap, filedName), filedName);
    }

    public static String escapeFieldName(Set<String> names, String name) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < ((String)name).length(); ++i) {
            char c = ((String)name).charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            if (builder.length() == 0 && !Character.isJavaIdentifierStart(c)) {
                builder.append("_");
            }
            builder.append(c);
        }
        name = builder.toString();
        if (((String)name).length() == 0) {
            name = "unnamedField_" + names.size();
        }
        if (names.contains(name)) {
            Object newName = name;
            int i = 1;
            while (names.contains(newName = (String)name + "_" + i++)) {
            }
            name = newName;
        }
        names.add((String)name);
        return name;
    }
}

