/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.file;

import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.RecordField;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AbstractRecordTypeDefinition
extends FileDescriptorRecord {
    private String description = "";
    private List<RecordField> fields = new ArrayList<RecordField>();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<RecordField> getFields() {
        return this.fields;
    }

    public List<RecordField> getSortedFields() {
        return this.fields.stream().sorted((r1, r2) -> Integer.compare(r1.getStart(), r2.getStart())).collect(Collectors.toList());
    }

    public void setFields(List<RecordField> recordFields) {
        this.fields = recordFields;
    }

    public void addRecordField(RecordField field) {
        this.fields.add(field);
    }

    public void addRecordField(int pos, RecordField field) {
        this.fields.add(pos, field);
    }

    public void deleteRecordField(String name) {
        int index = this.getRecordFieldPosition(name);
        if (index >= 0) {
            this.fields.remove(index);
        }
    }

    public int getRecordFieldPosition(String name) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).getFieldName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public RecordField getField(String fieldName) {
        return this.fields.stream().filter(f -> f.getFieldName().equals(fieldName)).findFirst().orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRecordTypeDefinition)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractRecordTypeDefinition that = (AbstractRecordTypeDefinition)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.fields, that.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.description, this.fields);
    }
}

