/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.evqueue;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.Worker;
import com.streamscape.lib.evqueue.DeliveryMode;
import com.streamscape.lib.evqueue.EventQueueException;
import com.streamscape.lib.evqueue.EventQueueInterruptException;
import com.streamscape.lib.evqueue.EventQueueListener;
import com.streamscape.lib.evqueue.FlowControlMode;
import com.streamscape.lib.evqueue.IllegalQueueStateException;
import com.streamscape.lib.evqueue.Matcher;
import com.streamscape.lib.evqueue.NotificationListener;
import com.streamscape.lib.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class EventQueue<T> {
    private transient String name;
    private transient EventQueueListener<T> listener;
    private int maxDepth = 100000;
    private transient int warnDepth = 80000;
    private FlowControlMode flowControlMode = DEFAULT_FLOW_CONTROL_MODE;
    private DeliveryMode deliveryMode = DEFAULT_DELIVERY_MODE;
    private long deliverySpinWait = 1L;
    private transient DeliveryWorker deliveryWorker;
    private transient Map<Long, NotificationListener> notificationListeners = new ConcurrentHashMap<Long, NotificationListener>();
    private transient LinkedList<T> objects = new LinkedList();
    private transient boolean isOpened = true;
    private transient boolean isStarted = false;
    private transient boolean isSuspended = false;
    public static final int DEFAULT_MAX_DEPTH = 100000;
    public static final int DEFAULT_WARN_DEPTH = 80000;
    public static final FlowControlMode DEFAULT_FLOW_CONTROL_MODE = FlowControlMode.EXCEPTION;
    public static final DeliveryMode DEFAULT_DELIVERY_MODE = DeliveryMode.ASYNC_PACED;
    public static final long DEFAULT_DELIVERY_SPIN_WAIT = 1L;

    public EventQueue(String name) {
        this.name = name;
    }

    public EventQueue(String name, EventQueueListener<T> listener) {
        this(name, listener, DEFAULT_DELIVERY_MODE);
    }

    public EventQueue(String name, EventQueueListener<T> listener, DeliveryMode deliveryMode) {
        this.name = name;
        this.listener = listener;
        this.deliveryMode = deliveryMode;
        this.createDeliveryWorker();
    }

    public String getName() {
        return this.name;
    }

    public EventQueueListener getListener() {
        return this.listener;
    }

    public synchronized void setListener(EventQueueListener<T> listener) throws IllegalQueueStateException {
        this.checkStopped();
        this.listener = listener;
        if (this.deliveryWorker == null) {
            this.createDeliveryWorker();
        }
    }

    public NotificationListener getNotificationListener() {
        return this.notificationListeners.get(Thread.currentThread().getId());
    }

    public void setNotificationListener(NotificationListener notificationListener) {
        this.notificationListeners.put(Thread.currentThread().getId(), notificationListener);
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public synchronized void setMaxDepth(int maxDepth) {
        if (maxDepth > 0) {
            this.maxDepth = maxDepth;
            this.warnDepth = (int)((double)maxDepth * 0.8);
        }
    }

    public int getWarningThreshold() {
        return this.warnDepth;
    }

    public void setWarningThreshold(double maxDepthPercent) {
        this.warnDepth = (int)((double)this.maxDepth * maxDepthPercent);
    }

    public FlowControlMode getFlowControlMode() {
        return this.flowControlMode;
    }

    public synchronized void setFlowControlMode(FlowControlMode flowControlMode) {
        this.flowControlMode = flowControlMode;
    }

    public DeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    public synchronized void setDeliveryMode(DeliveryMode deliveryMode) throws IllegalQueueStateException {
        this.checkStopped();
        this.deliveryMode = deliveryMode;
        this.createDeliveryWorker();
    }

    public long getDeliverySpinWait() {
        return this.deliverySpinWait;
    }

    public void setDeliverySpinWait(long deliverySpinWait) {
        this.deliverySpinWait = deliverySpinWait;
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (!this.isOpened) {
                this.isOpened = true;
            }
        }
        Trace.logDebug(this, "Queue '" + this.name + "' opened.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.isOpened) {
                this.isOpened = false;
                this.notifyAll();
            }
        }
        Trace.logDebug(this, "Queue '" + this.name + "' closed.");
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (!this.isStarted && this.listener != null) {
                this.deliveryWorker.start();
                this.isStarted = true;
            }
        }
        Trace.logDebug(this, "Queue '" + this.name + "' started.");
    }

    public void stop() {
        this.doStop();
        Trace.logDebug(this, "Queue '" + this.name + "' stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDelayed(long timeout) {
        if (timeout > 0L) {
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                if (this.isStarted) {
                    this.deliveryWorker.stopDelayed();
                    this.isStarted = false;
                    this.isSuspended = false;
                    if (Thread.currentThread().getId() != this.deliveryWorker.getThread().getId()) {
                        try {
                            long endTime = System.currentTimeMillis() + timeout;
                            long waitTime = Math.min(timeout, 1000L);
                            while (this.deliveryWorker.delayedStop && this.deliveryWorker.getThread().isRunning() && System.currentTimeMillis() < endTime) {
                                this.wait(waitTime);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.deliveryWorker.getThread().isRunning()) {
                            this.deliveryWorker.stop();
                        }
                    }
                }
            }
        }
        this.doStop();
        Trace.logDebug(this, "Queue '" + this.name + "' stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.isStarted) {
                this.deliveryWorker.stop();
                this.isStarted = false;
                this.isSuspended = false;
            }
        }
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.isSuspended) {
                return;
            }
            this.isSuspended = true;
        }
        if (this.deliveryWorker != null) {
            this.deliveryWorker.sleep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (!this.isSuspended) {
                return;
            }
            this.isSuspended = false;
        }
        if (this.deliveryWorker != null) {
            this.deliveryWorker.wakeUp();
        }
    }

    public long getDeliveryThreadId() {
        return this.deliveryWorker != null && this.deliveryWorker.getThread() != null ? this.deliveryWorker.getThread().getId() : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(T object) throws EventQueueException {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            this.checkOpened();
            if (!this.processMaxDepth()) {
                return;
            }
            this.objects.addLast(object);
            this.notifyAll();
        }
        if (this.deliveryWorker != null) {
            this.deliveryWorker.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWithPriority(T object) throws EventQueueException {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            this.checkOpened();
            if (!this.processMaxDepth()) {
                return;
            }
            this.objects.addFirst(object);
            this.notifyAll();
        }
        if (this.deliveryWorker != null) {
            this.deliveryWorker.wakeUp();
        }
    }

    public synchronized T dequeue() throws EventQueueInterruptException {
        this.doWait();
        return this.objects.removeFirst();
    }

    public synchronized T dequeue(Matcher<T> matcher) throws EventQueueInterruptException {
        return this.doWait(matcher);
    }

    public synchronized List<T> dequeueList(int objectsNumber) throws EventQueueInterruptException {
        this.doWait(objectsNumber);
        return IntStream.range(0, objectsNumber).mapToObj(i -> this.objects.removeFirst()).collect(Collectors.toCollection(LinkedList::new));
    }

    public synchronized T dequeue(long waitTime) throws EventQueueInterruptException {
        this.doWait(waitTime);
        return this.objects.isEmpty() ? null : (T)this.objects.removeFirst();
    }

    public synchronized T dequeue(Matcher<T> matcher, long waitTime) throws EventQueueInterruptException {
        return this.doWait(matcher, waitTime);
    }

    public synchronized List<T> dequeueList(int objectsNumber, long waitTime) throws EventQueueInterruptException {
        this.doWait(objectsNumber, waitTime);
        if (this.objects.size() < objectsNumber) {
            return null;
        }
        return IntStream.range(0, objectsNumber).mapToObj(i -> this.objects.removeFirst()).collect(Collectors.toCollection(LinkedList::new));
    }

    public synchronized T dequeueNoWait() {
        return this.objects.isEmpty() ? null : (T)this.objects.removeFirst();
    }

    public synchronized T dequeueNoWait(Matcher<T> matcher) {
        return this.getObject(matcher);
    }

    public synchronized List<T> drain() throws EventQueueInterruptException {
        this.doWait();
        LinkedList<T> result = new LinkedList<T>();
        result.addAll(this.objects);
        this.objects.clear();
        return result;
    }

    public synchronized List<T> drain(long waitTime) throws EventQueueInterruptException {
        this.doWait(waitTime);
        if (this.objects.isEmpty()) {
            return null;
        }
        LinkedList<T> result = new LinkedList<T>();
        result.addAll(this.objects);
        this.objects.clear();
        return result;
    }

    public synchronized void drainTo(EventQueue<T> otherQueue) throws EventQueueException {
        this.check(this.objects.size() <= otherQueue.getMaxDepth() - otherQueue.size(), "not enough space in other queue.");
        otherQueue.objects.addAll(this.objects);
        this.objects.clear();
    }

    public synchronized T peek() throws EventQueueException {
        return this.objects.isEmpty() ? null : (T)this.objects.getFirst();
    }

    public synchronized int size() {
        return this.objects != null ? this.objects.size() : -1;
    }

    public synchronized boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public synchronized void clear() {
        this.objects.clear();
        this.notifyAll();
        Trace.logDebug(this, "Queue '" + this.name + "' cleared.");
    }

    private synchronized void doWait() throws EventQueueInterruptException {
        while (this.objects.isEmpty()) {
            this.doWaitAndCheck(0L);
        }
    }

    private synchronized T doWait(Matcher<T> matcher) throws EventQueueInterruptException {
        T result;
        while (this.objects.isEmpty() || (result = this.getObject(matcher)) == null) {
            this.doWaitAndCheck(0L);
        }
        return result;
    }

    private synchronized void doWait(int objectsNumber) throws EventQueueInterruptException {
        while (this.objects.size() < objectsNumber) {
            this.doWaitAndCheck(0L);
        }
    }

    private synchronized void doWait(long timeout) throws EventQueueInterruptException {
        long endTime = System.currentTimeMillis() + timeout;
        while (this.objects.isEmpty() && System.currentTimeMillis() < endTime) {
            this.doWaitAndCheck(timeout);
        }
    }

    private synchronized T doWait(Matcher<T> matcher, long timeout) throws EventQueueInterruptException {
        long endTime = System.currentTimeMillis() + timeout;
        T result = null;
        while (true) {
            if (!this.objects.isEmpty()) {
                T t = this.getObject(matcher);
                result = t;
                if (t != null) break;
            }
            if (System.currentTimeMillis() >= endTime) break;
            this.doWaitAndCheck(timeout);
        }
        return result;
    }

    private synchronized void doWait(int objectsNumber, long timeout) throws EventQueueInterruptException {
        long endTime = System.currentTimeMillis() + timeout;
        if (this.objects.size() < objectsNumber && System.currentTimeMillis() < endTime) {
            this.doWaitAndCheck(timeout);
        }
    }

    private void doWaitAndCheck(long timeout) throws EventQueueInterruptException {
        try {
            this.wait(timeout);
            this.checkInterrupted();
        }
        catch (InterruptedException exception) {
            this.throwInterruptException(exception);
        }
    }

    private void createDeliveryWorker() {
        this.deliveryWorker = this.deliveryMode == DeliveryMode.ASYNC_PACED ? new AsyncPacedDeliveryWorker() : new AsyncDeliveryWorker();
    }

    private boolean processMaxDepth() throws EventQueueException {
        if (this.maxDepth > 0) {
            switch (this.flowControlMode) {
                case DROP: {
                    return this.objects.size() < this.maxDepth;
                }
                case EXCEPTION: {
                    this.check(this.objects.size() < this.maxDepth, "max depth was reached.");
                    return true;
                }
                case EVENT_CACHE: {
                    return true;
                }
                case NOTIFICATION: {
                    if (this.notificationListeners.get(Thread.currentThread().getId()) == null) {
                        this.check(this.objects.size() < this.maxDepth, "max depth was reached.");
                    } else if (this.objects.size() >= this.maxDepth) {
                        this.notificationListeners.get(Thread.currentThread().getId()).onNotification((byte)101);
                        while (this.objects.size() < this.maxDepth) {
                            this.doWaitAndCheck(0L);
                        }
                        this.notificationListeners.get(Thread.currentThread().getId()).onNotification((byte)102);
                    }
                    return true;
                }
            }
            throw new RuntimeException("Invalid FlowControlMode!");
        }
        return true;
    }

    private T getObject(Matcher<T> matcher) {
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!matcher.matches(object)) continue;
            iterator.remove();
            return (T)object;
        }
        return null;
    }

    private void checkStarted() throws IllegalQueueStateException {
        if (!this.isStarted) {
            throw new IllegalQueueStateException("Queue '" + this.name + "' is not started.");
        }
    }

    private void checkStopped() throws IllegalQueueStateException {
        if (this.isStarted) {
            throw new IllegalQueueStateException("Queue '" + this.name + "' is not stopped.");
        }
    }

    private void checkOpened() throws IllegalQueueStateException {
        if (!this.isOpened) {
            throw new IllegalQueueStateException("Queue '" + this.name + "' is not opened.");
        }
    }

    private void checkClosed() throws IllegalQueueStateException {
        if (this.isOpened) {
            throw new IllegalQueueStateException("Queue '" + this.name + "' is opened.");
        }
    }

    private void checkInterrupted() throws EventQueueInterruptException {
        if (!this.isOpened) {
            throw new EventQueueInterruptException("Queue '" + this.name + "' is closed.");
        }
    }

    private void check(boolean condition, String message) throws EventQueueException {
        if (!condition) {
            this.throwException(message);
        }
    }

    private void throwException(String message) throws EventQueueException {
        throw new EventQueueException("Queue '" + this.name + "': " + message);
    }

    private void throwException(String message, Throwable cause) throws EventQueueException {
        throw new EventQueueException("Queue '" + this.name + "': " + message, cause);
    }

    private void throwInterruptException(Throwable cause) throws EventQueueInterruptException {
        throw new EventQueueInterruptException("Thread '" + String.valueOf(Thread.currentThread()) + "' interrupted.");
    }

    private abstract class DeliveryWorker
    extends Worker {
        private volatile boolean delayedStop;

        public DeliveryWorker() {
            super("EXCH:EventQueue.DeliveryWorker", "Delivers events received by async consumer '" + EventQueue.this.name + "'.");
            this.delayedStop = false;
        }

        @Override
        protected boolean canWork() {
            return super.canWork() && (!this.delayedStop || !EventQueue.this.objects.isEmpty());
        }

        @Override
        protected boolean hasTasks() {
            return !EventQueue.this.isSuspended && !EventQueue.this.objects.isEmpty();
        }

        @Override
        protected void doExecute() {
            while (this.isStarted() && this.getDeliveredObjects()) {
                Utils.sleep(EventQueue.this.deliverySpinWait);
                this.processObjects();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doStop() {
            super.doStop();
            EventQueue eventQueue = EventQueue.this;
            synchronized (eventQueue) {
                if (this.delayedStop) {
                    this.delayedStop = false;
                    EventQueue.this.notifyAll();
                }
            }
        }

        protected abstract boolean getDeliveredObjects();

        protected abstract void processObjects();

        protected void stopDelayed() {
            this.delayedStop = true;
            this.doNotify();
        }
    }

    private class AsyncPacedDeliveryWorker
    extends DeliveryWorker {
        private List<T> deliveredObjects;

        private AsyncPacedDeliveryWorker() {
        }

        @Override
        protected void processObjects() {
            for (Object object : this.deliveredObjects) {
                EventQueue.this.listener.onObject(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean getDeliveredObjects() {
            EventQueue eventQueue = EventQueue.this;
            synchronized (eventQueue) {
                if (!EventQueue.this.isSuspended && !EventQueue.this.objects.isEmpty()) {
                    this.deliveredObjects = new ArrayList(EventQueue.this.objects);
                    EventQueue.this.objects = new LinkedList();
                    return true;
                }
                return false;
            }
        }
    }

    private class AsyncDeliveryWorker
    extends DeliveryWorker {
        private T deliveredObject = null;

        private AsyncDeliveryWorker() {
        }

        @Override
        protected void processObjects() {
            EventQueue.this.listener.onObject(this.deliveredObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean getDeliveredObjects() {
            EventQueue eventQueue = EventQueue.this;
            synchronized (eventQueue) {
                if (!EventQueue.this.isSuspended && !EventQueue.this.objects.isEmpty()) {
                    this.deliveredObject = EventQueue.this.objects.removeFirst();
                    return true;
                }
                return false;
            }
        }
    }
}

