/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.evfs;

import com.streamscape.lib.evfs.DirectoryMonitor;
import com.streamscape.lib.evfs.FileSortStrategy;
import com.streamscape.sef.service.ServiceContext;

public class StandaloneDirectoryMonitor
extends DirectoryMonitor {
    protected boolean isRunning;
    private long watchDelay;

    public StandaloneDirectoryMonitor(String name, String directory, boolean recursiveScan, FileSortStrategy sortStrategy, boolean existingAsCreated) throws IllegalArgumentException {
        this(name, directory, recursiveScan, sortStrategy, 200L, existingAsCreated);
    }

    public StandaloneDirectoryMonitor(String name, String directory, boolean recursiveScan, FileSortStrategy sortStrategy, long watchDelay, boolean existingAsCreated) {
        super("", directory, recursiveScan, sortStrategy, existingAsCreated);
        this.watchDelay = watchDelay;
    }

    public StandaloneDirectoryMonitor(String name, String directory, boolean recursiveScan, FileSortStrategy sortStrategy, boolean includeContent, boolean existingAsCreated, ServiceContext context) {
        super(name, directory, recursiveScan, sortStrategy, existingAsCreated, context);
    }

    @Override
    public void run() {
        this.isRunning = true;
        this.snapshot = this.getFileObjects();
        while (this.isRunning) {
            try {
                this.process();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception);
            }
            try {
                Thread.sleep(this.watchDelay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized long getWatchDelay() {
        return this.watchDelay;
    }

    public synchronized void setWatchDelay(long watchDelay) {
        this.watchDelay = watchDelay;
    }

    @Override
    public synchronized void stop() {
        this.isRunning = false;
    }
}

