/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.evfs;

import com.streamscape.Trace;
import com.streamscape.lib.evfs.BaseDirectoryMonitor;
import com.streamscape.lib.evfs.FileEventListener;
import com.streamscape.lib.evfs.FileSortStrategy;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.file.FileMetaInfo;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.service.ServiceContext;
import java.util.ArrayList;
import java.util.List;

public class DirectoryMonitor
extends BaseDirectoryMonitor {
    public static final String FILE_STATE_CHANGE_EVENT_ID = "event.file.StateChange";
    public static final String FILE_CONTENT_EVENT_ID = "event.file.Content";
    protected List<FileEventListener> fileChangeEventListeners = new ArrayList<FileEventListener>();
    protected EventDatagramFactory eventDatagramFactory = RuntimeContext.getInstance().getEventDatagramFactory();
    protected ServiceContext containerContext;
    protected String snapshotEventId;

    public DirectoryMonitor(String name, String directory, boolean recursiveScan, FileSortStrategy sortStrategy, boolean existingAsCreated) throws IllegalArgumentException {
        super(name, directory, recursiveScan, sortStrategy, existingAsCreated);
    }

    public DirectoryMonitor(String monitorName, String dirToWatch, boolean recursiveScan, FileSortStrategy sortStrategy, boolean existingAsCreated, ServiceContext ctx) {
        this(monitorName, dirToWatch, recursiveScan, sortStrategy, existingAsCreated);
        this.containerContext = ctx;
    }

    private FileEvent getDataEvent(FileMetaInfo fileObject) throws DatagramFactoryException, SecurityViolationException, SDOException {
        FileEvent eventDatagram = (FileEvent)this.eventDatagramFactory.createEvent(FILE_STATE_CHANGE_EVENT_ID);
        eventDatagram.init(fileObject);
        return eventDatagram;
    }

    @Override
    protected void sendSnapshot(List<FileMetaInfo> snapshot) {
        super.sendSnapshot(snapshot);
        if (this.containerContext != null && this.isSendSnapshots()) {
            try {
                DataEvent event = (DataEvent)this.eventDatagramFactory.createEvent(this.snapshotEventId);
                event.setData(snapshot);
                this.containerContext.raiseEvent(event, 0L);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
    }

    public void setSnapshotEventId(String snapshotEventId) {
        this.snapshotEventId = snapshotEventId;
    }

    protected boolean addListener(FileEventListener listener) {
        return this.fileChangeEventListeners.add(listener);
    }

    protected boolean removeListener(FileEventListener listener) {
        return this.fileChangeEventListeners.remove(listener);
    }

    protected synchronized void raiseEvent(FileEvent event) {
        Trace.logDebug(this, event.toString());
        try {
            event.setCorrelationId(event.getName());
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        for (FileEventListener listener : this.fileChangeEventListeners) {
            listener.onEvent((FileEvent)event.clone());
            Trace.logDebug(this, "Sent event " + event.getEventId() + " to listener");
        }
        if (this.containerContext != null) {
            try {
                this.containerContext.raiseEvent(event, 0L);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
    }

    protected synchronized void raiseAdvisory(FileEvent event) {
    }

    @Override
    protected synchronized void raiseEvent(FileMetaInfo state) throws Exception {
        super.raiseEvent(state);
        this.raiseEvent(this.getDataEvent(state));
    }

    @Override
    protected synchronized void raiseAdvisory(FileMetaInfo state) throws DatagramFactoryException, SecurityViolationException, SDOException {
        this.raiseAdvisory(this.getDataEvent(state));
    }
}

