/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.dispatcher;

import com.streamscape.lib.dispatcher.AbstractDataConstraint;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sdo.enums.RangeConstraintType;
import java.util.Date;

public class RangeConstraint
extends AbstractDataConstraint {
    public static final String MODEL = "Range";
    protected RangeConstraintType type;
    protected Object minValue;
    protected Object maxValue;

    public RangeConstraint(String name, String description, Object minValue, Object maxValue) throws EventDispatcherException {
        super(name, description);
        if (minValue instanceof Number && maxValue instanceof Number) {
            this.type = RangeConstraintType.NUMERIC;
            this.doSetValues(minValue, maxValue);
        } else if (minValue instanceof Date && maxValue instanceof Date) {
            this.type = RangeConstraintType.DATE;
            this.doSetValues(RangeConstraint.fromDate(minValue), RangeConstraint.fromDate(maxValue));
        } else {
            throw new EventDispatcherException("Invalid range boundary types. Both values must be a number or a date.");
        }
    }

    public RangeConstraintType getType() {
        return this.type;
    }

    @Override
    public String getModel() {
        return MODEL;
    }

    @Override
    public boolean matchesValue(Object value) {
        if (this.isNumeric()) {
            return value instanceof Number && this.doMatchesValue((Number)value);
        }
        return value instanceof Date ? this.doMatchesValue((Date)value) : value instanceof Long && this.doMatchesDateValue((Long)value);
    }

    public Object getMinValue() {
        return this.doGetValue(this.minValue);
    }

    public synchronized void setMinValue(Object value) throws EventDispatcherException {
        value = this.doCheckValueType(value);
        this.doSetMinValue(value);
    }

    public Object getMaxValue() {
        return this.doGetValue(this.maxValue);
    }

    public synchronized void setMaxValue(Object value) throws EventDispatcherException {
        value = this.doCheckValueType(value);
        this.doSetMaxValue(value);
    }

    public synchronized void setBoundaryValues(Object minValue, Object maxValue) throws EventDispatcherException {
        minValue = this.doCheckValueType(minValue);
        maxValue = this.doCheckValueType(maxValue);
        this.doSetValues(minValue, maxValue);
    }

    @Override
    public RangeConstraint clone() {
        return (RangeConstraint)super.clone();
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof RangeConstraint && super.equals(other) && this.minValue.equals(((RangeConstraint)other).minValue) && this.maxValue.equals(((RangeConstraint)other).maxValue);
    }

    private Pair<Object, Object> doCheckValuesType(Object minValue, Object maxValue) throws EventDispatcherException {
        if (minValue instanceof Number && maxValue instanceof Number) {
            this.type = RangeConstraintType.NUMERIC;
            return new Pair<Object, Object>(minValue, maxValue);
        }
        if (minValue instanceof Date && maxValue instanceof Date) {
            this.type = RangeConstraintType.DATE;
            return new Pair<Object, Object>(((Date)minValue).getTime(), ((Date)maxValue).getTime());
        }
        throw new EventDispatcherException("Invalid range boundary types. Both values must be a number or a date.");
    }

    protected Object doCheckValueType(Object value) throws EventDispatcherException {
        if (this.isNumeric()) {
            if (!(value instanceof Number)) {
                throw new EventDispatcherException("Invalid boundary type ('" + String.valueOf(value.getClass()) + "') for Numeric Range.");
            }
            return value;
        }
        if (!(value instanceof Date)) {
            throw new EventDispatcherException("Invalid boundary type ('" + String.valueOf(value.getClass()) + "') for Date Range.");
        }
        return RangeConstraint.fromDate(value);
    }

    protected void doSetMinValue(Object value) {
        this.doSetValues(value, this.maxValue);
    }

    protected void doSetMaxValue(Object value) {
        this.doSetValues(this.minValue, value);
    }

    private void doSetValues(Object value1, Object value2) {
        if (this.less(value1, value2)) {
            this.minValue = value1;
            this.maxValue = value2;
        } else {
            this.minValue = value2;
            this.maxValue = value1;
        }
    }

    private boolean less(Object value1, Object value2) {
        return this.isNumeric() ? RangeConstraint.toDouble(value1) < RangeConstraint.toDouble(value2) : RangeConstraint.toLong(value1) < RangeConstraint.toLong(value2);
    }

    private boolean doMatchesValue(Number value) {
        double doubleValue = value.doubleValue();
        return RangeConstraint.toDouble(this.minValue) <= doubleValue && RangeConstraint.toDouble(this.maxValue) >= doubleValue;
    }

    private boolean doMatchesValue(Date value) {
        return this.doMatchesDateValue(value.getTime());
    }

    private boolean doMatchesDateValue(long value) {
        return RangeConstraint.toLong(this.minValue) <= value && RangeConstraint.toLong(this.maxValue) >= value;
    }

    private boolean isNumeric() {
        return this.type == RangeConstraintType.NUMERIC;
    }

    private Object doGetValue(Object value) {
        return this.isNumeric() ? value : RangeConstraint.toDate(value);
    }

    private static Date toDate(Object value) {
        return new Date(RangeConstraint.toLong(value));
    }

    private static long fromDate(Object value) {
        return ((Date)value).getTime();
    }

    private static double toDouble(Object value) {
        return ((Number)value).doubleValue();
    }

    private static long toLong(Object value) {
        return ((Number)value).longValue();
    }
}

