/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.dispatcher;

import com.streamscape.lib.concurrent.ExecutedTask;
import com.streamscape.lib.concurrent.TaskExecutor;
import com.streamscape.lib.dispatcher.ConsumerState;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.EventRequestConsumer;
import com.streamscape.lib.dispatcher.RequestException;
import com.streamscape.lib.dispatcher.RequestListener;
import com.streamscape.sdo.AbstractNamedObject;
import com.streamscape.sdo.ImmutableEventDatagram;
import java.util.concurrent.TimeoutException;

public class EventRequestConsumerImpl
extends AbstractNamedObject
implements EventRequestConsumer {
    protected transient RequestListener listener;
    protected transient ConsumerState consumerState = new ConsumerState();

    public EventRequestConsumerImpl(String name, RequestListener listener) {
        super(name);
        this.listener = listener;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public RequestListener getRequestListener() {
        return this.listener;
    }

    @Override
    public void setRequestListener(RequestListener listener) {
        this.listener = listener;
    }

    @Override
    public ConsumerState getCurrentState() {
        return this.consumerState;
    }

    public ImmutableEventDatagram processRequest(final ImmutableEventDatagram request, long timeout) throws EventDispatcherException, RequestException {
        try {
            class RequestExecutedTask
            implements ExecutedTask<ImmutableEventDatagram, ImmutableEventDatagram> {
                RequestExecutedTask() {
                }

                @Override
                public ImmutableEventDatagram execute(ImmutableEventDatagram request2) throws RequestException {
                    EventRequestConsumerImpl.this.consumerState.busy(request2);
                    ImmutableEventDatagram reply = EventRequestConsumerImpl.this.listener.onRequest(request2);
                    EventRequestConsumerImpl.this.consumerState.free();
                    return reply;
                }

                @Override
                public String getType() {
                    return "EXCH";
                }

                @Override
                public String getName() {
                    return "Request.Handler:Executor";
                }

                @Override
                public String getDescription() {
                    return "Executes request [" + request.getEventId() + "].";
                }
            }
            return new TaskExecutor<ImmutableEventDatagram, ImmutableEventDatagram>().execute(new RequestExecutedTask(), request, timeout);
        }
        catch (RequestException exception) {
            throw exception;
        }
        catch (TimeoutException exception) {
            throw new EventDispatcherException("Reply timeout expired.", exception);
        }
        catch (InterruptedException exception) {
            throw new EventDispatcherException("Waiting of reply interrupted.", exception);
        }
        catch (Throwable exception) {
            throw new EventDispatcherException(exception.getMessage() != null ? exception.getMessage() : exception.getClass().getName());
        }
    }
}

