/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.dispatcher.DataConstraintStore;
import com.streamscape.lib.dispatcher.DomainConstraint;
import com.streamscape.lib.dispatcher.EventAsyncConsumer;
import com.streamscape.lib.dispatcher.EventAsyncConsumerImpl;
import com.streamscape.lib.dispatcher.EventCache;
import com.streamscape.lib.dispatcher.EventConsumer;
import com.streamscape.lib.dispatcher.EventConsumerImpl;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.EventException;
import com.streamscape.lib.dispatcher.EventListener;
import com.streamscape.lib.dispatcher.EventRequestConsumer;
import com.streamscape.lib.dispatcher.EventRequestConsumerImpl;
import com.streamscape.lib.dispatcher.IllegalDispatcherStateException;
import com.streamscape.lib.dispatcher.LREDiscardEventCache;
import com.streamscape.lib.dispatcher.MREDiscardEventCache;
import com.streamscape.lib.dispatcher.RangeConstraint;
import com.streamscape.lib.dispatcher.RequestException;
import com.streamscape.lib.dispatcher.RequestListener;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.filter.FilterMap;
import com.streamscape.lib.filter.FilterSingleMap;
import com.streamscape.lib.filter.FilterUtils;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.enums.ExceptionStrategy;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class EventDispatcher {
    protected boolean isStarted = false;
    protected EventDispatcherFilterMap allConsumers = new EventDispatcherFilterMap();
    protected Map<String, EventConsumerImpl> eventConsumers = new HashMap<String, EventConsumerImpl>();
    protected Map<String, EventAsyncConsumerImpl> eventAsyncConsumers = new HashMap<String, EventAsyncConsumerImpl>();
    protected Map<String, EventRequestConsumerImpl> eventRequestConsumers = new HashMap<String, EventRequestConsumerImpl>();
    protected FilterSingleMap<EventCache> allEventCaches = new FilterSingleMap();
    protected Map<String, EventCache> eventCaches = new HashMap<String, EventCache>();
    protected DataConstraintStore dataConstraintStore = this.createDataConstraintStore();
    protected Map<String, EventConsumerImpl> replyConsumers = new HashMap<String, EventConsumerImpl>();
    protected LongNumberAllocatorSimple replySuffixAllocator = new LongNumberAllocatorSimple();
    protected final Object consumersMutex = new Object();
    protected final Object cachesMutex = new Object();
    protected final ReadWriteLock eventsLock = new ReentrantReadWriteLock();
    private final EventProcessor DEFAULT_EVENT_PROCESSOR = new EventProcessor();

    public EventDispatcher() {
        this.logDebug("Event Dispatcher created.");
    }

    protected DataConstraintStore createDataConstraintStore() {
        return new DataConstraintStore();
    }

    public EventConsumer createConsumer(String consumerName, String eventFilter, String eventSelector, EventListener listener) throws EventDispatcherException, FilterFormatException, SelectorFormatException {
        EventConsumerImpl consumer = new EventConsumerImpl(consumerName, eventFilter, eventSelector, listener);
        this.addDirectConsumer(consumer, false);
        return consumer;
    }

    public EventAsyncConsumer createAsyncConsumer(String consumerName, String eventFilter, String eventSelector, EventListener listener) throws EventDispatcherException, FilterFormatException, SelectorFormatException {
        EventAsyncConsumerImpl consumer = new EventAsyncConsumerImpl(consumerName, eventFilter, eventSelector, listener);
        this.addAsyncConsumer(consumer, false);
        return consumer;
    }

    public EventRequestConsumer createRequestConsumer(String consumerName, RequestListener listener) throws EventDispatcherException {
        EventRequestConsumerImpl consumer = new EventRequestConsumerImpl(consumerName, listener);
        this.addRequestConsumer(consumer);
        return consumer;
    }

    public void dropConsumer(String consumerName) {
        EventConsumerImpl removedConsumer = this.eventConsumers.remove(consumerName);
        if (removedConsumer != null) {
            this.removeConsumer(removedConsumer);
        }
    }

    public void dropAsyncConsumer(String consumerName) {
        EventAsyncConsumerImpl removedConsumer = this.eventAsyncConsumers.remove(consumerName);
        if (removedConsumer != null) {
            removedConsumer.stop();
            this.removeConsumer(removedConsumer);
        }
    }

    public void dropRequestConsumer(String consumerName) {
        this.eventRequestConsumers.remove(consumerName);
    }

    public EventConsumer getConsumer(String consumerName) {
        return this.eventConsumers.get(consumerName);
    }

    public EventAsyncConsumer getAsyncConsumer(String consumerName) {
        return this.eventAsyncConsumers.get(consumerName);
    }

    public EventRequestConsumer getRequestConsumer(String consumerName) {
        return this.eventRequestConsumers.get(consumerName);
    }

    public boolean existsConsumer(String consumerName) {
        return this.eventConsumers.containsKey(consumerName);
    }

    public boolean existsAsyncConsumer(String consumerName) {
        return this.eventAsyncConsumers.containsKey(consumerName);
    }

    public boolean existsRequestConsumer(String consumerName) {
        return this.eventRequestConsumers.containsKey(consumerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventConsumer> getConsumers() {
        Object object = this.consumersMutex;
        synchronized (object) {
            return new ArrayList<EventConsumer>(this.eventConsumers.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventAsyncConsumer> getAsyncConsumers() {
        Object object = this.consumersMutex;
        synchronized (object) {
            return new ArrayList<EventAsyncConsumer>(this.eventAsyncConsumers.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventRequestConsumer> getRequestConsumers() {
        Object object = this.consumersMutex;
        synchronized (object) {
            return new ArrayList<EventRequestConsumer>(this.eventRequestConsumers.values());
        }
    }

    public void addEventCache(String eventFilter, int maxSize, CacheThresholdAction thresholdAction) throws EventDispatcherException, FilterFormatException {
        this.addEventCache(EventDispatcher.createEventCache(new Filter(eventFilter), maxSize, thresholdAction, true));
    }

    protected static EventCache createEventCache(Filter eventFilter, int maxSize, CacheThresholdAction thresholdAction, boolean createQueue) throws EventDispatcherException {
        switch (thresholdAction) {
            case LRE_DISCARD: {
                return new LREDiscardEventCache(eventFilter, maxSize, createQueue);
            }
            case MRE_DISCARD: {
                return new MREDiscardEventCache(eventFilter, maxSize, createQueue);
            }
        }
        throw new RuntimeException("Invalid CacheThresholdAction!");
    }

    protected static void initQueue(EventCache eventCache) {
        eventCache.initQueue();
    }

    public void removeEventCache(String eventFilter) throws FilterFormatException {
        this.removeEventCache(new Filter(eventFilter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEventCache(Filter eventFilter) {
        Object object = this.cachesMutex;
        synchronized (object) {
            EventCache removedCache = this.eventCaches.remove(eventFilter.toString());
            if (removedCache != null) {
                removedCache.clear();
                this.allEventCaches.remove(eventFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventCache getEventCache(String eventFilter) throws FilterFormatException {
        Object object = this.cachesMutex;
        synchronized (object) {
            return this.allEventCaches.getByFilter(eventFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventCache> getEventCaches() {
        Object object = this.cachesMutex;
        synchronized (object) {
            return new ArrayList<EventCache>(this.eventCaches.values());
        }
    }

    public void raiseEvent(ImmutableEventDatagram event) throws EventDispatcherException, EventException {
        this.checkState();
        this.eventsLock.readLock().lock();
        try {
            this.deliverEvent(event);
            if (event.getDurable()) {
                this.addEventToCaches(event);
            }
        }
        finally {
            this.eventsLock.readLock().unlock();
        }
    }

    public ImmutableEventDatagram raiseRequest(EventRequestConsumer consumer, ImmutableEventDatagram request, long timeout) throws EventDispatcherException, RequestException {
        this.checkState();
        if (consumer instanceof EventRequestConsumerImpl && this.eventRequestConsumers.containsKey(consumer.getName())) {
            return ((EventRequestConsumerImpl)consumer).processRequest(request, timeout);
        }
        throw new EventDispatcherException("Request consumer not found.");
    }

    public ImmutableEventDatagram raiseRequest(EventDatagram request, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws EventDispatcherException, EventException {
        this.checkState();
        ReplyConsumer replyConsumer = this.createReplyConsumer(request, matchStrategy);
        this.addReplyConsumer(replyConsumer);
        try {
            this.raiseRequest(request, distributionStrategy);
            replyConsumer.doWait(timeout > 0L ? timeout : 0L);
        }
        catch (InterruptedException exception) {
            this.removeReplyConsumer(replyConsumer);
            throw new EventDispatcherException("Waiting of reply interrupted.");
        }
        catch (EventDispatcherException exception) {
            this.removeReplyConsumer(replyConsumer);
            throw exception;
        }
        this.removeReplyConsumer(replyConsumer);
        if (replyConsumer.replyEvent == null) {
            throw new EventDispatcherException("Reply timeout expired.");
        }
        return replyConsumer.replyEvent;
    }

    public DomainConstraint createDomainConstraint(String name, String description, Set<Object> values) throws EventDispatcherException {
        return this.dataConstraintStore.createDomain(name, description, values);
    }

    public void dropDomainConstraint(String name) {
        this.dataConstraintStore.dropDomain(name);
    }

    public DomainConstraint getDomainConstraint(String name) {
        return this.dataConstraintStore.getDomain(name);
    }

    public List<DomainConstraint> getDomainConstraints() {
        return this.dataConstraintStore.getDomains();
    }

    public RangeConstraint createRangeConstraint(String name, String description, Object minValue, Object maxValue) throws EventDispatcherException {
        return this.dataConstraintStore.createRange(name, description, minValue, maxValue);
    }

    public void dropRangeConstraint(String name) {
        this.dataConstraintStore.dropRange(name);
    }

    public RangeConstraint getRangeConstraint(String name) {
        return this.dataConstraintStore.getRange(name);
    }

    public List<RangeConstraint> getRangeConstraints() {
        return this.dataConstraintStore.getRanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.consumersMutex;
        synchronized (object) {
            if (!this.isStarted) {
                this.eventAsyncConsumers.values().forEach(EventAsyncConsumer::start);
                this.isStarted = true;
            }
        }
        this.logDebug("Event Dispatcher started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.consumersMutex;
        synchronized (object) {
            if (this.isStarted) {
                this.isStarted = false;
                this.eventAsyncConsumers.values().forEach(EventAsyncConsumer::stop);
            }
        }
        this.logDebug("Event Dispatcher stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws EventDispatcherException {
        Object object = this.consumersMutex;
        synchronized (object) {
            if (this.isStarted) {
                throw new EventDispatcherException("Illegal attempt to clear the non-stopped dispatcher.");
            }
            this.allConsumers.clear();
            this.eventConsumers.clear();
            this.eventAsyncConsumers.clear();
            this.eventRequestConsumers.clear();
            this.allEventCaches.clear();
            this.replyConsumers.clear();
            this.replySuffixAllocator.clear();
        }
        this.logDebug("Event Dispatcher cleared.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws EventDispatcherException {
        Object object = this.consumersMutex;
        synchronized (object) {
            this.stop();
            this.clear();
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDirectConsumer(EventConsumerImpl consumer, boolean isSystem) throws EventDispatcherException {
        Object object = this.consumersMutex;
        synchronized (object) {
            this.checkUniqueness(consumer.getName());
            this.putDirectConsumer(consumer);
        }
        this.processCachedEvents(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAsyncConsumer(EventAsyncConsumerImpl consumer, boolean isSystem) throws EventDispatcherException {
        Object object = this.consumersMutex;
        synchronized (object) {
            this.checkUniqueness(consumer.getName());
            this.putAsyncConsumer(consumer);
        }
        this.processCachedEvents(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRequestConsumer(EventRequestConsumerImpl consumer) throws EventDispatcherException {
        Object object = this.consumersMutex;
        synchronized (object) {
            this.checkUniqueness(consumer.getName());
            this.putRequestConsumer(consumer);
        }
    }

    protected void checkUniqueness(String consumerName) throws EventDispatcherException {
        if (this.eventConsumers.containsKey(consumerName) || this.eventAsyncConsumers.containsKey(consumerName) || this.eventRequestConsumers.containsKey(consumerName)) {
            throw new EventDispatcherException("Consumer '" + consumerName + "' already exists.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putDirectConsumer(EventConsumerImpl consumer) {
        Object object = this.consumersMutex;
        synchronized (object) {
            this.allConsumers.putConsumer(consumer);
            this.eventConsumers.put(consumer.getName(), consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putAsyncConsumer(EventAsyncConsumerImpl consumer) {
        Object object = this.consumersMutex;
        synchronized (object) {
            this.allConsumers.putConsumer(consumer);
            this.eventAsyncConsumers.put(consumer.getName(), consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putRequestConsumer(EventRequestConsumerImpl consumer) {
        Object object = this.consumersMutex;
        synchronized (object) {
            this.eventRequestConsumers.put(consumer.getName(), consumer);
        }
    }

    protected void processCachedEvents(EventConsumerImpl consumer) {
        this.processCachedEvents(consumer, this.getCachedEvents(consumer.eventFilter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCachedEvents(EventConsumerImpl consumer, List<ImmutableEventDatagram> cachedEvents) {
        if (cachedEvents != null && !cachedEvents.isEmpty()) {
            this.eventsLock.writeLock().lock();
            try {
                for (ImmutableEventDatagram event : cachedEvents) {
                    try {
                        consumer.processEvent(event);
                    }
                    catch (Throwable exception) {
                        this.logExceptionNonBroadcast(exception);
                        this.logErrorNonBroadcast("Processing cached event [" + event.getEventId() + "] failed.");
                    }
                }
            }
            finally {
                this.eventsLock.writeLock().unlock();
            }
        }
        this.setReady(consumer);
    }

    protected void setReady(EventConsumerImpl consumer) {
        consumer.setReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventCache(EventCache cache) throws EventDispatcherException {
        Object object = this.cachesMutex;
        synchronized (object) {
            if (this.eventCaches.containsKey(cache.eventFilter)) {
                throw new EventDispatcherException("Event cache '" + cache.eventFilter + "' already exists.");
            }
            this.doAddEventCache(cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddEventCache(EventCache cache) {
        Object object = this.cachesMutex;
        synchronized (object) {
            this.allEventCaches.put(cache.filter, cache);
            this.eventCaches.put(cache.eventFilter, cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCachedEvents(CompositeFilter filter, List<ImmutableEventDatagram> result) {
        Object object = this.cachesMutex;
        synchronized (object) {
            for (Map.Entry<String, EventCache> cacheEntry : this.eventCaches.entrySet()) {
                LinkedList cachedEvents = cacheEntry.getValue().events;
                result.addAll(cachedEvents.stream().filter(event -> FilterUtils.matches(event.getEventId(), filter)).collect(Collectors.toList()));
            }
        }
    }

    protected List<ImmutableEventDatagram> getCachedEvents(CompositeFilter filter) {
        ArrayList<ImmutableEventDatagram> result = new ArrayList<ImmutableEventDatagram>();
        this.getCachedEvents(filter, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConsumer(EventConsumerImpl consumer) {
        Object object = this.consumersMutex;
        synchronized (object) {
            this.allConsumers.removeConsumer(consumer);
        }
    }

    protected void deliverEvent(ImmutableEventDatagram event) throws EventException {
        this.doDeliverEvent(event, this.getConsumers(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<EventConsumerImpl> getConsumers(ImmutableEventDatagram event) {
        Object object = this.consumersMutex;
        synchronized (object) {
            return this.allConsumers.get(event.getEventId());
        }
    }

    protected void doDeliverEvent(ImmutableEventDatagram event, Collection<EventConsumerImpl> consumers) throws EventException {
        if (consumers != null) {
            this.doDeliverEvent(event, consumers, this.createEventProcessor());
        }
    }

    protected void doDeliverEvent(ImmutableEventDatagram event, Collection<EventConsumerImpl> consumers, EventProcessor processor) throws EventException {
        ArrayList<EventConsumerImpl> directConsumers = new ArrayList<EventConsumerImpl>();
        for (EventConsumerImpl consumer : consumers) {
            if (consumer instanceof EventAsyncConsumerImpl) {
                processor.process(consumer, event);
                continue;
            }
            directConsumers.add(consumer);
        }
        for (EventConsumerImpl consumer : directConsumers) {
            processor.process(consumer, event);
        }
    }

    protected EventProcessor createEventProcessor() {
        return this.DEFAULT_EVENT_PROCESSOR;
    }

    protected void processException(EventDispatcherException exception, ImmutableEventDatagram event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventToCaches(ImmutableEventDatagram event) {
        Object object = this.cachesMutex;
        synchronized (object) {
            List<EventCache> caches = this.allEventCaches.get(event.getEventId());
            if (caches != null) {
                for (EventCache cache : caches) {
                    cache.addEvent(event);
                }
            }
        }
    }

    protected static List getCachedEvents(EventCache cache) {
        return cache.events;
    }

    protected static void addEventToCache(Object event, EventCache eventCache) {
        eventCache.addEvent(event);
    }

    protected ReplyConsumer createReplyConsumer(EventDatagram request, ReplyMatchStrategy matchStrategy) throws EventDispatcherException {
        switch (matchStrategy) {
            case REPLY_TO: {
                return this.createReplyConsumerInstance(request);
            }
            case REPLY_WITH_CORRELATION_ID: {
                return this.createReplyConsumerWithCorrelationIdInstance(request);
            }
        }
        throw new RuntimeException("Invalid EventMatchStrategy!");
    }

    protected ReplyConsumer createReplyConsumerInstance(EventDatagram request) throws EventDispatcherException {
        return new ReplyConsumer(this, request);
    }

    protected ReplyConsumer createReplyConsumerWithCorrelationIdInstance(EventDatagram request) throws EventDispatcherException {
        return new ReplyWithCorrelationIdConsumer(this, request);
    }

    protected String getReplySuffix(long replySuffixNumber) {
        return Long.toString(replySuffixNumber);
    }

    protected EventConsumerImpl createUnderlyingReplyConsumer(String consumerName, String eventFilter, EventListener listener) throws EventDispatcherException {
        try {
            return new EventConsumerImpl(consumerName, eventFilter, listener);
        }
        catch (FilterFormatException exception) {
            throw new EventDispatcherException("Creation of underlying reply consumer failed.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReplyConsumer(ReplyConsumer consumer) {
        Object object = this.consumersMutex;
        synchronized (object) {
            this.allConsumers.putReplyConsumer(consumer);
            this.replyConsumers.put(consumer.underlyingConsumer.getName(), consumer.underlyingConsumer);
            consumer.underlyingConsumer.setReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeReplyConsumer(ReplyConsumer consumer) {
        Object object = this.consumersMutex;
        synchronized (object) {
            this.replyConsumers.remove(consumer.underlyingConsumer.getName());
            this.allConsumers.removeReplyConsumer(consumer);
        }
    }

    protected void raiseRequest(EventDatagram request, RequestDistributionStrategy distributionStrategy) throws EventDispatcherException, EventException {
        switch (distributionStrategy) {
            case AUCTION: {
                this.deliverEvent(request);
                break;
            }
            default: {
                throw new EventDispatcherException("Request distribution strategy '" + String.valueOf((Object)distributionStrategy) + "' is not supported.'");
            }
        }
    }

    protected void checkState() throws EventDispatcherException {
        if (!this.isStarted) {
            throw new IllegalDispatcherStateException("Dispatcher is not started.");
        }
    }

    protected void logError(String message) {
        Trace.logError(EventDispatcher.class, message);
    }

    protected void logInfo(String message) {
        Trace.logInfo(this, message);
    }

    protected void logDebug(String message) {
        Trace.logDebug(this, message);
    }

    protected void logException(Throwable exception) {
        Trace.logException(this, exception, true);
    }

    protected void logErrorNonBroadcast(String message) {
        if (!Trace.isBroadcastEnabled(this.getClass().getName())) {
            Trace.logError(this, message);
        }
    }

    protected void logExceptionNonBroadcast(Throwable exception) {
        if (!Trace.isBroadcastEnabled(this.getClass().getName())) {
            Trace.logException(this, exception, true);
        }
    }

    protected static class EventDispatcherFilterMap
    extends FilterMap<EventConsumerImpl> {
        public void putConsumer(EventConsumerImpl consumer) {
            this.put(consumer.eventFilter, consumer);
        }

        public void removeConsumer(EventConsumerImpl consumer) {
            this.remove(consumer.eventFilter, consumer);
        }

        public void putReplyConsumer(ReplyConsumer consumer) {
            this.putSimple(consumer.underlyingConsumer.getEventFilter(), consumer.underlyingConsumer);
        }

        public void removeReplyConsumer(ReplyConsumer consumer) {
            this.removeSimple(consumer.underlyingConsumer.getEventFilter(), consumer.underlyingConsumer);
        }
    }

    protected class EventProcessor {
        protected ExceptionStrategy exceptionStrategy = null;

        protected EventProcessor() {
        }

        protected void process(EventConsumerImpl consumer, ImmutableEventDatagram event) throws EventException {
            try {
                if (this.matches(consumer, event)) {
                    consumer.processEvent(event.clone());
                }
            }
            catch (EventException exception) {
                if (this.exceptionStrategy == null) {
                    this.exceptionStrategy = this.getExceptionStrategy(event);
                }
                switch (this.exceptionStrategy) {
                    case ABORT: {
                        throw exception;
                    }
                    case CHAIN: 
                    case IGNORE: {
                        EventDispatcher.this.logException(exception);
                        EventDispatcher.this.logError("Exception was thrown by synchronous listener. It will not be thrown further (ExceptionStrategy.IGNORE).");
                    }
                }
            }
            catch (EventDispatcherException exception) {
                EventDispatcher.this.processException(exception, event);
            }
            catch (Throwable exception) {
                EventDispatcher.this.logException(exception);
                EventDispatcher.this.logError("Delivery of event [" + event.getEventId() + "] failed.");
            }
        }

        protected boolean matches(EventConsumerImpl consumer, ImmutableEventDatagram event) {
            return consumer.isReady() && consumer.matches(event);
        }

        protected ExceptionStrategy getExceptionStrategy(ImmutableEventDatagram event) {
            return ExceptionStrategy.ABORT;
        }
    }

    protected class ReplyConsumer
    implements NamedObject {
        protected transient EventConsumerImpl underlyingConsumer;
        protected transient String replySuffix;
        protected transient ImmutableEventDatagram replyEvent;

        protected ReplyConsumer(EventDispatcher this$0, EventDatagram request) throws EventDispatcherException {
            this.checkRequest(request);
            this.replySuffix = this$0.getReplySuffix(this$0.replySuffixAllocator.getNumber());
            try {
                request.setReplyTo((String)(request.getReplyTo() != null ? request.getReplyTo() : "e.reply." + this.replySuffix));
            }
            catch (SDOFormatException exception) {
                throw new EventDispatcherException("Creation of reply consumer failed.", exception);
            }
            this.underlyingConsumer = this$0.createUnderlyingReplyConsumer("ReplyConsumer$" + this.replySuffix, request.getReplyTo(), new ReplyListener());
        }

        @Override
        public String getName() {
            return this.underlyingConsumer.getName();
        }

        public void setName(String name) {
            this.underlyingConsumer.setName(name);
        }

        public ImmutableEventDatagram getReplyEvent() {
            return this.replyEvent;
        }

        protected void checkRequest(EventDatagram request) throws EventDispatcherException {
        }

        protected synchronized void doNotify(ImmutableEventDatagram event) {
            if (this.replyEvent == null && this.checkReceivedEvent(event)) {
                this.replyEvent = event;
                this.notify();
            }
        }

        protected boolean checkReceivedEvent(ImmutableEventDatagram event) {
            return event != null;
        }

        public synchronized void doWait(long timeout) throws InterruptedException {
            if (this.replyEvent == null) {
                this.wait(timeout);
            }
        }

        protected class ReplyListener
        implements EventListener {
            protected ReplyListener() {
            }

            @Override
            public void onEvent(ImmutableEventDatagram event) {
                ReplyConsumer.this.doNotify(event);
            }
        }
    }

    protected class ReplyWithCorrelationIdConsumer
    extends ReplyConsumer {
        transient String correlationId;

        protected ReplyWithCorrelationIdConsumer(EventDispatcher this$0, EventDatagram request) throws EventDispatcherException {
            super(this$0, request);
        }

        @Override
        protected void checkRequest(EventDatagram request) throws EventDispatcherException {
            if (request.getCorrelationIdAsBytes() == null) {
                throw new EventDispatcherException("Creation of reply consumer failed: event field 'correlationId' is null.");
            }
            this.correlationId = request.getCorrelationId();
        }

        @Override
        protected boolean checkReceivedEvent(ImmutableEventDatagram event) {
            return event instanceof EventDatagram && this.correlationId.equals(((EventDatagram)event).getCorrelationId());
        }
    }
}

