/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.dispatcher;

import com.streamscape.lib.dispatcher.ConsumerState;
import com.streamscape.lib.dispatcher.EventConsumer;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.EventException;
import com.streamscape.lib.dispatcher.EventListener;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.filter.FilterUtils;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.parser.SelectorParser;
import com.streamscape.sdo.AbstractNamedObject;
import com.streamscape.sdo.ImmutableEventDatagram;

public class EventConsumerImpl
extends AbstractNamedObject
implements EventConsumer {
    protected CompositeFilter eventFilter;
    protected String eventSelector;
    protected transient boolean isReady;
    protected transient SelectorExpression selectorExpression;
    protected transient EventListener listener;
    protected transient ConsumerState consumerState = new ConsumerState();

    protected EventConsumerImpl(String consumerName, String eventFilter, String eventSelector, EventListener listener) throws FilterFormatException, SelectorFormatException {
        this(consumerName, new CompositeFilter(eventFilter), eventSelector, listener);
    }

    @Override
    public String getEventFilter() {
        return this.eventFilter.toString();
    }

    @Override
    public EventListener getEventListener() {
        return this.listener;
    }

    @Override
    public void setEventListener(EventListener listener) {
        this.listener = listener;
    }

    @Override
    public String getEventSelector() {
        return this.eventSelector;
    }

    @Override
    public void setEventSelector(String eventSelector) throws SelectorFormatException {
        this.selectorExpression = eventSelector != null ? SelectorParser.parse(eventSelector) : null;
        this.eventSelector = eventSelector;
    }

    @Override
    public ConsumerState getCurrentState() {
        return this.consumerState;
    }

    @Override
    public boolean matchesEventId(String eventId) {
        return FilterUtils.matches(eventId, this.eventFilter);
    }

    protected EventConsumerImpl(String name, CompositeFilter eventFilter, EventListener listener) {
        super(name);
        this.eventFilter = eventFilter;
        this.listener = listener;
    }

    protected EventConsumerImpl(String consumerName, String eventFilter, EventListener listener) throws FilterFormatException {
        this(consumerName, new CompositeFilter(eventFilter), listener);
    }

    protected EventConsumerImpl(String name, CompositeFilter eventFilter, String eventSelector, EventListener listener) throws SelectorFormatException {
        this(name, eventFilter, listener);
        this.setEventSelector(eventSelector);
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected String getPrefix() {
        return "Direct";
    }

    protected boolean isReady() {
        return this.isReady;
    }

    protected void setReady() {
        this.isReady = true;
    }

    protected CompositeFilter getCompositeFilter() {
        return this.eventFilter;
    }

    protected SelectorExpression getSelectorExpression() {
        return this.selectorExpression;
    }

    protected void setEventSelector(String eventSelector, SelectorExpression selectorExpression) {
        this.eventSelector = eventSelector;
        this.selectorExpression = selectorExpression;
    }

    public boolean matches(ImmutableEventDatagram event) {
        return this.selectorExpression == null || this.selectorExpression.matches(event);
    }

    protected void processEvent(ImmutableEventDatagram event) throws EventDispatcherException, EventException {
        this.consumerState.busy(event);
        this.listener.onEvent(event);
        this.consumerState.free();
    }
}

