/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.dispatcher;

import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.enums.CacheThresholdAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class EventCache
extends CloneableDataObject {
    public static final int DEFAULT_MAX_SIZE = 1000;
    Filter filter;
    String eventFilter;
    int maxSize = 1000;
    transient LinkedList events;

    EventCache(Filter filter, int maxSize, boolean createQueue) throws EventDispatcherException {
        EventCache.checkMaxSize(maxSize);
        this.filter = filter;
        this.eventFilter = filter.toString();
        this.maxSize = maxSize;
        if (createQueue) {
            this.events = new LinkedList();
        }
    }

    protected void initQueue() {
        this.events = new LinkedList();
    }

    public Filter getEventFilter() {
        return this.filter;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(int maxSize) throws EventDispatcherException {
        EventCache.checkMaxSize(maxSize);
        if (this.maxSize != maxSize) {
            this.maxSize = maxSize;
            if (this.events != null && maxSize < this.events.size()) {
                this.removeRedundantEvents(maxSize - this.events.size());
            }
        }
    }

    private static void checkMaxSize(int maxSize) throws EventDispatcherException {
        if (maxSize <= 0) {
            throw new EventDispatcherException("Max size must be positive.");
        }
    }

    public abstract CacheThresholdAction getThresholdAction();

    abstract void addEvent(Object var1);

    public int getSize() {
        return this.events.size();
    }

    public synchronized List getEvents() {
        return new ArrayList(this.events);
    }

    public synchronized void clear() {
        this.events.clear();
    }

    abstract void removeRedundantEvents(int var1);

    private Object writeReplace() {
        EventCache result = (EventCache)this.clone();
        result.filter = null;
        return result;
    }

    private Object readResolve() throws FilterFormatException {
        this.filter = new Filter(this.eventFilter);
        this.events = new LinkedList();
        return this;
    }
}

