/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.dispatcher.EventAsyncConsumer;
import com.streamscape.lib.dispatcher.EventConsumerImpl;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.EventListener;
import com.streamscape.lib.evqueue.DeliveryMode;
import com.streamscape.lib.evqueue.EventQueue;
import com.streamscape.lib.evqueue.EventQueueException;
import com.streamscape.lib.evqueue.EventQueueInterruptException;
import com.streamscape.lib.evqueue.EventQueueListener;
import com.streamscape.lib.evqueue.FlowControlMode;
import com.streamscape.lib.evqueue.IllegalQueueStateException;
import com.streamscape.lib.evqueue.NotificationListener;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.FilterFormatException;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.parser.SelectorParser;
import com.streamscape.sdo.ImmutableEventDatagram;

public class EventAsyncConsumerImpl
extends EventConsumerImpl
implements EventAsyncConsumer,
EventQueueListener<ImmutableEventDatagram> {
    protected EventQueue<ImmutableEventDatagram> eventQueue;

    protected EventAsyncConsumerImpl(String consumerName, String eventFilter, String eventSelector, EventListener listener) throws FilterFormatException, SelectorFormatException {
        this(consumerName, new CompositeFilter(eventFilter), eventSelector, listener);
    }

    @Override
    public NotificationListener getNotificationListener() {
        return this.eventQueue.getNotificationListener();
    }

    @Override
    public void setNotificationListener(NotificationListener notificationListener) {
        this.eventQueue.setNotificationListener(notificationListener);
    }

    @Override
    public int getMaxDepth() {
        return this.eventQueue.getMaxDepth();
    }

    @Override
    public void setMaxDepth(int maxDepth) {
        this.eventQueue.setMaxDepth(maxDepth);
    }

    @Override
    public FlowControlMode getFlowControlMode() {
        return this.eventQueue.getFlowControlMode();
    }

    @Override
    public void setFlowControlMode(FlowControlMode flowControlMode) {
        this.eventQueue.setFlowControlMode(flowControlMode);
    }

    @Override
    public DeliveryMode getDeliveryMode() {
        return this.eventQueue.getDeliveryMode();
    }

    @Override
    public void setDeliveryMode(DeliveryMode deliveryMode) throws IllegalQueueStateException {
        this.eventQueue.setDeliveryMode(deliveryMode);
    }

    @Override
    public long getDeliverySpinWait() {
        return this.eventQueue.getDeliverySpinWait();
    }

    @Override
    public void setDeliverySpinWait(long deliverySpinWait) {
        this.eventQueue.setDeliverySpinWait(deliverySpinWait);
    }

    @Override
    public void onObject(ImmutableEventDatagram object) {
        try {
            this.listener.onEvent(object);
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Asynchronous processing of event [" + object.getEventId() + "] failed.");
        }
    }

    @Override
    public void start() {
        this.eventQueue.start();
    }

    @Override
    public void stop() {
        this.eventQueue.stop();
    }

    @Override
    public void stopDelayed(long timeout) {
        this.eventQueue.stopDelayed(timeout);
    }

    @Override
    public boolean isStarted() {
        return this.eventQueue.isStarted();
    }

    @Override
    public void suspend() {
        this.eventQueue.suspend();
    }

    @Override
    public void resume() {
        this.eventQueue.resume();
    }

    @Override
    public boolean isSuspended() {
        return this.eventQueue.isSuspended();
    }

    @Override
    public void clear() {
        this.eventQueue.clear();
    }

    @Override
    public int getCurrentDepth() {
        return this.eventQueue.size();
    }

    @Override
    public ImmutableEventDatagram receive() throws EventQueueInterruptException {
        return this.eventQueue.dequeue();
    }

    @Override
    public ImmutableEventDatagram receive(long waitTime) throws EventQueueInterruptException {
        return this.eventQueue.dequeue(waitTime);
    }

    @Override
    public ImmutableEventDatagram receiveNoWait() {
        return this.eventQueue.dequeueNoWait();
    }

    @Override
    public ImmutableEventDatagram receive(String eventSelector) throws SelectorFormatException, EventQueueInterruptException {
        return this.doReceive(SelectorParser.parse(eventSelector));
    }

    protected ImmutableEventDatagram doReceive(SelectorExpression selectorExpression) throws EventQueueInterruptException {
        return this.eventQueue.dequeue(selectorExpression::matches);
    }

    @Override
    public ImmutableEventDatagram receive(String eventSelector, long timeout) throws SelectorFormatException, EventQueueInterruptException {
        return this.doReceive(SelectorParser.parse(eventSelector), timeout);
    }

    protected ImmutableEventDatagram doReceive(SelectorExpression selectorExpression, long timeout) throws EventQueueInterruptException {
        return this.eventQueue.dequeue(selectorExpression::matches, timeout);
    }

    @Override
    public ImmutableEventDatagram receiveNoWait(String eventSelector) throws SelectorFormatException {
        return this.doReceiveNoWait(SelectorParser.parse(eventSelector));
    }

    protected ImmutableEventDatagram doReceiveNoWait(SelectorExpression selectorExpression) {
        return this.eventQueue.dequeueNoWait(selectorExpression::matches);
    }

    @Override
    protected void processEvent(ImmutableEventDatagram event) throws EventDispatcherException {
        try {
            this.eventQueue.enqueue(event);
        }
        catch (EventQueueException exception) {
            throw new EventDispatcherException("Processing of event [" + event.getEventId() + "] failed.", exception);
        }
    }

    protected EventAsyncConsumerImpl(String consumerName, String eventFilter, EventListener listener) throws FilterFormatException {
        this(consumerName, new CompositeFilter(eventFilter), listener);
    }

    protected EventAsyncConsumerImpl(String consumerName, CompositeFilter eventFilter, EventListener listener) {
        super(consumerName, eventFilter, listener);
        this.eventQueue = listener != null ? new EventQueue<ImmutableEventDatagram>(consumerName, this) : new EventQueue(consumerName);
    }

    protected EventAsyncConsumerImpl(String consumerName, CompositeFilter eventFilter, String eventSelector, EventListener listener) throws SelectorFormatException {
        super(consumerName, eventFilter, eventSelector, listener);
        this.eventQueue = listener != null ? new EventQueue<ImmutableEventDatagram>(consumerName, this) : new EventQueue(consumerName);
    }

    @Override
    protected String getPrefix() {
        return "Async";
    }
}

