/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.dispatcher;

import com.streamscape.lib.dispatcher.AbstractDataConstraint;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.enums.DomainConstraintType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DomainConstraint
extends AbstractDataConstraint {
    public static final String MODEL = "Domain";
    protected DomainConstraintType type = DomainConstraintType.UNDEFINED;
    protected HashSet<String> stringValues = new HashSet();
    protected HashSet<Byte> byteValues = new HashSet();
    protected HashSet<Short> shortValues = new HashSet();
    protected HashSet<Integer> intValues = new HashSet();
    protected HashSet<Long> longValues = new HashSet();
    protected HashSet<Float> floatValues = new HashSet();
    protected HashSet<Double> doubleValues = new HashSet();
    protected HashSet<BigDecimal> bigDecimalValues = new HashSet();
    protected HashSet<Long> dateValues = new HashSet();
    private static final Predicate<Number> BYTE_CHECKER = value -> DomainConstraint.matchesRange(value, (byte)-128, (byte)127);
    private static final Predicate<Number> SHORT_CHECKER = value -> DomainConstraint.matchesRange(value, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    private static final Predicate<Number> INT_CHECKER = value -> DomainConstraint.matchesRange(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    private static final Predicate<Number> LONG_CHECKER = value -> DomainConstraint.matchesRange(value, Long.MIN_VALUE, Long.MAX_VALUE);
    private static final Predicate<Number> FLOAT_CHECKER = value -> DomainConstraint.matchesRange(value, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    private static final Predicate<Number> DOUBLE_CHECKER = value -> DomainConstraint.matchesRange(value, Double.MIN_VALUE, Double.MAX_VALUE);

    public DomainConstraint(String name, String description, Set<Object> values) {
        super(name, description);
        this.addValues(values);
    }

    @Override
    public String getModel() {
        return MODEL;
    }

    @Override
    public boolean matchesValue(Object value) {
        if (value instanceof String) {
            return this.containsStringValue((String)value);
        }
        if (value instanceof Date) {
            return this.containsDateValue((Date)value);
        }
        if (value instanceof Number) {
            return value instanceof Long && this.containsDateValue((Long)value) || this.containsNumericValue((Number)value);
        }
        return false;
    }

    public DomainConstraintType getType() {
        return this.type;
    }

    public synchronized void addValues(Set<Object> values) {
        if (values != null) {
            values.forEach(value -> {
                if (value instanceof String) {
                    this.addStringValue((String)value);
                } else if (value instanceof Byte) {
                    this.addByteValue((Byte)value);
                } else if (value instanceof Short) {
                    this.addShortValue((Short)value);
                } else if (value instanceof Integer) {
                    this.addIntValue((Integer)value);
                } else if (value instanceof Long) {
                    this.addLongValue((Long)value);
                } else if (value instanceof Float) {
                    this.addFloatValue(((Float)value).floatValue());
                } else if (value instanceof Double) {
                    this.addDoubleValue((Double)value);
                } else if (value instanceof BigDecimal) {
                    this.addBigDecimalValue((BigDecimal)value);
                } else if (value instanceof Date) {
                    this.addDateValue((Date)value);
                }
            });
        }
    }

    public synchronized void removeValues(Set<Object> values) {
        if (values != null) {
            values.forEach(value -> {
                if (value instanceof String) {
                    this.removeStringValue((String)value);
                } else if (value instanceof Byte) {
                    this.removeByteValue((Byte)value);
                } else if (value instanceof Short) {
                    this.removeShortValue((Short)value);
                } else if (value instanceof Integer) {
                    this.removeIntValue((Integer)value);
                } else if (value instanceof Long) {
                    this.removeLongValue((Long)value);
                } else if (value instanceof Float) {
                    this.removeFloatValue(((Float)value).floatValue());
                } else if (value instanceof Double) {
                    this.removeDoubleValue((Double)value);
                } else if (value instanceof BigDecimal) {
                    this.removeBigDecimalValue((BigDecimal)value);
                } else if (value instanceof Date) {
                    this.removeDateValue((Date)value);
                }
            });
        }
    }

    public List<Object> listValues() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.stringValues);
        result.addAll(this.byteValues);
        result.addAll(this.shortValues);
        result.addAll(this.intValues);
        result.addAll(this.longValues);
        result.addAll(this.floatValues);
        result.addAll(this.doubleValues);
        result.addAll(this.bigDecimalValues);
        result.addAll(this.listDateValues());
        return result;
    }

    public synchronized void addStringValue(String value) {
        this.stringValues.add(value);
        this.onValueAdd(DomainConstraintType.STRING);
    }

    public synchronized void removeStringValue(String value) {
        this.stringValues.remove(value);
        this.onValueRemove(DomainConstraintType.STRING, this.stringValues.isEmpty());
    }

    public boolean containsStringValue(String value) {
        return this.stringValues.contains(value);
    }

    public List<String> listStringValues() {
        return new ArrayList<String>(this.stringValues);
    }

    public synchronized void addByteValue(byte value) {
        this.byteValues.add(value);
        this.onValueAdd(DomainConstraintType.BYTE);
    }

    public synchronized void removeByteValue(byte value) {
        this.byteValues.remove(value);
        this.onValueRemove(DomainConstraintType.BYTE, this.byteValues.isEmpty());
    }

    public boolean containsByteValue(byte value) {
        return this.byteValues.contains(value);
    }

    public List<Byte> listByteValues() {
        return new ArrayList<Byte>(this.byteValues);
    }

    public synchronized void addShortValue(short value) {
        this.shortValues.add(value);
        this.onValueAdd(DomainConstraintType.SHORT);
    }

    public synchronized void removeShortValue(short value) {
        this.shortValues.remove(value);
        this.onValueRemove(DomainConstraintType.SHORT, this.shortValues.isEmpty());
    }

    public boolean containsShortValue(short value) {
        return this.shortValues.contains(value);
    }

    public List<Short> listShortValues() {
        return new ArrayList<Short>(this.shortValues);
    }

    public synchronized void addIntValue(int value) {
        this.intValues.add(value);
        this.onValueAdd(DomainConstraintType.INTEGER);
    }

    public synchronized void removeIntValue(int value) {
        this.intValues.remove(value);
        this.onValueRemove(DomainConstraintType.INTEGER, this.intValues.isEmpty());
    }

    public boolean containsIntValue(int value) {
        return this.intValues.contains(value);
    }

    public List<Integer> listIntValues() {
        return new ArrayList<Integer>(this.intValues);
    }

    public synchronized void addLongValue(long value) {
        this.longValues.add(value);
        this.onValueAdd(DomainConstraintType.LONG);
    }

    public synchronized void removeLongValue(long value) {
        this.longValues.remove(value);
        this.onValueRemove(DomainConstraintType.LONG, this.longValues.isEmpty());
    }

    public boolean containsLongValue(long value) {
        return this.longValues.contains(value);
    }

    public List<Long> listLongValues() {
        return new ArrayList<Long>(this.longValues);
    }

    public synchronized void addFloatValue(float value) {
        this.floatValues.add(Float.valueOf(value));
        this.onValueAdd(DomainConstraintType.FLOAT);
    }

    public synchronized void removeFloatValue(float value) {
        this.floatValues.remove(Float.valueOf(value));
        this.onValueRemove(DomainConstraintType.FLOAT, this.floatValues.isEmpty());
    }

    public boolean containsFloatValue(float value) {
        return this.floatValues.contains(Float.valueOf(value));
    }

    public List<Float> listFloatValues() {
        return new ArrayList<Float>(this.floatValues);
    }

    public synchronized void addDoubleValue(double value) {
        this.doubleValues.add(value);
        this.onValueAdd(DomainConstraintType.DOUBLE);
    }

    public synchronized void removeDoubleValue(double value) {
        this.doubleValues.remove(value);
        this.onValueRemove(DomainConstraintType.DOUBLE, this.doubleValues.isEmpty());
    }

    public boolean containsDoubleValue(double value) {
        return this.doubleValues.contains(value);
    }

    public List<Double> listDoubleValues() {
        return new ArrayList<Double>(this.doubleValues);
    }

    public synchronized void addBigDecimalValue(BigDecimal value) {
        this.bigDecimalValues.add(value);
        this.onValueAdd(DomainConstraintType.BIG_DECIMAL);
    }

    public synchronized void removeBigDecimalValue(BigDecimal value) {
        this.bigDecimalValues.remove(value);
        this.onValueRemove(DomainConstraintType.BIG_DECIMAL, this.bigDecimalValues.isEmpty());
    }

    public boolean containsBigDecimalValue(BigDecimal value) {
        return this.bigDecimalValues.contains(value);
    }

    public List<BigDecimal> listBigDecimalValues() {
        return new ArrayList<BigDecimal>(this.bigDecimalValues);
    }

    public synchronized void addDateValue(Date value) {
        this.dateValues.add(value.getTime());
        this.onValueAdd(DomainConstraintType.DATE);
    }

    public synchronized void removeDateValue(Date value) {
        this.dateValues.remove(value.getTime());
        this.onValueRemove(DomainConstraintType.DATE, this.dateValues.isEmpty());
    }

    public boolean containsDateValue(Date value) {
        return this.dateValues.contains(value.getTime());
    }

    public List<Date> listDateValues() {
        return this.dateValues.stream().map(Date::new).collect(Collectors.toList());
    }

    public synchronized void clear() {
        this.stringValues.clear();
        this.byteValues.clear();
        this.shortValues.clear();
        this.intValues.clear();
        this.longValues.clear();
        this.floatValues.clear();
        this.doubleValues.clear();
        this.bigDecimalValues.clear();
        this.dateValues.clear();
        this.type = DomainConstraintType.UNDEFINED;
    }

    @Override
    public DomainConstraint clone() {
        DomainConstraint result = (DomainConstraint)super.clone();
        result.stringValues = this.stringValues != null ? (HashSet)this.stringValues.clone() : null;
        result.byteValues = this.byteValues != null ? (HashSet)this.byteValues.clone() : null;
        result.shortValues = this.shortValues != null ? (HashSet)this.shortValues.clone() : null;
        result.intValues = this.intValues != null ? (HashSet)this.intValues.clone() : null;
        result.longValues = this.longValues != null ? (HashSet)this.longValues.clone() : null;
        result.floatValues = this.floatValues != null ? (HashSet)this.floatValues.clone() : null;
        result.doubleValues = this.doubleValues != null ? (HashSet)this.doubleValues.clone() : null;
        result.bigDecimalValues = this.bigDecimalValues != null ? (HashSet)this.bigDecimalValues.clone() : null;
        result.dateValues = this.dateValues != null ? (HashSet)this.dateValues.clone() : null;
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DomainConstraint) {
            DomainConstraint otherDomain = (DomainConstraint)other;
            return super.equals(other) && Utils.equalsNullSafe((Object)this.type, (Object)otherDomain.type) && Utils.equalsNullSafe(this.stringValues, otherDomain.stringValues) && Utils.equalsNullSafe(this.byteValues, otherDomain.byteValues) && Utils.equalsNullSafe(this.shortValues, otherDomain.shortValues) && Utils.equalsNullSafe(this.intValues, otherDomain.intValues) && Utils.equalsNullSafe(this.longValues, otherDomain.longValues) && Utils.equalsNullSafe(this.floatValues, otherDomain.floatValues) && Utils.equalsNullSafe(this.doubleValues, otherDomain.doubleValues) && Utils.equalsNullSafe(this.bigDecimalValues, otherDomain.bigDecimalValues) && Utils.equalsNullSafe(this.dateValues, otherDomain.dateValues);
        }
        return false;
    }

    boolean containsDateValue(long value) {
        return this.dateValues.contains(value);
    }

    private boolean containsNumericValue(Number value) {
        try {
            if (value instanceof Byte) {
                return this.doContainsByteValue((Byte)value);
            }
            if (value instanceof Short) {
                return this.doContainsShortValue((Short)value);
            }
            if (value instanceof Integer) {
                return this.doContainsIntValue((Integer)value);
            }
            if (value instanceof Long) {
                return this.doContainsLongValue((Long)value);
            }
            if (value instanceof Float) {
                return this.doContainsFloatValue((Float)value);
            }
            if (value instanceof Double) {
                return this.doContainsDoubleValue((Double)value);
            }
            if (value instanceof BigDecimal) {
                return this.doContainsBigDecimalValue((BigDecimal)value);
            }
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return false;
    }

    private boolean doContainsByteValue(Byte value) {
        return this.byteValues.contains(value) || this.shortValues.contains(value.shortValue()) || this.intValues.contains(value.intValue()) || this.longValues.contains(value.longValue()) || this.floatValues.contains(Float.valueOf(value.floatValue())) || this.doubleValues.contains(value.doubleValue()) || this.bigDecimalValues.contains(BigDecimal.valueOf(value.byteValue()));
    }

    private boolean doContainsShortValue(Short value) {
        return this.shortValues.contains(value) || this.doContainsByteValue(value) || this.intValues.contains(value.intValue()) || this.longValues.contains(value.longValue()) || this.floatValues.contains(Float.valueOf(value.floatValue())) || this.doubleValues.contains(value.doubleValue()) || this.bigDecimalValues.contains(BigDecimal.valueOf(value.shortValue()));
    }

    private boolean doContainsIntValue(Integer value) {
        return this.intValues.contains(value) || this.doContainsByteValue(value) || this.doContainsShortValue(value) || this.longValues.contains(value.longValue()) || this.floatValues.contains(Float.valueOf(value.floatValue())) || this.doubleValues.contains(value.doubleValue()) || this.bigDecimalValues.contains(BigDecimal.valueOf(value.intValue()));
    }

    private boolean doContainsLongValue(Long value) {
        return this.longValues.contains(value) || this.doContainsByteValue(value) || this.doContainsShortValue(value) || this.doContainsIntValue(value) || this.floatValues.contains(Float.valueOf(value.floatValue())) || this.doubleValues.contains(value.doubleValue()) || this.bigDecimalValues.contains(BigDecimal.valueOf(value));
    }

    private boolean doContainsFloatValue(Float value) {
        return this.floatValues.contains(value) || this.doContainsByteValue(value) || this.doContainsShortValue(value) || this.doContainsIntValue(value) || this.doContainsLongValue(value) || this.doubleValues.contains(value.doubleValue()) || this.bigDecimalValues.contains(BigDecimal.valueOf(value.floatValue()).stripTrailingZeros());
    }

    private boolean doContainsDoubleValue(Double value) {
        return this.doubleValues.contains(value) || this.doContainsByteValue(value) || this.doContainsShortValue(value) || this.doContainsIntValue(value) || this.doContainsLongValue(value) || this.doContainsFloatValue(value) || this.bigDecimalValues.contains(BigDecimal.valueOf(value).stripTrailingZeros());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doContainsBigDecimalValue(BigDecimal value) {
        if (this.bigDecimalValues.contains(value)) return true;
        if (this.doContainsByteValue(value, value::byteValueExact)) return true;
        if (this.doContainsShortValue(value, value::shortValueExact)) return true;
        if (this.doContainsIntValue(value, value::intValueExact)) return true;
        if (this.doContainsLongValue(value, value::longValueExact)) return true;
        if (this.doContainsFloatValue(value)) return true;
        if (!this.doContainsDoubleValue(value)) return false;
        return true;
    }

    private <T extends Number> boolean doContainsByteValue(Number value) {
        return this.doContainsByteValue(value, value::byteValue);
    }

    private <T extends Number> boolean doContainsByteValue(Number value, Supplier<Byte> valueConverter) {
        return DomainConstraint.doContainsValue(value, this.byteValues, BYTE_CHECKER, valueConverter);
    }

    private <T extends Number> boolean doContainsShortValue(Number value) {
        return this.doContainsShortValue(value, value::shortValue);
    }

    private <T extends Number> boolean doContainsShortValue(Number value, Supplier<Short> valueConverter) {
        return DomainConstraint.doContainsValue(value, this.shortValues, SHORT_CHECKER, valueConverter);
    }

    private <T extends Number> boolean doContainsIntValue(Number value) {
        return this.doContainsIntValue(value, value::intValue);
    }

    private <T extends Number> boolean doContainsIntValue(Number value, Supplier<Integer> valueConverter) {
        return DomainConstraint.doContainsValue(value, this.intValues, INT_CHECKER, valueConverter);
    }

    private <T extends Number> boolean doContainsLongValue(Number value) {
        return this.doContainsLongValue(value, value::longValue);
    }

    private <T extends Number> boolean doContainsLongValue(Number value, Supplier<Long> valueConverter) {
        return DomainConstraint.doContainsValue(value, this.longValues, LONG_CHECKER, valueConverter);
    }

    private <T extends Number> boolean doContainsFloatValue(Number value) {
        return this.doContainsFloatValue(value, value::floatValue);
    }

    private <T extends Number> boolean doContainsFloatValue(Number value, Supplier<Float> valueConverter) {
        return DomainConstraint.doContainsValue(value, this.floatValues, FLOAT_CHECKER, valueConverter);
    }

    private <T extends Number> boolean doContainsDoubleValue(Number value) {
        return DomainConstraint.doContainsValue(value, this.doubleValues, DOUBLE_CHECKER, value::doubleValue);
    }

    private static <T extends Number> boolean doContainsValue(Number value, Set<T> values, Predicate<Number> rangeChecker, Supplier<T> converter) {
        if (!values.isEmpty() && rangeChecker.test(value)) {
            Number convertedValue = (Number)converter.get();
            return DomainConstraint.isProperlyConverted(value, convertedValue) && values.contains(convertedValue);
        }
        return false;
    }

    private static <T extends Number> boolean matchesRange(Number value, T min, T max) {
        double doubleValue = value.doubleValue();
        return min.doubleValue() <= doubleValue && doubleValue <= max.doubleValue();
    }

    private static <T extends Number> boolean isProperlyConverted(Number value, T convertedValue) {
        if (value instanceof Float) {
            return ((Float)value).floatValue() == (float)convertedValue.longValue();
        }
        if (value instanceof Double) {
            return convertedValue instanceof Float ? (Double)value == (double)convertedValue.floatValue() : (Double)value == (double)convertedValue.longValue();
        }
        if (value instanceof BigDecimal && (convertedValue instanceof Float || convertedValue instanceof Double)) {
            BigDecimal decimalValue = ((BigDecimal)value).stripTrailingZeros();
            if (convertedValue instanceof Float) {
                return decimalValue.equals(BigDecimal.valueOf(convertedValue.floatValue()).stripTrailingZeros());
            }
            if (convertedValue instanceof Double) {
                return decimalValue.equals(BigDecimal.valueOf(convertedValue.doubleValue()).stripTrailingZeros());
            }
        }
        return true;
    }

    private void onValueAdd(DomainConstraintType addedType) {
        if (this.type == DomainConstraintType.UNDEFINED) {
            this.type = addedType;
        } else if (this.type != addedType) {
            this.type = DomainConstraintType.MIXED;
        }
    }

    private void onValueRemove(DomainConstraintType removedType, boolean lastValue) {
        if (this.type == removedType) {
            if (lastValue) {
                this.type = DomainConstraintType.UNDEFINED;
            }
        } else if (this.type == DomainConstraintType.MIXED && lastValue) {
            DomainConstraintType domainConstraintType = this.type = !this.stringValues.isEmpty() ? DomainConstraintType.STRING : DomainConstraintType.UNDEFINED;
            if (this.type != DomainConstraintType.MIXED) {
                this.type = this.updateType(this.byteValues, DomainConstraintType.BYTE);
            }
            if (this.type != DomainConstraintType.MIXED) {
                this.type = this.updateType(this.shortValues, DomainConstraintType.SHORT);
            }
            if (this.type != DomainConstraintType.MIXED) {
                this.type = this.updateType(this.intValues, DomainConstraintType.INTEGER);
            }
            if (this.type != DomainConstraintType.MIXED) {
                this.type = this.updateType(this.longValues, DomainConstraintType.LONG);
            }
            if (this.type != DomainConstraintType.MIXED) {
                this.type = this.updateType(this.floatValues, DomainConstraintType.FLOAT);
            }
            if (this.type != DomainConstraintType.MIXED) {
                this.type = this.updateType(this.doubleValues, DomainConstraintType.DOUBLE);
            }
            if (this.type != DomainConstraintType.MIXED) {
                this.type = this.updateType(this.bigDecimalValues, DomainConstraintType.BIG_DECIMAL);
            }
            if (this.type != DomainConstraintType.MIXED) {
                this.type = this.updateType(this.dateValues, DomainConstraintType.DATE);
            }
        }
    }

    private <T> DomainConstraintType updateType(Set<T> values, DomainConstraintType valuesType) {
        return values.isEmpty() ? this.type : (this.type == DomainConstraintType.UNDEFINED ? valuesType : DomainConstraintType.MIXED);
    }
}

