/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.dispatcher;

import com.streamscape.lib.dispatcher.DataConstraint;
import com.streamscape.lib.dispatcher.DomainConstraint;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.lib.dispatcher.RangeConstraint;
import com.streamscape.lib.selector.SelectorInValues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DataConstraintStore
implements SelectorInValues {
    protected Values<DomainConstraint> domains = new Values("Domain");
    protected Values<RangeConstraint> ranges = new Values("Range");

    @Override
    public boolean matchesDomain(String domainName, Object value) {
        return this.domains.matchesValue(domainName, value);
    }

    public DomainConstraint createDomain(String name, String description, Set<Object> values) throws EventDispatcherException {
        DomainConstraint result = this.createDomainInstance(name, description, values);
        this.addDomain(result);
        return result;
    }

    protected DomainConstraint createDomainInstance(String name, String description, Set<Object> values) {
        return new DomainConstraint(name, description, values);
    }

    protected synchronized void addDomain(DomainConstraint domain) throws EventDispatcherException {
        this.domains.addValue(domain, this.domains::checkUniqueness);
    }

    public synchronized DomainConstraint dropDomain(String name) {
        return this.domains.removeValue(name);
    }

    public DomainConstraint getDomain(String name) {
        return this.domains.getValueByExactName(name);
    }

    public List<DomainConstraint> getDomains() {
        return this.domains.getValues();
    }

    public List<DomainConstraint> getDomains(String pattern) {
        return this.domains.getValues(pattern);
    }

    public List<String> listDomains() {
        return this.domains.listValues();
    }

    @Override
    public boolean matchesRange(String rangeName, Object value) {
        return this.ranges.matchesValue(rangeName, value);
    }

    public synchronized RangeConstraint createRange(String name, String description, Object minValue, Object maxValue) throws EventDispatcherException {
        RangeConstraint result = this.createRangeInstance(name, description, minValue, maxValue);
        this.addRange(result);
        return result;
    }

    protected RangeConstraint createRangeInstance(String name, String description, Object minValue, Object maxValue) throws EventDispatcherException {
        return new RangeConstraint(name, description, minValue, maxValue);
    }

    protected synchronized void addRange(RangeConstraint range) throws EventDispatcherException {
        this.ranges.addValue(range, this.ranges::checkUniqueness);
    }

    public synchronized RangeConstraint dropRange(String name) {
        return this.ranges.removeValue(name);
    }

    public RangeConstraint getRange(String name) {
        return this.ranges.getValueByExactName(name);
    }

    public List<RangeConstraint> getRanges() {
        return this.ranges.getValues();
    }

    public List<RangeConstraint> getRanges(String pattern) {
        return this.ranges.getValues(pattern);
    }

    public List<String> listRanges() {
        return this.ranges.listValues();
    }

    protected synchronized void clear() {
        this.domains.clear();
        this.ranges.clear();
    }

    protected static class Values<Constraint extends DataConstraint> {
        private String model;
        private Map<String, Constraint> simpleValues = new ConcurrentHashMap<String, Constraint>();
        private Map<String, Map<String, Constraint>> typedValues = new ConcurrentHashMap<String, Map<String, Constraint>>();

        Values(String model) {
            this.model = model;
        }

        public void addValue(Constraint value, UniquenessChecker uniquenessChecker) throws EventDispatcherException {
            ConstraintName name = ConstraintName.parseName(value.getName());
            if (uniquenessChecker != null) {
                uniquenessChecker.check(name);
            }
            if (name.isSimple()) {
                this.simpleValues.put(name.getName(), value);
            } else {
                Map typeValues = this.typedValues.computeIfAbsent(name.getType(), ignored -> new ConcurrentHashMap());
                typeValues.put(name.getName(), value);
            }
        }

        public Constraint removeValue(String fullName) {
            DataConstraint result = null;
            ConstraintName name = ConstraintName.parseName(fullName);
            if (name.isSimple()) {
                result = (DataConstraint)this.simpleValues.remove(name.getName());
            } else {
                Map<String, Constraint> typeValues = this.typedValues.get(name.getType());
                if (typeValues != null) {
                    result = (DataConstraint)typeValues.remove(name.getName());
                    if (typeValues.isEmpty()) {
                        this.typedValues.remove(name.getType());
                    }
                }
            }
            return (Constraint)result;
        }

        void clear() {
            this.simpleValues.clear();
            this.typedValues.clear();
        }

        List<Constraint> getValues() {
            ArrayList result = new ArrayList(this.simpleValues.values());
            this.typedValues.forEach((key, value) -> result.addAll(value.values()));
            return result;
        }

        List<String> listValues() {
            ArrayList<String> result = new ArrayList<String>(this.simpleValues.keySet());
            this.typedValues.forEach((key, value) -> result.addAll(value.keySet()));
            return result;
        }

        Constraint getValueByExactName(String fullName) {
            ConstraintName name = ConstraintName.parseName(fullName);
            if (name.isSimple()) {
                return (Constraint)((DataConstraint)this.simpleValues.get(name.getName()));
            }
            Map<String, Constraint> typeValues = this.typedValues.get(name.getType());
            return (Constraint)(typeValues != null ? (DataConstraint)typeValues.get(name.getName()) : null);
        }

        List<Constraint> getValues(String pattern) {
            ConstraintName name = ConstraintName.parseNameAndNormalize(pattern);
            ArrayList result = new ArrayList();
            if (name.isSimple()) {
                this.getValuesByPattern(name.name, this.simpleValues, result);
            } else {
                List<Map<String, Constraint>> valuesByType = this.getValuesByType(name.type);
                valuesByType.forEach(values -> this.getValuesByPattern(name.name, (Map<String, Constraint>)values, result));
            }
            return result;
        }

        boolean matchesValue(String fullName, Object value) {
            return this.matchesValue(ConstraintName.parseNameAndNormalize(fullName), value);
        }

        boolean matchesValue(ConstraintName name, Object value) {
            if (name.isSimple()) {
                return this.matchesValue(name.name, value, this.simpleValues);
            }
            List<Map<String, Constraint>> valuesByType = this.getValuesByType(name.type);
            return valuesByType.stream().anyMatch(values -> this.matchesValue(name.name, value, (Map<String, Constraint>)values));
        }

        private boolean matchesValue(ConstraintName.Item name, Object value, Map<String, Constraint> values) {
            if (name.isWildcard) {
                return values.values().stream().anyMatch(constraint -> constraint.matchesValue(value));
            }
            if (name.pattern != null) {
                return values.entrySet().stream().filter(entry -> name.pattern.matcher((CharSequence)entry.getKey()).matches()).anyMatch(entry -> ((DataConstraint)entry.getValue()).matchesValue(value));
            }
            DataConstraint constraint2 = (DataConstraint)values.get(name.name);
            return constraint2 != null && constraint2.matchesValue(value);
        }

        private void getValuesByPattern(ConstraintName.Item name, Map<String, Constraint> values, List<Constraint> result) {
            if (name.isWildcard) {
                result.addAll(values.values());
            } else if (name.pattern != null) {
                values.entrySet().stream().filter(entry -> name.pattern.matcher((CharSequence)entry.getKey()).matches()).forEach(entry -> result.add((DataConstraint)entry.getValue()));
            } else {
                DataConstraint constraint = (DataConstraint)values.get(name.name);
                if (constraint != null) {
                    result.add(constraint);
                }
            }
        }

        private List<Map<String, Constraint>> getValuesByType(ConstraintName.Item type) {
            if (type.isWildcard) {
                ArrayList<Map<String, Constraint>> result = new ArrayList<Map<String, Constraint>>();
                result.add(this.simpleValues);
                result.addAll(this.typedValues.values());
                return result;
            }
            if (type.pattern != null) {
                return this.typedValues.entrySet().stream().filter(entry -> type.pattern.matcher((CharSequence)entry.getKey()).matches()).map(Map.Entry::getValue).collect(Collectors.toList());
            }
            Map<String, Constraint> values = this.typedValues.get(type.name);
            return values != null ? Collections.singletonList(values) : Collections.emptyList();
        }

        void checkUniqueness(ConstraintName name) throws EventDispatcherException {
            if (name.isSimple()) {
                this.checkUniqueness(name, this.simpleValues);
            } else {
                Map<String, Constraint> typeValues = this.typedValues.get(name.getType());
                if (typeValues != null) {
                    this.checkUniqueness(name, typeValues);
                }
            }
        }

        private void checkUniqueness(ConstraintName name, Map<String, Constraint> values) throws EventDispatcherException {
            if (values.containsKey(name.getName())) {
                throw new EventDispatcherException(this.model + " '" + name.getName() + "' already exists.");
            }
        }
    }

    private static interface UniquenessChecker {
        public void check(ConstraintName var1) throws EventDispatcherException;
    }

    static class ConstraintName {
        private static final String ASTERISK = "*";
        private static final String PERCENT = "%";
        Item type;
        Item name;

        ConstraintName(String name) {
            this(null, name);
        }

        ConstraintName(String type, String name) {
            if (type != null) {
                this.type = new Item(type);
            }
            this.name = new Item(name);
        }

        String getType() {
            return this.type.name;
        }

        String getName() {
            return this.name.name;
        }

        boolean isSimple() {
            return this.type == null;
        }

        static String toString(String type, String name) {
            return type + "." + name;
        }

        static ConstraintName parseName(String fullName) {
            String[] items = fullName.split("\\.");
            return items.length == 1 ? new ConstraintName(items[0]) : new ConstraintName(items[0], items[1]);
        }

        static ConstraintName parseNameAndNormalize(String fullName) {
            ConstraintName result = ConstraintName.parseName(fullName);
            result.normalize();
            return result;
        }

        private void normalize() {
            if (this.type != null) {
                this.doNormalize(this.type);
            }
            this.doNormalize(this.name);
        }

        private void doNormalize(Item item) {
            if (ConstraintName.isWildcard(item.name)) {
                item.isWildcard = true;
            } else if (ConstraintName.containsWildcard(item.name)) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < item.name.length(); ++i) {
                    char c = item.name.charAt(i);
                    if (c == '*' || c == '%') {
                        builder.append(".*?");
                        continue;
                    }
                    builder.append(c);
                }
                item.pattern = Pattern.compile(builder.toString());
            }
        }

        private static boolean isWildcard(String name) {
            return name.equals(ASTERISK) || name.equals(PERCENT);
        }

        private static boolean containsWildcard(String name) {
            return name.contains(ASTERISK) || name.contains(PERCENT);
        }

        static class Item {
            String name;
            boolean isWildcard;
            Pattern pattern;

            Item(String name) {
                this.name = name;
            }
        }
    }
}

